/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util.component;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.ExecutorServiceManager;
import org.apache.camel.spi.ThreadPoolProfile;
import org.apache.camel.spi.UriParam;
import org.apache.camel.util.EndpointHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.component.ApiMethod;
import org.apache.camel.util.component.ApiMethodHelper;
import org.apache.camel.util.component.ApiMethodPropertiesHelper;
import org.apache.camel.util.component.ApiName;
import org.apache.camel.util.component.PropertiesInterceptor;
import org.apache.camel.util.component.PropertyNamesInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractApiEndpoint<E extends ApiName, T>
extends DefaultEndpoint
implements PropertyNamesInterceptor,
PropertiesInterceptor {
    private static Map<String, ExecutorService> executorServiceMap = new ConcurrentHashMap<String, ExecutorService>();
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final E apiName;
    protected final String methodName;
    protected final ApiMethodHelper<? extends ApiMethod> methodHelper;
    @UriParam
    protected final T configuration;
    @UriParam
    protected String inBody;
    private List<ApiMethod> candidates;
    private ExecutorService executorService;
    private Set<String> endpointPropertyNames;
    private Map<String, Object> endpointProperties;

    public AbstractApiEndpoint(String endpointUri, Component component, E apiName, String methodName, ApiMethodHelper<? extends ApiMethod> methodHelper, T endpointConfiguration) {
        super(endpointUri, component);
        this.apiName = apiName;
        this.methodName = methodName;
        this.methodHelper = methodHelper;
        this.configuration = endpointConfiguration;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    protected abstract ApiMethodPropertiesHelper<T> getPropertiesHelper();

    @Override
    public void configureProperties(Map<String, Object> options) {
        super.configureProperties(options);
        try {
            T configuration = this.getConfiguration();
            EndpointHelper.setReferenceProperties(this.getCamelContext(), configuration, options);
            EndpointHelper.setProperties(this.getCamelContext(), configuration, options);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        this.initState();
        this.afterConfigureProperties();
    }

    protected abstract void afterConfigureProperties();

    private void initState() {
        Set<String> missing;
        this.endpointPropertyNames = Collections.unmodifiableSet(this.getPropertiesHelper().getEndpointPropertyNames(this.configuration));
        HashMap<String, Object> properties = new HashMap<String, Object>();
        this.getPropertiesHelper().getEndpointProperties(this.configuration, properties);
        this.endpointProperties = Collections.unmodifiableMap(properties);
        HashSet<String> arguments = new HashSet<String>();
        arguments.addAll(this.endpointPropertyNames);
        if (this.inBody != null) {
            arguments.add(this.inBody);
        }
        this.interceptPropertyNames(arguments);
        String[] argNames = arguments.toArray(new String[arguments.size()]);
        this.candidates = new ArrayList<ApiMethod>();
        this.candidates.addAll(this.methodHelper.getCandidateMethods(this.methodName, argNames));
        this.candidates = Collections.unmodifiableList(this.candidates);
        if (this.candidates.isEmpty()) {
            throw new IllegalArgumentException(String.format("No matching method for %s/%s, with arguments %s", this.apiName.getName(), this.methodName, arguments));
        }
        if (this.log.isDebugEnabled() && !(missing = this.methodHelper.getMissingProperties(this.methodName, arguments)).isEmpty()) {
            this.log.debug("Method {} could use one or more properties from {}", (Object)this.methodName, missing);
        }
    }

    @Override
    public void interceptPropertyNames(Set<String> propertyNames) {
    }

    @Override
    public void interceptProperties(Map<String, Object> properties) {
    }

    public final T getConfiguration() {
        return this.configuration;
    }

    public final E getApiName() {
        return this.apiName;
    }

    public final String getMethodName() {
        return this.methodName;
    }

    public final ApiMethodHelper<? extends ApiMethod> getMethodHelper() {
        return this.methodHelper;
    }

    public final List<ApiMethod> getCandidates() {
        return this.candidates;
    }

    public final String getInBody() {
        return this.inBody;
    }

    public final void setInBody(String inBody) throws IllegalArgumentException {
        ObjectHelper.notNull(inBody, "inBody");
        if (!this.getPropertiesHelper().getValidEndpointProperties(this.getConfiguration()).contains(inBody)) {
            throw new IllegalArgumentException("Unknown property " + inBody);
        }
        this.inBody = inBody;
    }

    public final Set<String> getEndpointPropertyNames() {
        return this.endpointPropertyNames;
    }

    public final Map<String, Object> getEndpointProperties() {
        return this.endpointProperties;
    }

    public abstract Object getApiProxy(ApiMethod var1, Map<String, Object> var2);

    private static ExecutorService getExecutorService(Class<? extends AbstractApiEndpoint> endpointClass, CamelContext context, String threadProfileName) {
        String endpointClassName = endpointClass.getName();
        ExecutorService executorService = executorServiceMap.get(endpointClassName);
        if (executorService == null || executorService.isTerminated() || executorService.isShutdown()) {
            ExecutorServiceManager manager = context.getExecutorServiceManager();
            ThreadPoolProfile poolProfile = manager.getThreadPoolProfile(threadProfileName);
            if (poolProfile == null) {
                poolProfile = manager.getDefaultThreadPoolProfile();
            }
            executorService = manager.newScheduledThreadPool(endpointClass, threadProfileName, poolProfile);
            executorServiceMap.put(endpointClassName, executorService);
        }
        return executorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ExecutorService getExecutorService() {
        if (this.executorService == null) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                this.executorService = AbstractApiEndpoint.getExecutorService(this.getClass(), this.getCamelContext(), this.getThreadProfileName());
            }
        }
        return this.executorService;
    }

    protected abstract String getThreadProfileName();
}

