/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.domain;

import java.util.IdentityHashMap;
import java.util.List;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.PrimaryKeyJoinColumns;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.fao.geonet.domain.GeonetEntity;
import org.fao.geonet.domain.SchematronCriteriaGroup;
import org.fao.geonet.domain.SchematronCriteriaType;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.springframework.context.ApplicationContext;

@Entity
@Table(name="SchematronCriteria")
@Cacheable
@Access(value=AccessType.PROPERTY)
@SequenceGenerator(name="schematron_criteria_id_seq", initialValue=100, allocationSize=1)
public class SchematronCriteria
extends GeonetEntity {
    static final String ID_SEQ_NAME = "schematron_criteria_id_seq";
    static final String EL_UI_TYPE = "uitype";
    static final String EL_UI_VALUE = "uivalue";
    private int id;
    private SchematronCriteriaType type;
    private String value;
    private String uiType;
    private String uiValue;
    private SchematronCriteriaGroup group;

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="schematron_criteria_id_seq")
    public int getId() {
        return this.id;
    }

    public SchematronCriteria setId(int id) {
        this.id = id;
        return this;
    }

    public String toString() {
        return "SchematronCriteria [id=" + this.id + ", type=" + (Object)((Object)this.type) + ", value=" + this.value + "]";
    }

    @Column(nullable=false, name="type")
    @Enumerated(value=EnumType.STRING)
    public SchematronCriteriaType getType() {
        return this.type;
    }

    public void setType(SchematronCriteriaType type) {
        this.type = type;
    }

    @Column(nullable=false, name="value")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getUiType() {
        return this.uiType;
    }

    public void setUiType(String uiType) {
        this.uiType = uiType;
    }

    public String getUiValue() {
        return this.uiValue;
    }

    public void setUiValue(String uiValue) {
        this.uiValue = uiValue;
    }

    @ManyToOne(optional=false, fetch=FetchType.EAGER)
    @PrimaryKeyJoinColumns(value={@PrimaryKeyJoinColumn(referencedColumnName="name"), @PrimaryKeyJoinColumn(referencedColumnName="schematronId")})
    public SchematronCriteriaGroup getGroup() {
        return this.group;
    }

    public void setGroup(SchematronCriteriaGroup group) {
        this.group = group;
    }

    public boolean accepts(ApplicationContext applicationContext, int metadataId, Element metadata, List<Namespace> metadataNamespaces) {
        return this.getType().accepts(applicationContext, this.getValue(), metadataId, metadata, metadataNamespaces);
    }

    public boolean accepts(ApplicationContext applicationContext, Element metadata, List<Namespace> metadataNamespaces, Integer groupOwnerId) {
        return this.getType().accepts(applicationContext, this.getValue(), metadata, metadataNamespaces, groupOwnerId);
    }

    @Override
    protected Element asXml(IdentityHashMap<Object, Void> alreadyEncoded) {
        Element element = super.asXml(alreadyEncoded);
        String valueElText = element.getChildText("value");
        if (valueElText.length() == 0) {
            element.getChild("value").setText("''");
        }
        if (element.getChild(EL_UI_TYPE) == null) {
            element.addContent((Content)new Element(EL_UI_TYPE).setText(this.getType().toString()));
        }
        if (element.getChild(EL_UI_VALUE) == null) {
            element.addContent((Content)new Element(EL_UI_VALUE).setText(this.getValue()));
        }
        return element;
    }

    public SchematronCriteria copy() {
        SchematronCriteria copy = new SchematronCriteria();
        copy.setType(this.getType());
        copy.setUiType(this.getUiType());
        copy.setValue(this.getValue());
        copy.setUiValue(this.getUiValue());
        copy.setGroup(this.getGroup());
        return copy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchematronCriteria that = (SchematronCriteria)o;
        if (this.id != that.id) {
            return false;
        }
        if (this.type != that.type) {
            return false;
        }
        if (this.uiType != null ? !this.uiType.equals(that.uiType) : that.uiType != null) {
            return false;
        }
        if (this.uiValue != null ? !this.uiValue.equals(that.uiValue) : that.uiValue != null) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    public int hashCode() {
        int result = this.id;
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + (this.uiType != null ? this.uiType.hashCode() : 0);
        result = 31 * result + (this.uiValue != null ? this.uiValue.hashCode() : 0);
        return result;
    }
}

