/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.es;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import io.searchbox.action.Action;
import io.searchbox.action.BulkableAction;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestClientFactory;
import io.searchbox.client.JestResult;
import io.searchbox.client.JestResultHandler;
import io.searchbox.client.config.HttpClientConfig;
import io.searchbox.core.Bulk;
import io.searchbox.core.BulkResult;
import io.searchbox.core.DeleteByQuery;
import io.searchbox.core.Index;
import io.searchbox.indices.Analyze;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang.StringUtils;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.nio.conn.SchemeIOSessionStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.ssl.SSLContextBuilder;
import org.fao.geonet.utils.Log;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;

public class EsClient
implements InitializingBean {
    private static final String LOGGER_MODULE = "geonetwork.index";
    private static EsClient instance;
    private JestClient client;
    @Value(value="${es.url}")
    private String serverUrl;
    @Value(value="${es.username}")
    private String username;
    @Value(value="${es.password}")
    private String password;
    private boolean activated = false;
    @Value(value="${kb.url}")
    private String dashboardAppUrl;

    public static EsClient get() {
        return instance;
    }

    public JestClient getClient() throws Exception {
        return this.client;
    }

    public String getDashboardAppUrl() {
        return this.dashboardAppUrl;
    }

    public void setDashboardAppUrl(String dashboardAppUrl) {
        this.dashboardAppUrl = dashboardAppUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() throws Exception {
        if (StringUtils.isNotEmpty((String)this.serverUrl)) {
            JestClientFactory factory = new JestClientFactory();
            if (this.serverUrl.startsWith("https://")) {
                SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, (org.apache.http.ssl.TrustStrategy)new TrustStrategy(){

                    public boolean isTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                        return true;
                    }
                }).build();
                NoopHostnameVerifier hostnameVerifier = NoopHostnameVerifier.INSTANCE;
                SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)hostnameVerifier);
                SSLIOSessionStrategy httpsIOSessionStrategy = new SSLIOSessionStrategy(sslContext, (HostnameVerifier)hostnameVerifier);
                factory.setHttpClientConfig(((HttpClientConfig.Builder)((HttpClientConfig.Builder)new HttpClientConfig.Builder(this.serverUrl).defaultCredentials(this.username, this.password).multiThreaded(true)).sslSocketFactory((LayeredConnectionSocketFactory)sslSocketFactory).httpsIOSessionStrategy((SchemeIOSessionStrategy)httpsIOSessionStrategy).readTimeout(-1)).build());
            } else {
                factory.setHttpClientConfig(((HttpClientConfig.Builder)((HttpClientConfig.Builder)new HttpClientConfig.Builder(this.serverUrl).multiThreaded(true)).readTimeout(-1)).build());
            }
            this.client = factory.getObject();
            Class<EsClient> clazz = EsClient.class;
            synchronized (EsClient.class) {
                instance = this;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                this.activated = true;
            }
        } else {
            Log.debug((String)LOGGER_MODULE, (Object)String.format("No Elasticsearch URL defined '%s'. Check bean configuration. Statistics and dasboard will not be available.", this.serverUrl));
        }
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public EsClient setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
        return this;
    }

    public String getUsername() {
        return this.username;
    }

    public EsClient setUsername(String username) {
        this.username = username;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public EsClient setPassword(String password) {
        this.password = password;
        return this;
    }

    public boolean bulkRequest(String index, Map<String, String> docs) throws IOException {
        if (!this.activated) {
            return false;
        }
        boolean success = true;
        Bulk.Builder bulk = new Bulk.Builder().defaultIndex(index);
        for (Map.Entry<String, String> entry : docs.entrySet()) {
            bulk.addAction((BulkableAction)((Index.Builder)new Index.Builder((Object)entry.getValue()).id(entry.getKey())).build());
        }
        try {
            BulkResult result = (BulkResult)this.client.execute((Action)bulk.build());
            if (!result.isSucceeded()) {
                Log.warning((String)LOGGER_MODULE, (Object)("EsClient bulkRequest: " + result.getErrorMessage()));
                Log.warning((String)LOGGER_MODULE, (Object)("EsClient bulkRequest: " + result.getJsonString()));
                return false;
            }
        }
        catch (IOException e) {
            Log.error((String)LOGGER_MODULE, (Object)("EsClient bulkRequest: " + e.getMessage()), (Throwable)e);
            throw e;
        }
        return success;
    }

    public void bulkRequestAsync(Bulk.Builder bulk, JestResultHandler<BulkResult> handler) {
        this.client.executeAsync((Action)bulk.build(), handler);
    }

    public BulkResult bulkRequestSync(Bulk.Builder bulk) throws IOException {
        return (BulkResult)this.client.execute((Action)bulk.build());
    }

    public String deleteByQuery(String index, String query) throws Exception {
        if (!this.activated) {
            return "";
        }
        String searchQuery = "{\"query\": {\"query_string\": {\"query\": \"" + query + "\"}}}";
        DeleteByQuery deleteAll = ((DeleteByQuery.Builder)new DeleteByQuery.Builder(searchQuery).addIndex(index)).build();
        JestResult result = this.client.execute((Action)deleteAll);
        if (result.isSucceeded()) {
            return String.format("Record removed. %s.", result.getJsonString());
        }
        throw new IOException(String.format("Error during removal. Errors is '%s'.", result.getErrorMessage()));
    }

    public static String analyzeField(String collection, String analyzer, String fieldValue) {
        Analyze analyze = new Analyze.Builder().index(collection).analyzer(analyzer).text(fieldValue.replaceAll(",", "")).build();
        String analyzedValue = "";
        try {
            JestResult result = EsClient.get().getClient().execute((Action)analyze);
            if (result.isSucceeded()) {
                JsonObject token;
                String type;
                JsonArray tokens = result.getJsonObject().getAsJsonArray("tokens");
                if (tokens != null && tokens.size() == 1 && ("SYNONYM".equals(type = (token = tokens.get(0).getAsJsonObject()).get("type").getAsString()) || "word".equals(type))) {
                    return token.get("token").getAsString();
                }
                return "";
            }
            return "";
        }
        catch (Exception ex) {
            return "";
        }
    }

    protected void finalize() {
        this.client.shutdownClient();
    }
}

