/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.util;

import org.jzkit.a2j.codec.util.OIDRegister;
import org.jzkit.a2j.codec.util.OIDRegisterEntry;
import org.jzkit.search.util.RecordModel.ExplicitRecordFormatSpecification;

public class FormatSpecOIDHelper {
    public static int[] getOID(OIDRegister reg, ExplicitRecordFormatSpecification spec) {
        String encoding = spec.getEncoding().toString();
        if (encoding != null) {
            if (encoding.equals("iso2709")) {
                OIDRegisterEntry entry = reg.lookupByName(spec.getSchema().toString());
                return entry.getValue();
            }
            OIDRegisterEntry entry = reg.lookupByName(encoding);
            return entry.getValue();
        }
        return null;
    }

    public static ExplicitRecordFormatSpecification getSpec(OIDRegisterEntry entry, String esn, String profile) {
        if (entry.getName().equals("usmarc")) {
            return new ExplicitRecordFormatSpecification("iso2709:usmarc:" + esn);
        }
        if (entry.getName().equals("ukmarc")) {
            return new ExplicitRecordFormatSpecification("iso2709:ukmarc:" + esn);
        }
        if (entry.getName().equals("grs-1")) {
            return new ExplicitRecordFormatSpecification("grs-1:" + profile + ":" + esn);
        }
        if (entry.getName().equals("xml")) {
            return new ExplicitRecordFormatSpecification("xml:null:" + esn);
        }
        return null;
    }

    public static ExplicitRecordFormatSpecification getSpec(OIDRegister reg, int[] entry, String esn, String profile) {
        return FormatSpecOIDHelper.getSpec(reg.lookupByOID(entry), esn, profile);
    }
}

