/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.Adapter;
import bak.pcj.FloatIterator;
import bak.pcj.adapter.IteratorToFloatIteratorAdapter;
import bak.pcj.set.AbstractFloatSet;
import bak.pcj.set.FloatSet;
import bak.pcj.util.Exceptions;
import java.util.Set;

public class SetToFloatSetAdapter
extends AbstractFloatSet
implements FloatSet {
    protected Set set;

    public SetToFloatSetAdapter(Set set) {
        if (set == null) {
            Exceptions.nullArgument("set");
        }
        this.set = set;
    }

    public SetToFloatSetAdapter(Set set, boolean validate) {
        if (set == null) {
            Exceptions.nullArgument("set");
        }
        this.set = set;
        if (validate) {
            this.evalidate();
        }
    }

    public boolean add(float v) {
        return this.set.add(new Float(v));
    }

    public void clear() {
        this.set.clear();
    }

    public boolean contains(float v) {
        return this.set.contains(new Float(v));
    }

    public int hashCode() {
        return this.set.hashCode();
    }

    public FloatIterator iterator() {
        return new IteratorToFloatIteratorAdapter(this.set.iterator());
    }

    public boolean remove(float v) {
        return this.set.remove(new Float(v));
    }

    public int size() {
        return this.set.size();
    }

    public boolean validate() {
        return Adapter.isFloatAdaptable(this.set);
    }

    public void evalidate() {
        if (!this.validate()) {
            Exceptions.cannotAdapt("set");
        }
    }
}

