/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.Adapter;
import bak.pcj.FloatCollection;
import bak.pcj.adapter.CollectionToFloatCollectionAdapter;
import bak.pcj.adapter.SetToLongSetAdapter;
import bak.pcj.map.AbstractLongKeyFloatMap;
import bak.pcj.map.LongKeyFloatMap;
import bak.pcj.map.LongKeyFloatMapIterator;
import bak.pcj.map.MapDefaults;
import bak.pcj.set.LongSet;
import bak.pcj.util.Exceptions;
import java.util.Iterator;
import java.util.Map;

public class MapToLongKeyFloatMapAdapter
extends AbstractLongKeyFloatMap
implements LongKeyFloatMap {
    protected Map map;
    protected Float lastValue;

    public MapToLongKeyFloatMapAdapter(Map map) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
    }

    public MapToLongKeyFloatMapAdapter(Map map, boolean validate) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
        if (validate) {
            this.evalidate();
        }
    }

    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(long key) {
        this.lastValue = (Float)this.map.get(new Long(key));
        return this.lastValue != null;
    }

    public boolean containsValue(float value) {
        return this.map.containsValue(new Float(value));
    }

    public LongKeyFloatMapIterator entries() {
        return new LongKeyFloatMapIterator(){
            Iterator i;
            Map.Entry lastEntry;
            {
                this.i = MapToLongKeyFloatMapAdapter.this.map.entrySet().iterator();
                this.lastEntry = null;
            }

            public boolean hasNext() {
                return this.i.hasNext();
            }

            public void next() {
                this.lastEntry = (Map.Entry)this.i.next();
            }

            public long getKey() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return (Long)this.lastEntry.getKey();
            }

            public float getValue() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return ((Float)this.lastEntry.getValue()).floatValue();
            }

            public void remove() {
                this.i.remove();
                this.lastEntry = null;
            }
        };
    }

    public float get(long key) {
        Float value = (Float)this.map.get(new Long(key));
        return value == null ? MapDefaults.defaultFloat() : value.floatValue();
    }

    public LongSet keySet() {
        return new SetToLongSetAdapter(this.map.keySet());
    }

    public float lget() {
        if (this.lastValue == null) {
            Exceptions.noLastElement();
        }
        return this.lastValue.floatValue();
    }

    public float put(long key, float value) {
        Float oldValue = this.map.put(new Long(key), new Float(value));
        return oldValue == null ? MapDefaults.defaultFloat() : oldValue.floatValue();
    }

    public float remove(long key) {
        Float value = (Float)this.map.remove(new Long(key));
        return value == null ? MapDefaults.defaultFloat() : value.floatValue();
    }

    public int size() {
        return this.map.size();
    }

    public FloatCollection values() {
        return new CollectionToFloatCollectionAdapter(this.map.values());
    }

    public float tget(long key) {
        Float value = (Float)this.map.get(new Long(key));
        if (value == null) {
            Exceptions.noSuchMapping(String.valueOf(key));
        }
        return value.floatValue();
    }

    public boolean validate() {
        return Adapter.isLongKeyFloatAdaptable(this.map);
    }

    public void evalidate() {
        if (!this.validate()) {
            Exceptions.cannotAdapt("map");
        }
    }
}

