/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.listener.metadata.draft;

import java.io.Serializable;
import jeeves.server.context.ServiceContext;
import jeeves.server.dispatchers.ServiceManager;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.Metadata;
import org.fao.geonet.domain.MetadataStatus;
import org.fao.geonet.domain.StatusValue;
import org.fao.geonet.events.md.MetadataPublished;
import org.fao.geonet.kernel.datamanager.IMetadataStatus;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.listener.metadata.draft.DraftUtilities;
import org.fao.geonet.repository.MetadataRepository;
import org.fao.geonet.repository.StatusValueRepository;
import org.fao.geonet.utils.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.event.TransactionalEventListener;

@Component
public class ApprovePublishedRecord
implements ApplicationListener<MetadataPublished> {
    @Autowired
    private IMetadataStatus metadataStatus;
    @Autowired
    private DraftUtilities draftUtilities;
    @Autowired
    private StatusValueRepository statusValueRepository;
    @Autowired
    private MetadataRepository metadataRepository;
    @Autowired
    IMetadataUtils metadataUtils;
    @Autowired
    ServiceManager serviceManager;

    @Transactional
    public void onApplicationEvent(MetadataPublished event) {
    }

    @TransactionalEventListener(fallbackExecution=true)
    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=false)
    @Modifying(clearAutomatically=true)
    public void doAfterCommit(MetadataPublished event) {
        block16: {
            Log.debug((String)"geonetwork.datamanager", (Object)("Metadata with id " + event.getMd().getId() + " published."));
            try {
                MetadataStatus previousStatus = this.metadataStatus.getStatus(event.getMd().getId());
                if (previousStatus == null) break block16;
                try (ServiceContext context = this.serviceManager.createServiceContext("approve_publish", -1);){
                    Object publishedMd = !(event.getMd() instanceof Metadata) ? this.metadataRepository.findOneByUuid(event.getMd().getUuid()) : event.getMd();
                    if (!Integer.valueOf("2").equals(previousStatus.getStatusValue().getId())) {
                        this.changeToApproved(event.getMd(), previousStatus);
                    }
                    if (!(event.getMd() instanceof Metadata)) {
                        this.draftUtilities.replaceMetadataWithDraft((AbstractMetadata)publishedMd);
                    }
                }
            }
            catch (Exception e) {
                Log.error((String)"geonetwork.datamanager", (Object)("Error upgrading workflow of " + event.getMd()), (Throwable)e);
            }
        }
    }

    private void changeToApproved(AbstractMetadata md, MetadataStatus previousStatus) throws NumberFormatException, Exception {
        MetadataStatus status = new MetadataStatus();
        status.setChangeMessage("Record published.");
        status.setPreviousState(previousStatus.getCurrentState());
        status.setStatusValue((StatusValue)this.statusValueRepository.findOne((Serializable)Integer.valueOf("2")));
        status.setMetadataId(md.getId());
        status.setUuid(md.getUuid());
        status.setTitles(this.metadataUtils.extractTitles(Integer.toString(md.getId())));
        status.setChangeDate(new ISODate());
        status.setUserId(ServiceContext.get().getUserSession().getUserIdAsInt());
        this.metadataStatus.setStatusExt(status, false);
        Log.trace((String)"geonetwork.datamanager", (Object)("Metadata with id " + md.getId() + " automatically approved due to publishing."));
    }
}

