/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geojson;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.geotools.geojson.IContentHandler;
import org.geotools.geojson.feature.FeatureCollectionHandler;
import org.geotools.geojson.feature.FeatureHandler;
import org.geotools.geojson.geom.GeometryCollectionHandler;
import org.geotools.geojson.geom.LineHandler;
import org.geotools.geojson.geom.MultiLineHandler;
import org.geotools.geojson.geom.MultiPointHandler;
import org.geotools.geojson.geom.MultiPolygonHandler;
import org.geotools.geojson.geom.PointHandler;
import org.geotools.geojson.geom.PolygonHandler;
import org.json.simple.parser.ContentHandler;
import org.json.simple.parser.ParseException;

public abstract class DelegatingHandler<T>
implements IContentHandler<T> {
    protected static HashMap<String, Class<? extends IContentHandler>> handlers = new HashMap();
    protected static NullHandler NULL;
    protected static NullHandler UNINITIALIZED;
    protected static List NULL_LIST;
    protected ContentHandler delegate = NULL;

    public ContentHandler getDelegate() {
        return this.delegate;
    }

    public void startJSON() throws ParseException, IOException {
        this.delegate.startJSON();
    }

    public void endJSON() throws ParseException, IOException {
        this.delegate.endJSON();
    }

    public boolean startObject() throws ParseException, IOException {
        return this.delegate.startObject();
    }

    public boolean endObject() throws ParseException, IOException {
        return this.delegate.endObject();
    }

    public boolean startObjectEntry(String key) throws ParseException, IOException {
        return this.delegate.startObjectEntry(key);
    }

    public boolean endObjectEntry() throws ParseException, IOException {
        return this.delegate.endObjectEntry();
    }

    public boolean startArray() throws ParseException, IOException {
        return this.delegate.startArray();
    }

    public boolean endArray() throws ParseException, IOException {
        return this.delegate.endArray();
    }

    public boolean primitive(Object value) throws ParseException, IOException {
        return this.delegate.primitive(value);
    }

    @Override
    public T getValue() {
        if (this.delegate instanceof IContentHandler) {
            return ((IContentHandler)this.delegate).getValue();
        }
        return null;
    }

    protected Class<? extends ContentHandler> lookupDelegate(String type) {
        return handlers.get(type);
    }

    protected IContentHandler createDelegate(Class clazz, Object[] args) {
        try {
            if (args != null && args.length > 0) {
                Class[] types = new Class[args.length];
                for (int i = 0; i < args.length; ++i) {
                    types[i] = args[i].getClass();
                }
                return (IContentHandler)clazz.getConstructor(types).newInstance(args);
            }
            return (IContentHandler)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        handlers.put("Point", PointHandler.class);
        handlers.put("LineString", LineHandler.class);
        handlers.put("Polygon", PolygonHandler.class);
        handlers.put("MultiPoint", MultiPointHandler.class);
        handlers.put("MultiLineString", MultiLineHandler.class);
        handlers.put("MultiPolygon", MultiPolygonHandler.class);
        handlers.put("GeometryCollection", GeometryCollectionHandler.class);
        handlers.put("Feature", FeatureHandler.class);
        handlers.put("FeatureCollection", FeatureCollectionHandler.class);
        NULL = new NullHandler();
        UNINITIALIZED = new NullHandler();
        NULL_LIST = Collections.unmodifiableList(new ArrayList(0));
    }

    static class NullHandler
    implements ContentHandler {
        NullHandler() {
        }

        public void startJSON() throws ParseException, IOException {
        }

        public void endJSON() throws ParseException, IOException {
        }

        public boolean endArray() throws ParseException, IOException {
            return true;
        }

        public boolean endObject() throws ParseException, IOException {
            return true;
        }

        public boolean endObjectEntry() throws ParseException, IOException {
            return true;
        }

        public boolean startArray() throws ParseException, IOException {
            return true;
        }

        public boolean startObject() throws ParseException, IOException {
            return true;
        }

        public boolean startObjectEntry(String key) throws ParseException, IOException {
            return true;
        }

        public boolean primitive(Object value) throws ParseException, IOException {
            return true;
        }
    }
}

