/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.lib.methods;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpState;
import org.apache.webdav.lib.methods.XMLResponseMethodBase;

public class UnsubscribeMethod
extends XMLResponseMethodBase {
    private static final String HEADER_SUBSCRIPTION_ID = "Subscription-Id";
    private List subscriptionIds = new ArrayList();

    public UnsubscribeMethod() {
    }

    public UnsubscribeMethod(String path) {
        super(path);
    }

    public void addSubscriptionId(int id) {
        this.subscriptionIds.add(new Integer(id));
    }

    public String getName() {
        return "UNSUBSCRIBE";
    }

    public void recycle() {
        super.recycle();
        this.subscriptionIds.clear();
    }

    protected void addRequestHeaders(HttpState state, HttpConnection conn) throws IOException, HttpException {
        super.addRequestHeaders(state, conn);
        if (this.subscriptionIds.size() > 0) {
            StringBuffer b = new StringBuffer();
            boolean first = true;
            Iterator i = this.subscriptionIds.iterator();
            while (i.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    b.append(", ");
                }
                b.append(i.next());
            }
            super.addRequestHeader(HEADER_SUBSCRIPTION_ID, b.toString());
        }
    }

    public void setRequestHeader(String headerName, String headerValue) {
        if (headerName.equalsIgnoreCase(HEADER_SUBSCRIPTION_ID)) {
            StringTokenizer t = new StringTokenizer(headerValue, ", ");
            try {
                while (t.hasMoreTokens()) {
                    this.addSubscriptionId(Integer.parseInt(t.nextToken()));
                }
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid header value '" + headerValue + "' for header " + headerName + "!");
            }
        } else {
            super.setRequestHeader(headerName, headerValue);
        }
    }
}

