/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.csw.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.Util;
import org.fao.geonet.csw.common.ElementSetName;
import org.fao.geonet.csw.common.ResultType;
import org.fao.geonet.csw.common.exceptions.InvalidParameterValueEx;
import org.fao.geonet.kernel.SchemaManager;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class Xml {
    public static Element loadString(String data, boolean validate) throws IOException, JDOMException {
        SAXBuilder builder = new SAXBuilder(validate);
        builder.setFeature("http://apache.org/xml/features/allow-java-encodings", true);
        Document jdoc = builder.build((Reader)new StringReader(data));
        return (Element)jdoc.getRootElement().detach();
    }

    public static Element loadStream(InputStream input) throws IOException, JDOMException {
        SAXBuilder builder = new SAXBuilder();
        builder.setFeature("http://apache.org/xml/features/allow-java-encodings", true);
        Document jdoc = builder.build(input);
        return (Element)jdoc.getRootElement().detach();
    }

    public static String getString(Element data) {
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        return outputter.outputString(data);
    }

    public static String getString(Document data) {
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        return outputter.outputString(data);
    }

    public static Element applyElementSetName(ServiceContext context, SchemaManager schemaManager, String schema, Element result, String outputSchema, ElementSetName elementSetName, ResultType resultType, String id, String displayLanguage) throws InvalidParameterValueEx {
        Path schemaDir = schemaManager.getSchemaCSWPresentDir(schema);
        Path styleSheet = schemaDir.resolve(outputSchema + "-" + (Object)((Object)elementSetName) + ".xsl");
        if (!Files.exists(styleSheet, new LinkOption[0])) {
            throw new InvalidParameterValueEx("OutputSchema", String.format("OutputSchema '%s' not supported for metadata with '%s' (%s).\nCorresponding XSL transformation '%s' does not exist for this schema.\nThe record will not be returned in response.", outputSchema, id, schema, styleSheet.getFileName()));
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("lang", displayLanguage);
        params.put("displayInfo", resultType == ResultType.RESULTS_WITH_SUMMARY ? "true" : "false");
        try {
            result = org.fao.geonet.utils.Xml.transform((Element)result, (Path)styleSheet, params);
        }
        catch (Exception e) {
            String msg = String.format("Error occured while transforming metadata with id '%s' using '%s'.", id, styleSheet.getFileName());
            context.error(msg);
            context.error("  (C) StackTrace:\n" + Util.getStackTrace((Throwable)e));
            throw new InvalidParameterValueEx("OutputSchema", msg);
        }
        return result;
    }
}

