/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.cdi;

import java.util.EventListener;
import java.util.Objects;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import org.eclipse.jetty.cdi.CdiDecoratingListener;
import org.eclipse.jetty.cdi.CdiSpiDecorator;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.Decorator;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class CdiServletContainerInitializer
implements ServletContainerInitializer {
    public static final String CDI_INTEGRATION_ATTRIBUTE = "org.eclipse.jetty.cdi";
    private static final Logger LOG = Log.getLogger(CdiServletContainerInitializer.class);

    public void onStartup(Set<Class<?>> c, ServletContext ctx) {
        block13: {
            try {
                ServletContextHandler context = ServletContextHandler.getServletContextHandler((ServletContext)ctx);
                Objects.requireNonNull(context);
                ClassLoader loader = context.getClassLoader();
                if (loader == null) {
                    Loader.loadClass((String)"javax.enterprise.inject.spi.CDI");
                } else {
                    loader.loadClass("javax.enterprise.inject.spi.CDI");
                }
                String mode = ctx.getInitParameter(CDI_INTEGRATION_ATTRIBUTE);
                if (mode == null && (mode = (String)context.getServer().getAttribute(CDI_INTEGRATION_ATTRIBUTE)) == null) {
                    mode = "CdiSpiDecorator";
                }
                switch (mode) {
                    case "CdiSpiDecorator": {
                        context.getObjectFactory().addDecorator((Decorator)new CdiSpiDecorator(context));
                        break;
                    }
                    case "CdiDecoratingListener": {
                        context.addEventListener((EventListener)((Object)new CdiDecoratingListener(context)));
                        break;
                    }
                    default: {
                        throw new IllegalStateException(mode);
                    }
                }
                context.setAttribute(CDI_INTEGRATION_ATTRIBUTE, (Object)mode);
                LOG.info(mode + " enabled in " + ctx, new Object[0]);
            }
            catch (ClassNotFoundException | UnsupportedOperationException e) {
                if (!LOG.isDebugEnabled()) break block13;
                LOG.debug("CDI not found in " + ctx, (Throwable)e);
            }
        }
    }
}

