/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.SyntacticScopeCreator;
import com.google.javascript.jscomp.TypedVar;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class CheckRequiresForConstructors
implements HotSwapCompilerPass {
    private final AbstractCompiler compiler;
    private final CodingConvention codingConvention;
    static final DiagnosticType MISSING_REQUIRE_WARNING = DiagnosticType.disabled("JSC_MISSING_REQUIRE_WARNING", "''{0}'' used but not goog.require''d");
    static final DiagnosticType EXTRA_REQUIRE_WARNING = DiagnosticType.disabled("JSC_EXTRA_REQUIRE_WARNING", "''{0}'' goog.require''d but not used");
    private static final Set<String> DEFAULT_EXTRA_NAMESPACES = ImmutableSet.of((Object)"goog.testing.asserts", (Object)"goog.testing.jsunit");

    CheckRequiresForConstructors(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.codingConvention = compiler.getCodingConvention();
    }

    @Override
    public void process(Node externs, Node root) {
        CheckRequiresForConstructorsCallback callback = new CheckRequiresForConstructorsCallback();
        NodeTraversal.traverseRootsTyped(this.compiler, callback, externs, root);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        CheckRequiresForConstructorsCallback callback = new CheckRequiresForConstructorsCallback();
        Scope globalScope = SyntacticScopeCreator.makeTyped(this.compiler).createScope(scriptRoot, null);
        new NodeTraversal(this.compiler, callback).traverseWithScope(scriptRoot, globalScope);
    }

    private static boolean isClassName(String name) {
        return name != null && name.length() > 1 && Character.isUpperCase(name.charAt(0)) && !name.equals(name.toUpperCase());
    }

    private static String getOutermostClassName(String className) {
        for (String part : Splitter.on((char)'.').split((CharSequence)className)) {
            if (!CheckRequiresForConstructors.isClassName(part)) continue;
            return className.substring(0, className.indexOf(part) + part.length());
        }
        return null;
    }

    private class CheckRequiresForConstructorsCallback
    implements NodeTraversal.Callback {
        private final Set<String> constructors = new HashSet<String>();
        private final Map<String, Node> requires = new HashMap<String, Node>();
        private final Map<String, Node> usages = new HashMap<String, Node>();
        private final Map<String, Node> weakUsages = new HashMap<String, Node>();

        private CheckRequiresForConstructorsCallback() {
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            return parent == null || !parent.isScript() || !t.getInput().isExtern();
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            this.maybeAddJsDocUsages(t, n);
            switch (n.getType()) {
                case 86: 
                case 118: {
                    this.maybeAddConstructor(t, n);
                    break;
                }
                case 105: {
                    if (!NodeUtil.isStatement(n)) break;
                    this.maybeAddConstructor(t, n);
                    break;
                }
                case 33: {
                    this.visitGetProp(n);
                    break;
                }
                case 37: {
                    this.visitCallNode(n, parent);
                    break;
                }
                case 132: {
                    this.visitScriptNode(t);
                    break;
                }
                case 30: {
                    this.visitNewNode(t, n);
                }
            }
        }

        private void visitScriptNode(NodeTraversal t) {
            HashSet<String> classNames = new HashSet<String>();
            for (Map.Entry<String, Node> entry : this.usages.entrySet()) {
                boolean notProvidedByRequires;
                String className = entry.getKey();
                Node node = entry.getValue();
                String outermostClassName = CheckRequiresForConstructors.getOutermostClassName(className);
                String nonNullClassName = outermostClassName != null ? outermostClassName : className;
                String parentNamespace = null;
                int separatorIndex = nonNullClassName.lastIndexOf(46);
                if (separatorIndex > 0) {
                    parentNamespace = nonNullClassName.substring(0, separatorIndex);
                }
                boolean notProvidedByConstructors = this.constructors == null || !this.constructors.contains(className) && !this.constructors.contains(outermostClassName);
                boolean bl = notProvidedByRequires = this.requires == null || !this.requires.containsKey(className) && !this.requires.containsKey(outermostClassName) && !this.requires.containsKey(parentNamespace);
                if (!notProvidedByConstructors || !notProvidedByRequires || classNames.contains(className)) continue;
                CheckRequiresForConstructors.this.compiler.report(t.makeError(node, MISSING_REQUIRE_WARNING, className));
                classNames.add(className);
            }
            for (Map.Entry<String, Node> entry : this.requires.entrySet()) {
                String require = entry.getKey();
                Node call = entry.getValue();
                Node parent = call.getParent();
                if (parent.isAssign() || this.usages.containsKey(require) || this.weakUsages.containsKey(require)) continue;
                this.reportExtraRequireWarning(call, require);
            }
            this.usages.clear();
            this.weakUsages.clear();
            this.requires.clear();
            this.constructors.clear();
        }

        private void reportExtraRequireWarning(Node call, String require) {
            if (DEFAULT_EXTRA_NAMESPACES.contains(require)) {
                return;
            }
            JSDocInfo jsDoc = call.getJSDocInfo();
            if (jsDoc != null && jsDoc.getSuppressions().contains("extraRequire")) {
                return;
            }
            CheckRequiresForConstructors.this.compiler.report(JSError.make(call, EXTRA_REQUIRE_WARNING, require));
        }

        private void visitCallNode(Node call, Node parent) {
            Node callee;
            String required = CheckRequiresForConstructors.this.codingConvention.extractClassNameIfRequire(call, parent);
            if (required != null) {
                this.requires.put(required, call);
            }
            if ((callee = call.getFirstChild()).isName()) {
                this.weakUsages.put(callee.getString(), callee);
            }
        }

        private void visitGetProp(Node getprop) {
            while (getprop != null) {
                this.weakUsages.put(getprop.getQualifiedName(), getprop);
                getprop = getprop.getFirstChild();
            }
        }

        private void visitNewNode(NodeTraversal t, Node newNode) {
            Node qNameNode = newNode.getFirstChild();
            if (!qNameNode.isQualifiedName()) {
                return;
            }
            Node root = NodeUtil.getRootOfQualifiedName(qNameNode);
            if (!root.isName()) {
                return;
            }
            String name = root.getString();
            TypedVar var = t.getTypedScope().getVar(name);
            if (var != null && (var.isLocal() || var.isExtern())) {
                return;
            }
            this.usages.put(qNameNode.getQualifiedName(), newNode);
            while (qNameNode != null) {
                this.weakUsages.put(qNameNode.getQualifiedName(), qNameNode);
                qNameNode = qNameNode.getFirstChild();
            }
        }

        private void maybeAddConstructor(NodeTraversal t, Node n) {
            JSDocInfo info = n.getJSDocInfo();
            if (info != null) {
                String ctorName = n.getFirstChild().getQualifiedName();
                if (info.isConstructor() || info.isInterface()) {
                    this.constructors.add(ctorName);
                } else {
                    JSType type;
                    JSTypeExpression typeExpr = info.getType();
                    if (typeExpr != null && (type = typeExpr.evaluate(t.getTypedScope(), CheckRequiresForConstructors.this.compiler.getTypeIRegistry())).isConstructor()) {
                        this.constructors.add(ctorName);
                    }
                }
            }
        }

        private boolean declaresFunction(Node n) {
            if (n.isFunction()) {
                return true;
            }
            if (n.isAssign() && n.getLastChild().isFunction()) {
                return true;
            }
            return NodeUtil.isNameDeclaration(n) && n.getFirstChild().hasChildren() && n.getFirstChild().getFirstChild().isFunction();
        }

        private void maybeAddJsDocUsages(NodeTraversal t, Node n) {
            JSDocInfo info = n.getJSDocInfo();
            if (info == null) {
                return;
            }
            if (this.declaresFunction(n)) {
                for (JSTypeExpression expr : info.getImplementedInterfaces()) {
                    this.maybeAddUsage(t, n, expr);
                }
                if (info.getBaseType() != null) {
                    this.maybeAddUsage(t, n, info.getBaseType());
                }
                for (JSTypeExpression extendedInterface : info.getExtendedInterfaces()) {
                    this.maybeAddUsage(t, n, extendedInterface);
                }
            }
            for (Node typeNode : info.getTypeNodes()) {
                this.maybeAddWeakUsage(t, n, typeNode);
            }
        }

        private void maybeAddWeakUsage(NodeTraversal t, Node n, Node typeNode) {
            this.maybeAddUsage(t, n, typeNode, this.weakUsages, (Predicate<Node>)Predicates.alwaysTrue());
        }

        private void maybeAddUsage(NodeTraversal t, Node n, final JSTypeExpression expr) {
            Predicate<Node> pred = new Predicate<Node>(){

                public boolean apply(Node n) {
                    return n == expr.getRoot();
                }
            };
            this.maybeAddUsage(t, n, expr.getRoot(), this.usages, pred);
        }

        private void maybeAddUsage(final NodeTraversal t, final Node n, Node rootTypeNode, final Map<String, Node> usagesMap, Predicate<Node> pred) {
            NodeUtil.Visitor visitor = new NodeUtil.Visitor(){

                @Override
                public void visit(Node typeNode) {
                    if (typeNode.isString()) {
                        String typeString = typeNode.getString();
                        String rootName = (String)Splitter.on((char)'.').split((CharSequence)typeString).iterator().next();
                        TypedVar var = t.getTypedScope().getVar(rootName);
                        if (var == null || !var.isExtern()) {
                            usagesMap.put(typeString, n);
                            Node getprop = NodeUtil.newQName(CheckRequiresForConstructors.this.compiler, typeString);
                            getprop.useSourceInfoIfMissingFromForTree(typeNode);
                            CheckRequiresForConstructorsCallback.this.visitGetProp(getprop);
                        }
                    }
                }
            };
            NodeUtil.visitPreOrder(rootTypeNode, visitor, pred);
        }
    }
}

