/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.search;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jdom.Element;

public class UserQueryInput {
    public static final List<String> SECURITY_FIELDS = Arrays.asList("owner", "isAdmin", "isReviewer", "isUserAdmin");
    public static final List<String> RESERVED_FIELDS = Arrays.asList("group", "groupEdit", "fast", "sortBy", "sortOrder", "extended", "intermap", "hitsPerPage", "geometry", "output", "summaryOnly", "buildSummary", "requestedLanguage", "region_simple", "attrset", "mode", "region", "from", "to", "hitsperpage", "georss");
    public static final List<String> NO_TEXT_FIELDS = Arrays.asList("uuid", "parentUuid", "operatesOn", "_schema", "_root", "_isTemplate", "resultType", "relation", "siteId", "type", "hasfeaturecat");
    public static final List<String> RANGE_QUERY_FIELDS = Arrays.asList("dateFrom", "dateTo", "revisionDateFrom", "revisionDateTo", "publicationDateFrom", "publicationDateTo", "denominatorFrom", "denominatorTo", "denominator", "_rating", "_ratingFrom", "_ratingTo", "feedbackCount", "feedbackCountFrom", "feedbackCountTo", "creationDateFrom", "creationDateTo");
    private static final List<String> RANGE_FIELDS = Arrays.asList("changeDate", "revisionDate", "publicationDate", "createDate", "denominator", "_rating", "feedbackCount");
    private static final List<String> RANGE_FIELDS_FROM = Arrays.asList("dateFrom", "revisionDateFrom", "publicationDateFrom", "creationDateFrom", "denominatorFrom", "_ratingFrom", "feedbackCountFrom");
    private static final List<String> RANGE_FIELDS_TO = Arrays.asList("dateTo", "revisionDateTo", "publicationDateTo", "creationDateTo", "denominatorTo", "_ratingTo", "feedbackCountTo");
    private static Map<String, String> searchParamToLuceneField = new LinkedHashMap<String, String>();
    private String similarity;
    private String editable;
    private Map<String, Set<String>> searchCriteria = new LinkedHashMap<String, Set<String>>();
    private Map<String, Set<String>> searchPrivilegeCriteria = new LinkedHashMap<String, Set<String>>();
    private Map<String, String> searchOption = new LinkedHashMap<String, String>();
    private Set<String> facetQueries = new LinkedHashSet<String>();

    public UserQueryInput(Element jdom) {
        for (Object e : jdom.getChildren()) {
            if (!(e instanceof Element)) continue;
            Element node = (Element)e;
            String nodeName = node.getName();
            String nodeValue = StringUtils.trim((String)node.getText());
            if ("similarity".equals(nodeName)) {
                this.setSimilarity(jdom.getChildText("similarity"));
                continue;
            }
            if ("extraDumpFields".equals(nodeName) || !StringUtils.isNotBlank((String)nodeValue)) continue;
            if (nodeName.startsWith("_operation")) {
                this.addValues(this.searchCriteria, searchParamToLuceneField.get(nodeName), nodeValue);
                continue;
            }
            if (SECURITY_FIELDS.contains(nodeName) || nodeName.contains("_op")) {
                this.addValues(this.searchPrivilegeCriteria, nodeName, nodeValue);
                continue;
            }
            if (RESERVED_FIELDS.contains(nodeName)) {
                this.searchOption.put(nodeName, nodeValue);
                continue;
            }
            if (this.isFacetQuery(nodeName)) {
                this.facetQueries.add(nodeValue);
                continue;
            }
            this.addValues(this.searchCriteria, searchParamToLuceneField.containsKey(nodeName) ? searchParamToLuceneField.get(nodeName) : nodeName, nodeValue);
        }
    }

    public static String getRangeField(String searchFieldName) {
        if (RANGE_FIELDS.contains(searchFieldName)) {
            return searchFieldName;
        }
        if (RANGE_FIELDS_FROM.contains(searchFieldName)) {
            return RANGE_FIELDS.get(RANGE_FIELDS_FROM.indexOf(searchFieldName));
        }
        if (RANGE_FIELDS_TO.contains(searchFieldName)) {
            return RANGE_FIELDS.get(RANGE_FIELDS_TO.indexOf(searchFieldName));
        }
        return null;
    }

    public static String getTo(String fieldName) {
        return RANGE_FIELDS_TO.get(RANGE_FIELDS.indexOf(fieldName));
    }

    public static String getFrom(String fieldName) {
        return RANGE_FIELDS_FROM.get(RANGE_FIELDS.indexOf(fieldName));
    }

    public Map<String, Set<String>> getSearchCriteria() {
        return this.searchCriteria;
    }

    public Set<String> getFacetQueries() {
        return this.facetQueries;
    }

    public Map<String, Set<String>> getTextCriteria() {
        LinkedHashMap<String, Set<String>> textCriteria = new LinkedHashMap<String, Set<String>>();
        for (String criteria : this.searchCriteria.keySet()) {
            if (NO_TEXT_FIELDS.contains(criteria)) continue;
            textCriteria.put(criteria, this.searchCriteria.get(criteria));
        }
        return textCriteria;
    }

    public Map<String, Set<String>> getSearchPrivilegeCriteria() {
        return this.searchPrivilegeCriteria;
    }

    public Map<String, String> getSearchOption() {
        return this.searchOption;
    }

    private boolean isFacetQuery(String nodeName) {
        return nodeName.equals("facet.q");
    }

    private void addValues(Map<String, Set<String>> hash, String nodeName, String nodeValue) {
        block5: {
            Set<String> currentValues = this.searchCriteria.get(nodeName);
            try {
                if (currentValues == null) {
                    LinkedHashSet<String> values = new LinkedHashSet<String>();
                    String val = nodeValue;
                    try {
                        val = URLDecoder.decode(nodeValue, "UTF-8");
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    values.add(val);
                    hash.put(nodeName, values);
                    break block5;
                }
                currentValues.add(URLDecoder.decode(nodeValue, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        this.addSearchCriteria(text);
        this.addFacetQueries(text);
        return text.toString();
    }

    public String getSimilarity() {
        return this.similarity;
    }

    public void setSimilarity(String similarity) {
        this.similarity = similarity;
    }

    public String getEditable() {
        return this.editable;
    }

    public void setEditable(String editable) {
        this.editable = editable.equals("true") ? editable : "false";
    }

    private void addSearchCriteria(StringBuilder text) {
        for (Map.Entry<String, Set<String>> entry : this.searchCriteria.entrySet()) {
            String fieldName = entry.getKey();
            Set<String> fieldValue = entry.getValue();
            text.append(fieldName).append(":").append(fieldValue).append(" ");
        }
    }

    private void addFacetQueries(StringBuilder text) {
        for (String facetQuery : this.facetQueries) {
            text.append("facetQuery:").append(facetQuery).append(" ");
        }
    }

    static {
        searchParamToLuceneField.put("siteId", "_source");
        searchParamToLuceneField.put("inspire", "inspirecat");
        searchParamToLuceneField.put("themekey", "keyword");
        searchParamToLuceneField.put("topic-category", "topicCat");
        searchParamToLuceneField.put("category", "_cat");
        searchParamToLuceneField.put("_operation0", "_op0");
        searchParamToLuceneField.put("_operation1", "_op1");
        searchParamToLuceneField.put("_operation2", "_op2");
        searchParamToLuceneField.put("_operation3", "_op3");
        searchParamToLuceneField.put("_operation5", "_op5");
        searchParamToLuceneField.put("_operation6", "_op6");
    }
}

