/*
 * Decompiled with CFR 0.152.
 */
package jeeves.config.springutil;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.fao.geonet.ApplicationContextHolder;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.filter.DelegatingFilterProxy;
import org.springframework.web.filter.GenericFilterBean;

public class JeevesDelegatingFilterProxy
extends GenericFilterBean {
    private static final InheritableThreadLocal<String> applicationContextAttributeKey = new InheritableThreadLocal();
    private final Map<String, Filter> nodeIdToFilterMap = new HashMap<String, Filter>();

    public static ServletContext getServletContext(ServletContext fallback) {
        if (ApplicationContextHolder.get() != null) {
            return (ServletContext)ApplicationContextHolder.get().getBean(ServletContext.class);
        }
        return fallback;
    }

    public static ConfigurableApplicationContext getApplicationContextFromServletContext(ServletContext servletContext) {
        Object applicationContext = servletContext.getAttribute((String)applicationContextAttributeKey.get());
        return (ConfigurableApplicationContext)applicationContext;
    }

    @VisibleForTesting
    public static void setApplicationContextAttributeKey(String key) {
        applicationContextAttributeKey.set(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        try {
            if (request instanceof HttpServletRequest) {
                String nodeId = "jeevesNodeApplicationContext_";
                applicationContextAttributeKey.set(nodeId);
                ConfigurableApplicationContext applicationContext = JeevesDelegatingFilterProxy.getApplicationContextFromServletContext(this.getServletContext());
                ApplicationContextHolder.set((ConfigurableApplicationContext)applicationContext);
                this.getDelegateFilter(nodeId, (WebApplicationContext)applicationContext).doFilter(request, response, filterChain);
            } else {
                response.getWriter().write(request.getClass().getName() + " is not a supported type of request");
            }
        }
        finally {
            ApplicationContextHolder.clear();
        }
    }

    private synchronized Filter getDelegateFilter(String nodeId, WebApplicationContext context) {
        Filter filter = this.nodeIdToFilterMap.get(nodeId);
        if (filter == null) {
            filter = new DelegatingFilterProxy(this.getFilterName(), context);
            this.nodeIdToFilterMap.put(nodeId, filter);
        }
        return filter;
    }
}

