/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http4;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.camel.Component;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Producer;
import org.apache.camel.component.http4.DefaultHttpBinding;
import org.apache.camel.component.http4.HttpBinding;
import org.apache.camel.component.http4.HttpClientConfigurer;
import org.apache.camel.component.http4.HttpComponent;
import org.apache.camel.component.http4.HttpConsumer;
import org.apache.camel.component.http4.HttpHeaderFilterStrategy;
import org.apache.camel.component.http4.HttpPollingConsumer;
import org.apache.camel.component.http4.HttpProducer;
import org.apache.camel.component.http4.NoopCookieStore;
import org.apache.camel.component.http4.PreemptiveAuthInterceptor;
import org.apache.camel.component.http4.UrlRewrite;
import org.apache.camel.component.http4.helper.HttpHelper;
import org.apache.camel.impl.DefaultPollingEndpoint;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.util.ObjectHelper;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(scheme="http4", consumerClass=HttpConsumer.class)
public class HttpEndpoint
extends DefaultPollingEndpoint
implements HeaderFilterStrategyAware {
    private static final Logger LOG = LoggerFactory.getLogger(HttpEndpoint.class);
    private HeaderFilterStrategy headerFilterStrategy = new HttpHeaderFilterStrategy();
    private HttpBinding binding;
    private HttpContext httpContext;
    private HttpComponent component;
    private URI httpUri;
    private HttpClientConfigurer httpClientConfigurer;
    private HttpClientConnectionManager clientConnectionManager;
    private HttpClientBuilder clientBuilder;
    private HttpClient httpClient;
    @UriParam
    private boolean throwExceptionOnFailure = true;
    @UriParam
    private boolean bridgeEndpoint;
    @UriParam
    private boolean matchOnUriPrefix;
    @UriParam
    private boolean chunked = true;
    @UriParam
    private boolean disableStreamCache;
    @UriParam
    private boolean transferException;
    @UriParam
    private boolean traceEnabled;
    @UriParam
    private boolean authenticationPreemptive;
    @UriParam
    private String httpMethodRestrict;
    private UrlRewrite urlRewrite;
    @UriParam
    private boolean clearExpiredCookies = true;
    private CookieStore cookieStore = new BasicCookieStore();

    public HttpEndpoint() {
    }

    public HttpEndpoint(String endPointURI, HttpComponent component, URI httpURI) throws URISyntaxException {
        this(endPointURI, component, httpURI, null);
    }

    public HttpEndpoint(String endPointURI, HttpComponent component, URI httpURI, HttpClientConnectionManager clientConnectionManager) throws URISyntaxException {
        this(endPointURI, component, httpURI, HttpClientBuilder.create(), clientConnectionManager, null);
    }

    public HttpEndpoint(String endPointURI, HttpComponent component, HttpClientBuilder clientBuilder, HttpClientConnectionManager clientConnectionManager, HttpClientConfigurer clientConfigurer) throws URISyntaxException {
        this(endPointURI, component, null, clientBuilder, clientConnectionManager, clientConfigurer);
    }

    public HttpEndpoint(String endPointURI, HttpComponent component, URI httpURI, HttpClientBuilder clientBuilder, HttpClientConnectionManager clientConnectionManager, HttpClientConfigurer clientConfigurer) throws URISyntaxException {
        super(endPointURI, (Component)component);
        this.component = component;
        this.httpUri = httpURI;
        this.clientBuilder = clientBuilder;
        this.httpClientConfigurer = clientConfigurer;
        this.clientConnectionManager = clientConnectionManager;
    }

    public Producer createProducer() throws Exception {
        return new HttpProducer(this);
    }

    public PollingConsumer createPollingConsumer() throws Exception {
        HttpPollingConsumer answer = new HttpPollingConsumer(this);
        this.configurePollingConsumer((PollingConsumer)answer);
        return answer;
    }

    public synchronized HttpClient getHttpClient() {
        if (this.httpClient == null) {
            this.httpClient = this.createHttpClient();
        }
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    protected HttpClient createHttpClient() {
        HttpClientConfigurer configurer;
        ObjectHelper.notNull((Object)this.clientBuilder, (String)"httpClientBuilder");
        ObjectHelper.notNull((Object)this.clientConnectionManager, (String)"httpConnectionManager");
        this.clientBuilder.setDefaultCookieStore(this.cookieStore);
        this.clientBuilder.setConnectionManager(this.clientConnectionManager);
        if (ObjectHelper.isNotEmpty((Object)this.getCamelContext().getProperty("http.proxyHost")) && ObjectHelper.isNotEmpty((Object)this.getCamelContext().getProperty("http.proxyPort"))) {
            String host = this.getCamelContext().getProperty("http.proxyHost");
            int port = Integer.parseInt(this.getCamelContext().getProperty("http.proxyPort"));
            String scheme = this.getCamelContext().getProperty("http.proxyScheme");
            if (scheme == null) {
                scheme = HttpHelper.isSecureConnection(this.getEndpointUri()) ? "https" : "http";
            }
            LOG.debug("CamelContext properties http.proxyHost, http.proxyPort, and http.proxyScheme detected. Using http proxy host: {} port: {} scheme: {}", new Object[]{host, port, scheme});
            HttpHost proxy = new HttpHost(host, port, scheme);
            this.clientBuilder.setProxy(proxy);
        }
        if (this.isAuthenticationPreemptive()) {
            this.clientBuilder.addInterceptorFirst((HttpRequestInterceptor)new PreemptiveAuthInterceptor());
        }
        if ((configurer = this.getHttpClientConfigurer()) != null) {
            configurer.configureHttpClient(this.clientBuilder);
        }
        if (this.isBridgeEndpoint()) {
            this.clientBuilder.setDefaultCookieStore((CookieStore)new NoopCookieStore());
        }
        LOG.debug("Setup the HttpClientBuilder {}", (Object)this.clientBuilder);
        return this.clientBuilder.build();
    }

    public void connect(HttpConsumer consumer) throws Exception {
        this.component.connect(consumer);
    }

    public void disconnect(HttpConsumer consumer) throws Exception {
        this.component.disconnect(consumer);
    }

    public boolean isLenientProperties() {
        return true;
    }

    public boolean isSingleton() {
        return true;
    }

    protected void doStop() throws Exception {
        if (this.component != null && this.component.getClientConnectionManager() != this.clientConnectionManager) {
            this.clientConnectionManager.shutdown();
        }
    }

    public HttpClientBuilder getClientBuilder() {
        return this.clientBuilder;
    }

    public void setClientBuilder(HttpClientBuilder clientBuilder) {
        this.clientBuilder = clientBuilder;
    }

    public HttpClientConfigurer getHttpClientConfigurer() {
        return this.httpClientConfigurer;
    }

    public HttpContext getHttpContext() {
        return this.httpContext;
    }

    public void setHttpClientConfigurer(HttpClientConfigurer httpClientConfigurer) {
        this.httpClientConfigurer = httpClientConfigurer;
    }

    public HttpBinding getBinding() {
        if (this.binding == null) {
            this.binding = new DefaultHttpBinding(this);
        }
        return this.binding;
    }

    public void setBinding(HttpBinding binding) {
        this.binding = binding;
    }

    public void setHttpBinding(HttpBinding binding) {
        this.binding = binding;
    }

    public void setHttpBindingRef(HttpBinding binding) {
        this.binding = binding;
    }

    public void setHttpContext(HttpContext httpContext) {
        this.httpContext = httpContext;
    }

    public String getPath() {
        return this.httpUri.getPath().length() == 0 ? "/" : this.httpUri.getPath();
    }

    public int getPort() {
        if (this.httpUri.getPort() == -1) {
            if ("https".equals(this.getProtocol()) || "https4".equals(this.getProtocol())) {
                return 443;
            }
            return 80;
        }
        return this.httpUri.getPort();
    }

    public String getProtocol() {
        return this.httpUri.getScheme();
    }

    public URI getHttpUri() {
        return this.httpUri;
    }

    public void setHttpUri(URI httpUri) {
        this.httpUri = httpUri;
    }

    public HttpClientConnectionManager getClientConnectionManager() {
        return this.clientConnectionManager;
    }

    public void setClientConnectionManager(HttpClientConnectionManager clientConnectionManager) {
        this.clientConnectionManager = clientConnectionManager;
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
    }

    public boolean isThrowExceptionOnFailure() {
        return this.throwExceptionOnFailure;
    }

    public void setThrowExceptionOnFailure(boolean throwExceptionOnFailure) {
        this.throwExceptionOnFailure = throwExceptionOnFailure;
    }

    public boolean isBridgeEndpoint() {
        return this.bridgeEndpoint;
    }

    public void setBridgeEndpoint(boolean bridge) {
        this.bridgeEndpoint = bridge;
    }

    public boolean isMatchOnUriPrefix() {
        return this.matchOnUriPrefix;
    }

    public void setMatchOnUriPrefix(boolean match) {
        this.matchOnUriPrefix = match;
    }

    public boolean isDisableStreamCache() {
        return this.disableStreamCache;
    }

    public void setDisableStreamCache(boolean disable) {
        this.disableStreamCache = disable;
    }

    public boolean isChunked() {
        return this.chunked;
    }

    public void setChunked(boolean chunked) {
        this.chunked = chunked;
    }

    public boolean isTransferException() {
        return this.transferException;
    }

    public void setTransferException(boolean transferException) {
        this.transferException = transferException;
    }

    public boolean isTraceEnabled() {
        return this.traceEnabled;
    }

    public void setTraceEnabled(boolean traceEnabled) {
        this.traceEnabled = traceEnabled;
    }

    public String getHttpMethodRestrict() {
        return this.httpMethodRestrict;
    }

    public void setHttpMethodRestrict(String httpMethodRestrict) {
        this.httpMethodRestrict = httpMethodRestrict;
    }

    public UrlRewrite getUrlRewrite() {
        return this.urlRewrite;
    }

    public void setUrlRewrite(UrlRewrite urlRewrite) {
        this.urlRewrite = urlRewrite;
    }

    public boolean isClearExpiredCookies() {
        return this.clearExpiredCookies;
    }

    public void setClearExpiredCookies(boolean clearExpiredCookies) {
        this.clearExpiredCookies = clearExpiredCookies;
    }

    public CookieStore getCookieStore() {
        return this.cookieStore;
    }

    public void setCookieStore(CookieStore cookieStore) {
        this.cookieStore = cookieStore;
    }

    public boolean isAuthenticationPreemptive() {
        return this.authenticationPreemptive;
    }

    public void setAuthenticationPreemptive(boolean authenticationPreemptive) {
        this.authenticationPreemptive = authenticationPreemptive;
    }
}

