/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.trove.v1.filters;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Singleton;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;

@Singleton
public class EncodeDotsForUserGet
implements HttpRequestFilter {
    private final Pattern pattern = Pattern.compile("/[^/]*$");

    public HttpRequest filter(HttpRequest request) throws HttpException {
        String endpoint = request.getEndpoint().toString();
        Matcher matcher = this.pattern.matcher(endpoint);
        if (!matcher.find()) {
            return request;
        }
        String encodable = matcher.group();
        String encoded = encodable.replace(".", "%2e");
        String newEndpoint = matcher.replaceFirst(encoded);
        return request.toBuilder().endpoint(newEndpoint).build();
    }
}

