/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic.scaffold;

import java.util.HashMap;
import java.util.Map;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.matcher.ElementMatchers;

public interface BridgeMethodResolver {
    public MethodDescription resolve(MethodDescription var1);

    public static class Simple
    implements BridgeMethodResolver {
        private final Map<String, BridgeTarget> bridges;

        protected Simple(Map<String, BridgeTarget> bridges) {
            this.bridges = bridges;
        }

        public static BridgeMethodResolver of(MethodList methodList, ConflictHandler conflictHandler) {
            MethodList bridgeMethods = (MethodList)methodList.filter(ElementMatchers.isBridge());
            HashMap<String, BridgeTarget> bridges = new HashMap<String, BridgeTarget>(bridgeMethods.size());
            for (MethodDescription bridgeMethod : bridgeMethods) {
                bridges.put(bridgeMethod.getUniqueSignature(), Simple.findBridgeTargetFor(bridgeMethod, conflictHandler));
            }
            return new Simple(bridges);
        }

        private static BridgeTarget findBridgeTargetFor(MethodDescription bridgeMethod, ConflictHandler conflictHandler) {
            MethodList targetCandidates = (MethodList)bridgeMethod.getDeclaringType().getDeclaredMethods().filter(ElementMatchers.not(ElementMatchers.isBridge()).and(ElementMatchers.isSpecializationOf(bridgeMethod)));
            switch (targetCandidates.size()) {
                case 0: {
                    return new BridgeTarget.Resolved(bridgeMethod);
                }
                case 1: {
                    return new BridgeTarget.Candidate((MethodDescription)targetCandidates.getOnly());
                }
            }
            return conflictHandler.choose(bridgeMethod, targetCandidates);
        }

        @Override
        public MethodDescription resolve(MethodDescription methodDescription) {
            BridgeTarget bridgeTarget = this.bridges.get(methodDescription.getUniqueSignature());
            if (bridgeTarget == null) {
                return methodDescription;
            }
            if (bridgeTarget.isResolved()) {
                return bridgeTarget.extract();
            }
            return this.resolve(bridgeTarget.extract());
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.bridges.equals(((Simple)other).bridges);
        }

        public int hashCode() {
            return this.bridges.hashCode();
        }

        public String toString() {
            return "BridgeMethodResolver.Simple{bridges=" + this.bridges + '}';
        }

        public static interface BridgeTarget {
            public MethodDescription extract();

            public boolean isResolved();

            public static class Candidate
            implements BridgeTarget {
                private final MethodDescription target;

                public Candidate(MethodDescription target) {
                    this.target = target;
                }

                @Override
                public MethodDescription extract() {
                    return this.target;
                }

                @Override
                public boolean isResolved() {
                    return false;
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.target.equals(((Candidate)other).target);
                }

                public int hashCode() {
                    return this.target.hashCode();
                }

                public String toString() {
                    return "BridgeMethodResolver.Simple.BridgeTarget.Candidate{target=" + this.target + '}';
                }
            }

            public static class Resolved
            implements BridgeTarget {
                private final MethodDescription target;

                public Resolved(MethodDescription target) {
                    this.target = target;
                }

                @Override
                public MethodDescription extract() {
                    return this.target;
                }

                @Override
                public boolean isResolved() {
                    return true;
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.target.equals(((Resolved)other).target);
                }

                public int hashCode() {
                    return this.target.hashCode();
                }

                public String toString() {
                    return "BridgeMethodResolver.Simple.BridgeTarget.Resolved{target=" + this.target + '}';
                }
            }

            public static enum Unknown implements BridgeTarget
            {
                INSTANCE;


                @Override
                public MethodDescription extract() {
                    throw new IllegalStateException("Could not resolve bridge method target");
                }

                @Override
                public boolean isResolved() {
                    return true;
                }

                public String toString() {
                    return "BridgeMethodResolver.Simple.BridgeTarget.Unknown." + this.name();
                }
            }
        }

        public static interface ConflictHandler {
            public BridgeTarget choose(MethodDescription var1, MethodList var2);

            public static enum Default implements ConflictHandler
            {
                FAIL_FAST{

                    @Override
                    public BridgeTarget choose(MethodDescription bridgeMethod, MethodList targetCandidates) {
                        throw new IllegalStateException("Could not resolve bridge method " + bridgeMethod + " with multiple potential targets " + targetCandidates);
                    }
                }
                ,
                FAIL_ON_REQUEST{

                    @Override
                    public BridgeTarget choose(MethodDescription bridgeMethod, MethodList targetCandidates) {
                        return BridgeTarget.Unknown.INSTANCE;
                    }
                }
                ,
                CALL_BRIDGE{

                    @Override
                    public BridgeTarget choose(MethodDescription bridgeMethod, MethodList targetCandidates) {
                        return new BridgeTarget.Resolved(bridgeMethod);
                    }
                };


                public String toString() {
                    return "BridgeMethodResolver.Simple.ConflictHandler.Default." + this.name();
                }
            }
        }

        public static enum Factory implements net.bytebuddy.dynamic.scaffold.BridgeMethodResolver$Factory
        {
            FAIL_FAST(ConflictHandler.Default.FAIL_FAST),
            FAIL_ON_REQUEST(ConflictHandler.Default.FAIL_ON_REQUEST),
            CALL_BRIDGE(ConflictHandler.Default.CALL_BRIDGE);

            private final ConflictHandler conflictHandler;

            private Factory(ConflictHandler conflictHandler) {
                this.conflictHandler = conflictHandler;
            }

            @Override
            public BridgeMethodResolver make(MethodList methodList) {
                return Simple.of(methodList, this.conflictHandler);
            }

            public String toString() {
                return "BridgeMethodResolver.Simple.Factory." + this.name();
            }
        }
    }

    public static interface Factory {
        public BridgeMethodResolver make(MethodList var1);
    }

    public static enum NoOp implements BridgeMethodResolver,
    Factory
    {
        INSTANCE;


        @Override
        public BridgeMethodResolver make(MethodList relevant) {
            return this;
        }

        @Override
        public MethodDescription resolve(MethodDescription methodDescription) {
            return methodDescription;
        }

        public String toString() {
            return "BridgeMethodResolver.NoOp." + this.name();
        }
    }
}

