/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.PrivateKey;
import java.util.concurrent.ExecutorService;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.chef.ChefApi;
import org.jclouds.chef.ChefService;
import org.jclouds.chef.domain.BootstrapConfig;
import org.jclouds.chef.domain.Client;
import org.jclouds.chef.domain.CookbookVersion;
import org.jclouds.chef.domain.DatabagItem;
import org.jclouds.chef.domain.Environment;
import org.jclouds.chef.domain.Node;
import org.jclouds.chef.functions.BootstrapConfigForGroup;
import org.jclouds.chef.functions.GroupToBootScript;
import org.jclouds.chef.strategy.CleanupStaleNodesAndClients;
import org.jclouds.chef.strategy.CreateNodeAndPopulateAutomaticAttributes;
import org.jclouds.chef.strategy.DeleteAllClientsInList;
import org.jclouds.chef.strategy.DeleteAllNodesInList;
import org.jclouds.chef.strategy.ListClients;
import org.jclouds.chef.strategy.ListCookbookVersions;
import org.jclouds.chef.strategy.ListCookbookVersionsInEnvironment;
import org.jclouds.chef.strategy.ListEnvironments;
import org.jclouds.chef.strategy.ListNodes;
import org.jclouds.chef.strategy.ListNodesInEnvironment;
import org.jclouds.chef.strategy.UpdateAutomaticAttributesOnNode;
import org.jclouds.crypto.Crypto;
import org.jclouds.io.ByteStreams2;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.RSADecryptingPayload;
import org.jclouds.io.payloads.RSAEncryptingPayload;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.Json;
import org.jclouds.logging.Logger;
import org.jclouds.scriptbuilder.domain.Statement;

@Singleton
public class BaseChefService
implements ChefService {
    private final ChefApi api;
    private final CleanupStaleNodesAndClients cleanupStaleNodesAndClients;
    private final CreateNodeAndPopulateAutomaticAttributes createNodeAndPopulateAutomaticAttributes;
    private final DeleteAllNodesInList deleteAllNodesInList;
    private final ListNodes listNodes;
    private final DeleteAllClientsInList deleteAllClientsInList;
    private final ListClients listClients;
    private final UpdateAutomaticAttributesOnNode updateAutomaticAttributesOnNode;
    private final Supplier<PrivateKey> privateKey;
    private final GroupToBootScript groupToBootScript;
    private final String databag;
    private final BootstrapConfigForGroup bootstrapConfigForGroup;
    private final ListCookbookVersions listCookbookVersions;
    private final ListCookbookVersionsInEnvironment listCookbookVersionsInEnvironment;
    private final ListEnvironments listEnvironments;
    private final ListNodesInEnvironment listNodesInEnvironment;
    private final Json json;
    private final Crypto crypto;
    @Resource
    @Named(value="jclouds.chef")
    protected Logger logger = Logger.NULL;

    @Inject
    BaseChefService(ChefApi api, CleanupStaleNodesAndClients cleanupStaleNodesAndClients, CreateNodeAndPopulateAutomaticAttributes createNodeAndPopulateAutomaticAttributes, DeleteAllNodesInList deleteAllNodesInList, ListNodes listNodes, DeleteAllClientsInList deleteAllClientsInList, ListClients listClients, ListCookbookVersions listCookbookVersions, UpdateAutomaticAttributesOnNode updateAutomaticAttributesOnNode, Supplier<PrivateKey> privateKey, @Named(value="chef.bootstrap-databag") String databag, GroupToBootScript groupToBootScript, BootstrapConfigForGroup bootstrapConfigForGroup, ListEnvironments listEnvironments, ListNodesInEnvironment listNodesInEnvironment, ListCookbookVersionsInEnvironment listCookbookVersionsInEnvironment, Json json, Crypto crypto) {
        this.api = api;
        this.cleanupStaleNodesAndClients = cleanupStaleNodesAndClients;
        this.createNodeAndPopulateAutomaticAttributes = createNodeAndPopulateAutomaticAttributes;
        this.deleteAllNodesInList = deleteAllNodesInList;
        this.listNodes = listNodes;
        this.deleteAllClientsInList = deleteAllClientsInList;
        this.listClients = listClients;
        this.listCookbookVersions = listCookbookVersions;
        this.updateAutomaticAttributesOnNode = updateAutomaticAttributesOnNode;
        this.privateKey = privateKey;
        this.groupToBootScript = groupToBootScript;
        this.databag = databag;
        this.bootstrapConfigForGroup = bootstrapConfigForGroup;
        this.listEnvironments = listEnvironments;
        this.listNodesInEnvironment = listNodesInEnvironment;
        this.listCookbookVersionsInEnvironment = listCookbookVersionsInEnvironment;
        this.json = json;
        this.crypto = crypto;
    }

    @Override
    public byte[] encrypt(InputStream input) throws IOException {
        RSAEncryptingPayload payload = new RSAEncryptingPayload(this.crypto, Payloads.newPayload((Object)input), (Key)this.privateKey.get());
        return ByteStreams2.toByteArrayAndClose((InputStream)payload.openStream());
    }

    @Override
    public byte[] decrypt(InputStream input) throws IOException {
        RSADecryptingPayload payload = new RSADecryptingPayload(this.crypto, Payloads.newPayload((Object)input), (Key)this.privateKey.get());
        return ByteStreams2.toByteArrayAndClose((InputStream)payload.openStream());
    }

    @Override
    public Statement createBootstrapScriptForGroup(String group, @Nullable String nodeName) {
        return this.groupToBootScript.apply(group, nodeName);
    }

    @Override
    public Statement createBootstrapScriptForGroup(String group) {
        return this.groupToBootScript.apply(group, null);
    }

    @Override
    public void updateBootstrapConfigForGroup(String group, BootstrapConfig bootstrapConfig) {
        Preconditions.checkNotNull((Object)bootstrapConfig, (Object)"bootstrapConfig cannot be null");
        try {
            this.api.createDatabag(this.databag);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        String jsonConfig = this.buildBootstrapConfiguration(bootstrapConfig);
        DatabagItem config = new DatabagItem(group, jsonConfig);
        if (this.api.getDatabagItem(this.databag, group) == null) {
            this.api.createDatabagItem(this.databag, config);
        } else {
            this.api.updateDatabagItem(this.databag, config);
        }
    }

    @VisibleForTesting
    String buildBootstrapConfiguration(BootstrapConfig config) {
        return this.json.toJson((Object)config);
    }

    @Override
    public BootstrapConfig getBootstrapConfigForGroup(String group) {
        return this.bootstrapConfigForGroup.apply(group);
    }

    @Override
    public void cleanupStaleNodesAndClients(String prefix, int secondsStale) {
        this.cleanupStaleNodesAndClients.execute(prefix, secondsStale);
    }

    @Override
    public Node createNodeAndPopulateAutomaticAttributes(String nodeName, Iterable<String> runList) {
        return this.createNodeAndPopulateAutomaticAttributes.execute(nodeName, runList);
    }

    @Override
    public void updateAutomaticAttributesOnNode(String nodeName) {
        this.updateAutomaticAttributesOnNode.execute(nodeName);
    }

    @Override
    public void deleteAllNodesInList(Iterable<String> names) {
        this.deleteAllNodesInList.execute(names);
    }

    @Override
    public void deleteAllClientsInList(Iterable<String> names) {
        this.deleteAllClientsInList.execute(names);
    }

    @Override
    public Iterable<? extends Node> listNodes() {
        return this.listNodes.execute();
    }

    @Override
    public Iterable<? extends Node> listNodes(ExecutorService executorService) {
        return this.listNodes.execute(executorService);
    }

    @Override
    public Iterable<? extends Client> listClients() {
        return this.listClients.execute();
    }

    @Override
    public Iterable<? extends Client> listClients(ExecutorService executorService) {
        return this.listClients.execute(executorService);
    }

    @Override
    public Iterable<? extends CookbookVersion> listCookbookVersions() {
        return this.listCookbookVersions.execute();
    }

    @Override
    public Iterable<? extends CookbookVersion> listCookbookVersions(ExecutorService executorService) {
        return this.listCookbookVersions.execute(executorService);
    }

    @Override
    public Iterable<? extends CookbookVersion> listCookbookVersionsInEnvironment(String environmentName) {
        return this.listCookbookVersionsInEnvironment.execute(environmentName);
    }

    @Override
    public Iterable<? extends CookbookVersion> listCookbookVersionsInEnvironment(String environmentName, ExecutorService executorService) {
        return this.listCookbookVersionsInEnvironment.execute(executorService, environmentName);
    }

    @Override
    public Iterable<? extends CookbookVersion> listCookbookVersionsInEnvironment(String environmentName, String numVersions) {
        return this.listCookbookVersionsInEnvironment.execute(environmentName, numVersions);
    }

    @Override
    public Iterable<? extends CookbookVersion> listCookbookVersionsInEnvironment(String environmentName, String numVersions, ExecutorService executorService) {
        return this.listCookbookVersionsInEnvironment.execute(executorService, environmentName, numVersions);
    }

    @Override
    public Iterable<? extends Environment> listEnvironments() {
        return this.listEnvironments.execute();
    }

    @Override
    public Iterable<? extends Node> listNodesInEnvironment(String environmentName) {
        return this.listNodesInEnvironment.execute(environmentName);
    }

    @Override
    public Iterable<? extends Node> listNodesInEnvironment(String environmentName, ExecutorService executorService) {
        return this.listNodesInEnvironment.execute(executorService, environmentName);
    }
}

