/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.user;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.metamodel.SingularAttribute;
import jeeves.server.ServiceConfig;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.domain.User;
import org.fao.geonet.domain.User_;
import org.fao.geonet.domain.responses.UserList;
import org.fao.geonet.repository.GroupRepository;
import org.fao.geonet.repository.SortUtils;
import org.fao.geonet.repository.UserGroupRepository;
import org.fao.geonet.repository.UserRepository;
import org.fao.geonet.repository.specification.UserGroupSpecs;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.domain.Specifications;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.AuthenticationCredentialsNotFoundException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="admin.user.list")
@Deprecated
public class List {
    public void init(String appPath, ServiceConfig params) throws Exception {
    }

    @RequestMapping(value={"/{portal}/{lang}/admin.user.list"}, produces={"application/xml", "application/json"})
    @ResponseBody
    public UserList exec() throws Exception {
        SecurityContext context = SecurityContextHolder.getContext();
        if (context == null || context.getAuthentication() == null) {
            throw new AuthenticationCredentialsNotFoundException("User needs to log in");
        }
        UserRepository userRepository = (UserRepository)ApplicationContextHolder.get().getBean(UserRepository.class);
        User me = userRepository.findOneByUsername(context.getAuthentication().getName());
        if (me == null) {
            throw new AccessDeniedException(SecurityContextHolder.class.getSimpleName() + " has a user that is not in the database: " + context.getAuthentication());
        }
        Set<Integer> hsMyGroups = this.getGroups(me.getId(), me.getProfile());
        Collection roles = me.getAuthorities();
        HashSet profileSet = Sets.newHashSet();
        for (GrantedAuthority rol : roles) {
            profileSet.add(rol.getAuthority());
        }
        java.util.List all = userRepository.findAll(SortUtils.createSort((SingularAttribute[])new SingularAttribute[]{User_.username}));
        HashSet<Integer> usersToRemove = new HashSet<Integer>();
        if (!profileSet.contains(Profile.Administrator.name())) {
            for (User user : all) {
                int userId = user.getId();
                Profile profile = user.getProfile();
                if (user.getUsername().equals(context.getAuthentication().getName())) continue;
                Set<Integer> userGroups = this.getGroups(userId, profile);
                boolean isInCurrentUserAdminGroups = false;
                for (Integer userGroup : userGroups) {
                    if (!hsMyGroups.contains(userGroup)) continue;
                    isInCurrentUserAdminGroups = true;
                    break;
                }
                if (!isInCurrentUserAdminGroups) {
                    usersToRemove.add(user.getId());
                }
                if (profileSet.contains(profile.name())) continue;
                usersToRemove.add(user.getId());
            }
        }
        UserList res = new UserList();
        for (User u : Collections.unmodifiableList(all)) {
            if (usersToRemove.contains(u.getId())) continue;
            res.addUser(u);
        }
        return res;
    }

    private Set<Integer> getGroups(int id, Profile profile) throws Exception {
        HashSet<Integer> hs = new HashSet<Integer>();
        GroupRepository groupRepository = (GroupRepository)ApplicationContextHolder.get().getBean(GroupRepository.class);
        UserGroupRepository userGroupRepo = (UserGroupRepository)ApplicationContextHolder.get().getBean(UserGroupRepository.class);
        if (profile == Profile.Administrator) {
            hs.addAll(groupRepository.findIds());
        } else if (profile == Profile.UserAdmin) {
            hs.addAll(userGroupRepo.findGroupIds((Specification)Specifications.where((Specification)UserGroupSpecs.hasProfile((Profile)profile)).and(UserGroupSpecs.hasUserId((int)id))));
        } else {
            hs.addAll(userGroupRepo.findGroupIds(UserGroupSpecs.hasUserId((int)id)));
        }
        return hs;
    }
}

