/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.resources;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import jeeves.server.dispatchers.ServiceManager;
import org.fao.geonet.api.processing.XslProcessUtils;
import org.fao.geonet.api.processing.report.XsltMetadataProcessingReport;
import org.fao.geonet.domain.responses.IdResponse;
import org.fao.geonet.exceptions.BadParameterEx;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.services.metadata.XslProcessing;
import org.fao.geonet.services.resources.handlers.IResourceUploadHandler;
import org.jdom.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller(value="resource.upload.and.link")
@Deprecated
public class UploadAndProcess {
    @Autowired
    private DataManager dm;
    @Autowired
    private XslProcessing xslProcessing;
    @Autowired
    private ServiceManager serviceManager;

    @RequestMapping(value={"/{portal}/{lang}/resource.upload.and.link", "/{portal}/{lang}/resource-onlinesrc-upload"}, produces={"application/xml", "application/json"})
    @ResponseBody
    public IdResponse exec(HttpServletRequest request, @PathVariable String lang, @RequestParam(value="filename") MultipartFile file, @RequestParam(defaultValue="") String description, @RequestParam(defaultValue="") String id, @RequestParam(defaultValue="") String uuid, @RequestParam(defaultValue="private", value="access") String access, @RequestParam(value="overwrite", defaultValue="no") String overwrite) throws Exception {
        try (ServiceContext context = this.serviceManager.createServiceContext("resource.upload.and.link", lang, request);){
            if (id.trim().isEmpty()) {
                id = this.dm.getMetadataId(uuid);
            }
            Lib.resource.checkEditPrivilege(context, id);
            UserSession session = context.getUserSession();
            String username = session.getUsername();
            if (username == null) {
                username = "unknown (this shouldn't happen?)";
            }
            String fname = file.getOriginalFilename();
            String fsize = Long.toString(file.getSize());
            IResourceUploadHandler uploadHook = (IResourceUploadHandler)context.getBean("resourceUploadHandler", IResourceUploadHandler.class);
            uploadHook.onUpload(file.getInputStream(), context, access, overwrite, Integer.parseInt(id), fname, Double.parseDouble(fsize));
            context.info("UPLOADED:" + fname + "," + id + "," + context.getIpAddress() + "," + username);
            HashMap allParams = Maps.newHashMap((Map)request.getParameterMap());
            allParams.put("url", new String[]{file.getName()});
            allParams.put("name", new String[]{file.getOriginalFilename()});
            allParams.put("desc", new String[]{description});
            allParams.put("protocol", new String[]{"WWW:DOWNLOAD-1.0-http--download"});
            String process = "onlinesrc-add";
            XsltMetadataProcessingReport report = new XsltMetadataProcessingReport(process);
            String siteURL = ((SettingManager)context.getBean(SettingManager.class)).getSiteURL(context);
            Element processedMetadata = XslProcessUtils.process(context, id, process, true, true, true, report, siteURL, allParams);
            if (processedMetadata == null) {
                throw new BadParameterEx("Processing failed", (Object)("Not found:" + report.getNumberOfRecordNotFound() + ", Not owner:" + report.getNumberOfRecordsNotEditable() + ", No process found:" + report.getNoProcessFoundCount() + "."));
            }
            IdResponse idResponse = new IdResponse(id);
            return idResponse;
        }
    }
}

