/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.main;

import java.nio.file.Path;
import jeeves.interfaces.Service;
import jeeves.server.ServiceConfig;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.Util;
import org.fao.geonet.exceptions.BadParameterEx;
import org.fao.geonet.kernel.SelectionManager;
import org.fao.geonet.kernel.search.MetaSearcher;
import org.fao.geonet.kernel.search.SearchManager;
import org.fao.geonet.kernel.search.SearcherType;
import org.fao.geonet.services.util.SearchDefaults;
import org.jdom.Content;
import org.jdom.Element;

public class XmlSearch
implements Service {
    private ServiceConfig _config;
    private String _searchFast;
    private int maxRecordValue = 100;
    private boolean allowUnboundedQueries = false;

    public void init(Path appPath, ServiceConfig config) throws Exception {
        this._config = config;
        this._searchFast = config.getValue("fast", "true");
        this.maxRecordValue = Integer.parseInt(config.getValue("maxRecords", "100"));
        this.allowUnboundedQueries = Boolean.parseBoolean(config.getValue("allowUnboundedQueries", "false"));
    }

    private boolean setSafeBoundaries(Element params) {
        boolean fromUndefined = params.getChild("from") == null;
        int from = Util.getParam((Element)params, (String)"from", (int)0);
        boolean toUndefined = params.getChild("to") == null;
        int to = Util.getParam((Element)params, (String)"to", (int)Integer.MAX_VALUE);
        if (to - from < 0) {
            throw new BadParameterEx("Bad range requested, check the from/to parameters");
        }
        boolean boundariesSet = false;
        if (fromUndefined && toUndefined) {
            params.addContent((Content)new Element("from").setText("1"));
            params.addContent((Content)new Element("to").setText(Integer.toString(this.maxRecordValue)));
            boundariesSet = true;
        } else if (fromUndefined && !toUndefined) {
            params.addContent((Content)new Element("from").setText(Integer.toString(Math.max(1, to - this.maxRecordValue))));
            boundariesSet = true;
        } else if (!fromUndefined && toUndefined) {
            params.addContent((Content)new Element("to").setText(Integer.toString(from + this.maxRecordValue - 1)));
            boundariesSet = true;
        } else if (to - from >= this.maxRecordValue) {
            params.removeChildren("to");
            params.addContent((Content)new Element("to").setText(Integer.toString(from + this.maxRecordValue - 1)));
            boundariesSet = true;
        }
        return boundariesSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element exec(Element params, ServiceContext context) throws Exception {
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        SearchManager searchMan = (SearchManager)gc.getBean(SearchManager.class);
        String bucket = Util.getParam((Element)params, (String)"bucket", (String)"metadata");
        params.removeChild("bucket");
        boolean boundariesSet = false;
        if (!this.allowUnboundedQueries) {
            boundariesSet = this.setSafeBoundaries(params);
        }
        Element elData = SearchDefaults.getDefaultSearch((ServiceContext)context, (Element)params);
        UserSession session = context.getUserSession();
        try (MetaSearcher searcher = searchMan.newSearcher(SearcherType.LUCENE, "lucene.xsl");){
            String summaryOnly = Util.getParam((Element)params, (String)"summaryOnly", (String)"0");
            String sBuildSummary = params.getChildText("buildSummary");
            if (sBuildSummary != null && sBuildSummary.equals("false") && !"0".equals(summaryOnly)) {
                elData.getChild("buildSummary").setText("true");
            }
            session.setProperty("search.request" + bucket, elData.clone());
            searcher.search(context, elData, this._config);
            if (!"0".equals(summaryOnly)) {
                Element element = searcher.getSummary();
                return element;
            }
            elData.addContent((Content)new Element("fast").setText(this._searchFast));
            if (!boundariesSet) {
                elData.addContent((Content)new Element("from").setText("1"));
                elData.addContent((Content)new Element("to").setText(searcher.getSize() + ""));
            }
            Element result = searcher.present(context, elData, this._config);
            SelectionManager.updateMDResult((UserSession)context.getUserSession(), (Element)result, (String)bucket);
            if (!this.allowUnboundedQueries) {
                result = result.setAttribute("maxPageSize", this.getMaxRecordValue() + "");
            }
            Element element = result;
            return element;
        }
    }

    public int getMaxRecordValue() {
        return this.maxRecordValue;
    }
}

