/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.selections;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;
import jeeves.server.UserSession;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.domain.Language;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.domain.Selection;
import org.fao.geonet.domain.User;
import org.fao.geonet.domain.UserSavedSelection;
import org.fao.geonet.domain.UserSavedSelectionId;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.repository.LanguageRepository;
import org.fao.geonet.repository.SelectionRepository;
import org.fao.geonet.repository.UserGroupRepository;
import org.fao.geonet.repository.UserRepository;
import org.fao.geonet.repository.UserSavedSelectionRepository;
import org.fao.geonet.repository.specification.UserGroupSpecs;
import org.fao.geonet.utils.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.domain.Specifications;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import springfox.documentation.annotations.ApiIgnore;

@RequestMapping(value={"/{portal}/api/userselections", "/{portal}/api/0.1/userselections"})
@Api(value="userselections", tags={"userselections"}, description="User selections related operations")
@Controller(value="userselections")
public class UserSelectionsApi {
    @Autowired
    SelectionRepository selectionRepository;
    @Autowired
    UserSavedSelectionRepository umsRepository;
    @Autowired
    UserRepository userRepository;
    @Autowired
    LanguageRepository langRepository;
    @Autowired
    IMetadataUtils metadataRepository;
    @Autowired
    UserGroupRepository userGroupRepository;

    @ApiOperation(value="Get list of user selection sets", nickname="getUserSelectionType")
    @RequestMapping(method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    public List<Selection> get(@ApiIgnore HttpSession httpSession) throws Exception {
        return this.selectionRepository.findAll();
    }

    @ApiOperation(value="Add a user selection set", nickname="createUserSelectionType")
    @RequestMapping(method={RequestMethod.PUT}, produces={"application/json"})
    @ApiResponses(value={@ApiResponse(code=201, message="Selection created."), @ApiResponse(code=400, message="A selection with that id or name already exist."), @ApiResponse(code=403, message="Operation not allowed. Only UserAdmins can access it.")})
    @PreAuthorize(value="hasRole('UserAdmin')")
    @ResponseBody
    public ResponseEntity createPersistentSelectionType(@ApiParam(name="selection") @RequestBody Selection selection) throws Exception {
        Selection existingSelection = (Selection)this.selectionRepository.findOne((Serializable)Integer.valueOf(selection.getId()));
        if (existingSelection != null) {
            throw new IllegalArgumentException(String.format("A selection with id '%d' already exist. Choose another id or unset it.", selection.getId()));
        }
        existingSelection = this.selectionRepository.findOneByName(selection.getName());
        if (existingSelection != null) {
            throw new IllegalArgumentException(String.format("A selection with name '%s' already exist. Choose another name.", selection.getName()));
        }
        List allLanguages = this.langRepository.findAll();
        Map labelTranslations = selection.getLabelTranslations();
        for (Language l : allLanguages) {
            String label = (String)labelTranslations.get(l.getId());
            selection.getLabelTranslations().put(l.getId(), label == null ? selection.getName() : label);
        }
        this.selectionRepository.save((Object)selection);
        return new ResponseEntity((Object)selection.getId(), HttpStatus.CREATED);
    }

    @ApiOperation(value="Update a user selection set", notes="", nickname="updateUserSelection")
    @RequestMapping(value={"/{selectionIdentifier}"}, method={RequestMethod.PUT})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ApiResponses(value={@ApiResponse(code=204, message="Selection updated."), @ApiResponse(code=404, message="Selection not found."), @ApiResponse(code=403, message="Operation not allowed. Only UserAdmins can access it.")})
    @PreAuthorize(value="hasRole('UserAdmin')")
    public ResponseEntity updateUserSelection(@ApiParam(value="Selection identifier", required=true) @PathVariable Integer selectionIdentifier, @ApiParam(name="selection") @RequestBody Selection selection) throws Exception {
        Selection existingSelection = (Selection)this.selectionRepository.findOne((Serializable)selectionIdentifier);
        if (existingSelection == null) {
            throw new ResourceNotFoundException(String.format("Selection with id '%d' does not exist.", selectionIdentifier));
        }
        selection.setId(selectionIdentifier.intValue());
        this.selectionRepository.save((Object)selection);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @ApiOperation(value="Remove a user selection set", notes="", nickname="deleteUserSelection")
    @RequestMapping(value={"/{selectionIdentifier}"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ApiResponses(value={@ApiResponse(code=204, message="Selection removed."), @ApiResponse(code=404, message="Selection not found."), @ApiResponse(code=403, message="Operation not allowed. Only UserAdmins can access it.")})
    @PreAuthorize(value="hasRole('UserAdmin')")
    public ResponseEntity deleteUserSelection(@ApiParam(value="Selection identifier", required=true) @PathVariable Integer selectionIdentifier) throws Exception {
        Selection selection = (Selection)this.selectionRepository.findOne((Serializable)selectionIdentifier);
        if (selection == null) {
            throw new ResourceNotFoundException(String.format("Selection with id '%d' does not exist.", selectionIdentifier));
        }
        this.umsRepository.deleteAllBySelection(selectionIdentifier);
        this.selectionRepository.delete((Serializable)selectionIdentifier);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @ApiOperation(value="Get record in a user selection set", nickname="getSelection")
    @RequestMapping(method={RequestMethod.GET}, value={"/{selectionIdentifier}/{userIdentifier}"}, produces={"application/json"})
    @PreAuthorize(value="hasRole('Guest')")
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    public List<String> get(@ApiParam(value="Selection identifier", required=true) @PathVariable Integer selectionIdentifier, @ApiParam(value="User identifier", required=true) @PathVariable Integer userIdentifier, @ApiIgnore HttpSession httpSession) throws Exception {
        User user = this.checkUserAllowed(httpSession, userIdentifier);
        Selection selection = (Selection)this.selectionRepository.findOne((Serializable)selectionIdentifier);
        if (selection == null) {
            throw new ResourceNotFoundException(String.format("Selection with id '%d' does not exist.", selectionIdentifier));
        }
        return this.umsRepository.findMetadata(selectionIdentifier, userIdentifier);
    }

    @ApiOperation(value="Add items to a user selection set", nickname="addToUserSelection")
    @RequestMapping(method={RequestMethod.PUT}, value={"/{selectionIdentifier}/{userIdentifier}"}, produces={"application/json"})
    @PreAuthorize(value="hasRole('Guest')")
    @ResponseBody
    @ApiResponses(value={@ApiResponse(code=201, message="Records added to selection set."), @ApiResponse(code=404, message="Selection or user or at least one UUID not found."), @ApiResponse(code=403, message="Operation not allowed. Only UserAdmins can access it.")})
    public ResponseEntity<String> addToUserSelection(@ApiParam(value="Selection identifier", required=true) @PathVariable Integer selectionIdentifier, @ApiParam(value="User identifier", required=true) @PathVariable Integer userIdentifier, @ApiParam(value="One or more record UUIDs.", required=false) @RequestParam(required=false) String[] uuid, @ApiIgnore HttpSession httpSession) throws Exception {
        User user = this.checkUserAllowed(httpSession, userIdentifier);
        Selection selection = (Selection)this.selectionRepository.findOne((Serializable)selectionIdentifier);
        if (selection == null) {
            throw new ResourceNotFoundException(String.format("Selection with id '%d' does not exist.", selectionIdentifier));
        }
        for (String u : uuid) {
            if (this.metadataRepository.existsMetadataUuid(u)) {
                UserSavedSelection e = new UserSavedSelection(selection, user, u);
                try {
                    this.umsRepository.save((Object)e);
                }
                catch (Exception e1) {
                    Log.error((String)"geonetwork.api", (Object)("UserSelectionsApi - addToUserSelection: " + e1.getMessage()), (Throwable)e1);
                }
                continue;
            }
            return new ResponseEntity((Object)u, HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity(HttpStatus.CREATED);
    }

    @ApiOperation(value="Remove items to a user selection set", nickname="deleteFromUserSelection")
    @RequestMapping(method={RequestMethod.DELETE}, value={"/{selectionIdentifier}/{userIdentifier}"}, produces={"application/json"})
    @PreAuthorize(value="hasRole('Guest')")
    @ResponseBody
    @ApiResponses(value={@ApiResponse(code=204, message="Items removed from a set."), @ApiResponse(code=404, message="Selection or user not found."), @ApiResponse(code=403, message="Operation not allowed. Only UserAdmins can access it.")})
    public ResponseEntity deleteFromUserSelection(@ApiParam(value="Selection identifier", required=true) @PathVariable Integer selectionIdentifier, @ApiParam(value="User identifier", required=true) @PathVariable Integer userIdentifier, @ApiParam(value="One or more record UUIDs. If null, remove all.", required=false) @RequestParam(required=false) String[] uuid, @ApiIgnore HttpSession httpSession) throws Exception {
        User user = this.checkUserAllowed(httpSession, userIdentifier);
        Selection selection = (Selection)this.selectionRepository.findOne((Serializable)selectionIdentifier);
        if (selection == null) {
            throw new ResourceNotFoundException(String.format("Selection with id '%d' does not exist.", selectionIdentifier));
        }
        if (uuid == null || uuid.length == 0) {
            this.umsRepository.deleteAllBySelectionAndUser(selectionIdentifier, userIdentifier);
        } else {
            for (String u : uuid) {
                UserSavedSelectionId e = new UserSavedSelectionId().setSelectionId(selectionIdentifier.intValue()).setUserId(userIdentifier.intValue()).setMetadataUuid(u);
                this.umsRepository.delete((Serializable)e);
            }
        }
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    private User checkUserAllowed(HttpSession httpSession, Integer userIdentifier) throws ResourceNotFoundException {
        UserSession session = ApiUtils.getUserSession(httpSession);
        Profile myProfile = session.getProfile();
        String myUserId = session.getUserId();
        if (myProfile.equals((Object)Profile.Administrator) || myProfile.equals((Object)Profile.UserAdmin) || myUserId.equals(Integer.toString(userIdentifier))) {
            List myUserGroupsAsUserAdmin;
            List adminlist;
            User user = (User)this.userRepository.findOne((Serializable)userIdentifier);
            if (user == null) {
                throw new ResourceNotFoundException(String.format("User with id '%d' does not exist.", userIdentifier));
            }
            if (!myUserId.equals(Integer.toString(userIdentifier)) && myProfile == Profile.UserAdmin && (adminlist = this.userGroupRepository.findGroupIds((Specification)Specifications.where((Specification)UserGroupSpecs.hasGroupIds((List)(myUserGroupsAsUserAdmin = this.userGroupRepository.findGroupIds((Specification)Specifications.where((Specification)UserGroupSpecs.hasUserId((int)Integer.parseInt(myUserId))).and(UserGroupSpecs.hasProfile((Profile)Profile.UserAdmin)))))).and(UserGroupSpecs.hasUserId((int)userIdentifier)))).isEmpty()) {
                throw new IllegalArgumentException("You don't have rights to do this because the user you want to edit is not part of your group");
            }
            return user;
        }
        throw new IllegalArgumentException("You don't have rights to do this");
    }
}

