/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.formatters;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.records.formatters.AbstractFormatService;
import org.fao.geonet.api.records.formatters.ConfigFile;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.utils.IO;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="md.formatter.list")
public class ListFormatters
extends AbstractFormatService {
    private void addFormatters(String schema, FormatterDataResponse response, Path root, Path file, boolean isSchemaPluginFormatter, boolean publishedOnly) throws IOException {
        if (!Files.exists(file, new LinkOption[0])) {
            return;
        }
        try (DirectoryStream<Path> paths = Files.newDirectoryStream(file, IO.DIRECTORIES_FILTER);){
            for (Path formatter : paths) {
                boolean add = true;
                if (FORMATTER_FILTER.accept(formatter)) {
                    ConfigFile config = new ConfigFile(formatter, true, null);
                    if (publishedOnly && !config.isPublished()) continue;
                    List<String> applicableSchemas = config.listOfApplicableSchemas();
                    if (!(schema.equalsIgnoreCase("all") || isSchemaPluginFormatter || applicableSchemas.contains(schema))) {
                        add = false;
                    }
                    if (!add) continue;
                    String path = root.relativize(formatter).toString().replace("\\", "/");
                    if (path.startsWith("/")) {
                        path = path.substring(1);
                    }
                    FormatterData formatterData = isSchemaPluginFormatter ? new FormatterData(schema, path) : new FormatterData(null, path);
                    response.add(formatterData);
                    continue;
                }
                this.addFormatters(schema, response, root, formatter, isSchemaPluginFormatter, publishedOnly);
            }
        }
    }

    @RequestMapping(value={"/{portal}/{lang}/md.formatter.list"}, produces={"application/xml", "application/json"})
    @ResponseBody
    public FormatterDataResponse exec(@RequestParam(required=false) String id, @RequestParam(required=false) String uuid, @RequestParam(defaultValue="all") String schema, @RequestParam(defaultValue="false") boolean pluginOnly, @RequestParam(defaultValue="true") boolean publishedOnly) throws Exception {
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        if (id != null || uuid != null) {
            try {
                this.loadMetadata((IMetadataUtils)applicationContext.getBean(IMetadataUtils.class), Integer.parseInt(this.resolveId(id, uuid)));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (schema == null) {
            schema = "all";
        }
        schema = schema.trim();
        FormatterDataResponse response = new FormatterDataResponse();
        if (!pluginOnly) {
            Path userXslDir = ((GeonetworkDataDirectory)applicationContext.getBean(GeonetworkDataDirectory.class)).getFormatterDir();
            this.addFormatters(schema, response, userXslDir, userXslDir, false, publishedOnly);
        }
        Set schemas = ((SchemaManager)applicationContext.getBean(SchemaManager.class)).getSchemas();
        for (String schemaName : schemas) {
            if (!schema.equals("all") && !schema.equals(schemaName)) continue;
            Path schemaDir = ((SchemaManager)applicationContext.getBean(SchemaManager.class)).getSchemaDir(schemaName);
            Path formatterDir = schemaDir.resolve("formatter");
            this.addFormatters(schemaName, response, formatterDir, formatterDir, true, publishedOnly);
        }
        return response;
    }

    @XmlRootElement(name="formatter")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static final class FormatterData
    implements Serializable {
        private static final long serialVersionUID = 2015204126746590712L;
        @XmlElement(name="schema")
        private final String schema;
        private final String id;

        public FormatterData(String schema, String id) {
            this.schema = schema;
            this.id = id;
        }

        public String toString() {
            return "FormatterData{schema ='" + this.schema + '\'' + ", id='" + this.id + '\'' + '}';
        }

        public String getSchema() {
            return this.schema;
        }

        public String getId() {
            return this.id;
        }
    }

    @XmlRootElement(name="formatters")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static final class FormatterDataResponse
    implements Serializable {
        private static final long serialVersionUID = 8674269207113596010L;
        @XmlElement(name="formatter")
        private List<FormatterData> formatters = Lists.newArrayList();

        public void add(FormatterData formatterData) {
            this.formatters.add(formatterData);
        }

        public String toString() {
            return "FormatterDataResponse{" + this.formatters + '}';
        }

        public List<FormatterData> getFormatters() {
            return this.formatters;
        }
    }
}

