/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.formatters;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import jeeves.interfaces.Service;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.Util;
import org.fao.geonet.ZipUtil;
import org.fao.geonet.api.records.formatters.AbstractFormatService;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.utils.BinaryFile;
import org.fao.geonet.utils.IO;
import org.jdom.Element;

public class Download
extends AbstractFormatService
implements Service {
    public Element exec(Element params, ServiceContext context) throws Exception {
        String xslid = Util.getParam((Element)params, (String)"id", null);
        String schema = Util.getParam((Element)params, (String)"schema", null);
        Path schemaDir = null;
        if (schema != null) {
            schemaDir = ((SchemaManager)context.getBean(SchemaManager.class)).getSchemaDir(schema);
        }
        Path formatDir = this.getAndVerifyFormatDir((GeonetworkDataDirectory)context.getBean(GeonetworkDataDirectory.class), "id", xslid, schemaDir);
        try {
            File tmpDir = (File)context.getServlet().getServletContext().getAttribute("javax.servlet.context.tempdir");
            Path zippedFile = Files.createTempFile(tmpDir.toPath(), xslid, ".zip", new FileAttribute[0]);
            try (FileSystem zipFs = ZipUtil.createZipFs((Path)zippedFile);
                 DirectoryStream<Path> paths = Files.newDirectoryStream(formatDir);){
                Path root = zipFs.getRootDirectories().iterator().next();
                for (Path path : paths) {
                    IO.copyDirectoryOrFile((Path)path, (Path)root, (boolean)true);
                }
            }
            return BinaryFile.encode((int)200, (Path)zippedFile, (String)(xslid + ".zip"), (boolean)true).getElement();
        }
        catch (IOException e) {
            throw new RuntimeException("Error occured while trying to download file");
        }
    }
}

