/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import jeeves.services.ReadWriteController;
import org.apache.commons.lang3.StringUtils;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.api.processing.report.MetadataProcessingReport;
import org.fao.geonet.api.processing.report.SimpleMetadataProcessingReport;
import org.fao.geonet.api.records.model.GroupOperations;
import org.fao.geonet.api.records.model.GroupPrivilege;
import org.fao.geonet.api.records.model.MetadataPublicationNotificationInfo;
import org.fao.geonet.api.records.model.SharingParameter;
import org.fao.geonet.api.records.model.SharingResponse;
import org.fao.geonet.api.tools.i18n.LanguageUtils;
import org.fao.geonet.config.IPublicationConfig;
import org.fao.geonet.config.PublicationOption;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.Group;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.Metadata;
import org.fao.geonet.domain.MetadataDraft;
import org.fao.geonet.domain.MetadataStatus;
import org.fao.geonet.domain.MetadataStatus_;
import org.fao.geonet.domain.Operation;
import org.fao.geonet.domain.OperationAllowed;
import org.fao.geonet.domain.OperationAllowedId;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.domain.ReservedGroup;
import org.fao.geonet.domain.ReservedOperation;
import org.fao.geonet.domain.StatusValueType;
import org.fao.geonet.domain.User;
import org.fao.geonet.domain.UserGroup;
import org.fao.geonet.domain.utils.ObjectJSONUtils;
import org.fao.geonet.events.history.RecordGroupOwnerChangeEvent;
import org.fao.geonet.events.history.RecordOwnerChangeEvent;
import org.fao.geonet.events.history.RecordPrivilegesChangeEvent;
import org.fao.geonet.kernel.AccessManager;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.datamanager.IMetadataIndexer;
import org.fao.geonet.kernel.datamanager.IMetadataManager;
import org.fao.geonet.kernel.datamanager.IMetadataStatus;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.datamanager.IMetadataValidator;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.repository.GroupRepository;
import org.fao.geonet.repository.MetadataRepository;
import org.fao.geonet.repository.MetadataStatusRepository;
import org.fao.geonet.repository.MetadataValidationRepository;
import org.fao.geonet.repository.OperationAllowedRepository;
import org.fao.geonet.repository.OperationRepository;
import org.fao.geonet.repository.UserGroupRepository;
import org.fao.geonet.repository.UserRepository;
import org.fao.geonet.repository.specification.MetadataSpecs;
import org.fao.geonet.repository.specification.MetadataValidationSpecs;
import org.fao.geonet.repository.specification.OperationAllowedSpecs;
import org.fao.geonet.repository.specification.UserGroupSpecs;
import org.fao.geonet.util.MetadataPublicationMailNotifier;
import org.fao.geonet.util.WorkflowUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.domain.Specifications;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.hierarchicalroles.RoleHierarchy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import springfox.documentation.annotations.ApiIgnore;

@RequestMapping(value={"/{portal}/api/records", "/{portal}/api/0.1/records"})
@Api(value="records", tags={"records"}, description="Metadata record operations")
@PreAuthorize(value="hasRole('Editor')")
@Controller(value="recordSharing")
@ReadWriteController
public class MetadataSharingApi {
    private static final String DEFAULT_PUBLICATION_TYPE_NAME = "default";
    @Autowired
    LanguageUtils languageUtils;
    @Autowired
    DataManager dataManager;
    @Autowired
    IMetadataIndexer metadataIndexer;
    @Autowired
    AccessManager accessManager;
    @Autowired
    SettingManager sm;
    @Autowired
    IMetadataUtils metadataUtils;
    @Autowired
    IMetadataStatus metadataStatus;
    @Autowired
    MetadataRepository metadataRepository;
    @Autowired
    IMetadataValidator validator;
    @Autowired
    IMetadataManager metadataManager;
    @Autowired
    MetadataValidationRepository metadataValidationRepository;
    @Autowired
    OperationRepository operationRepository;
    @Autowired
    OperationAllowedRepository operationAllowedRepository;
    @Autowired
    GroupRepository groupRepository;
    @Autowired
    UserRepository userRepository;
    @Autowired
    UserGroupRepository userGroupRepository;
    @Autowired
    MetadataStatusRepository metadataStatusRepository;
    @Autowired
    RoleHierarchy roleHierarchy;
    @Autowired
    MetadataPublicationMailNotifier metadataPublicationMailNotifier;
    @Autowired
    private IPublicationConfig publicationConfig;

    @ApiOperation(value="Get publication options.", nickname="publishOptions")
    @RequestMapping(value={"/sharing/options"}, method={RequestMethod.GET})
    @PreAuthorize(value="permitAll")
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public List<PublicationOption> getPublicationOptions() {
        return this.publicationConfig.getPublicationOptions();
    }

    @ApiOperation(value="Set privileges for ALL group to publish the metadata for all users.", nickname="publish")
    @RequestMapping(value={"/{metadataUuid}/publish"}, method={RequestMethod.PUT})
    @ApiResponses(value={@ApiResponse(code=204, message="Settings updated."), @ApiResponse(code=403, message="Operation not allowed. User needs to be able to edit the resource.")})
    @PreAuthorize(value="hasRole('Reviewer')")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void publish(@ApiParam(value="Record UUID.", required=true) @PathVariable String metadataUuid, @ApiParam(value="Publication type") @RequestParam(required=false) String publicationType, @ApiIgnore @ApiParam(hidden=true) HttpSession session, HttpServletRequest request) throws Exception {
        if (StringUtils.isEmpty((CharSequence)publicationType)) {
            publicationType = DEFAULT_PUBLICATION_TYPE_NAME;
        }
        this.shareMetadataWithReservedGroup(metadataUuid, true, publicationType, session, request);
    }

    @ApiOperation(value="Unsets privileges for ALL group to publish the metadata for all users.", nickname="unpublish")
    @RequestMapping(value={"/{metadataUuid}/unpublish"}, method={RequestMethod.PUT})
    @ApiResponses(value={@ApiResponse(code=204, message="Settings updated."), @ApiResponse(code=403, message="Operation not allowed. User needs to be able to edit the resource.")})
    @PreAuthorize(value="hasRole('Reviewer')")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void unpublish(@ApiParam(value="Record UUID.", required=true) @PathVariable String metadataUuid, @ApiParam(value="Publication type") @RequestParam(required=false) String publicationType, @ApiIgnore @ApiParam(hidden=true) HttpSession session, HttpServletRequest request) throws Exception {
        if (StringUtils.isEmpty((CharSequence)publicationType)) {
            publicationType = DEFAULT_PUBLICATION_TYPE_NAME;
        }
        this.shareMetadataWithReservedGroup(metadataUuid, false, publicationType, session, request);
    }

    @ApiOperation(value="Set record sharing", notes="Privileges are assigned by group. User needs to be able to edit a record to set sharing settings. For reserved group (ie. Internet, Intranet & Guest), user MUST be reviewer of one group. For other group, if Only set privileges to user's groups is set in catalog configuration user MUST be a member of the group.<br/>Clear first allows to unset all operations first before setting the new ones.Clear option does not remove reserved groups operation if user is not an administrator, a reviewer or the owner of the record.<br/><a href='http://geonetwork-opensource.org/manuals/trunk/eng/users/user-guide/publishing/managing-privileges.html'>More info</a>", nickname="share")
    @RequestMapping(value={"/{metadataUuid}/sharing"}, method={RequestMethod.PUT})
    @ApiResponses(value={@ApiResponse(code=204, message="Settings updated."), @ApiResponse(code=403, message="Operation not allowed. User needs to be able to edit the resource.")})
    @PreAuthorize(value="hasRole('Editor')")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void share(@ApiParam(value="Record UUID.", required=true) @PathVariable String metadataUuid, @ApiParam(value="Privileges", required=true) @RequestBody(required=true) SharingParameter sharing, @ApiIgnore @ApiParam(hidden=true) HttpSession session, HttpServletRequest request) throws Exception {
        try (ServiceContext context = ApiUtils.createServiceContext(request);){
            boolean isAdmin;
            AbstractMetadata metadata = ApiUtils.canEditRecord(metadataUuid, context);
            ConfigurableApplicationContext appContext = ApplicationContextHolder.get();
            ResourceBundle messages = ApiUtils.getMessagesResourceBundle(request.getLocales());
            boolean skipAllReservedGroup = false;
            UserSession us = ApiUtils.getUserSession(session);
            boolean bl = isAdmin = Profile.Administrator == us.getProfile();
            if (!isAdmin && !this.accessManager.hasReviewPermission(context, Integer.toString(metadata.getId()))) {
                skipAllReservedGroup = true;
            }
            List operationList = this.operationRepository.findAll();
            HashMap<String, Integer> operationMap = new HashMap<String, Integer>(operationList.size());
            for (Operation o : operationList) {
                operationMap.put(o.getName(), o.getId());
            }
            List<GroupOperations> privileges = sharing.getPrivileges();
            ArrayList<MetadataPublicationNotificationInfo> metadataListToNotifyPublication = new ArrayList<MetadataPublicationNotificationInfo>();
            boolean notifyByEmail = StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{this.sm.getValue("system/metadataprivs/publication/notificationLevel")});
            this.setOperations(sharing, this.dataManager, context, (ApplicationContext)appContext, metadata, operationMap, privileges, ApiUtils.getUserSession(session).getUserIdAsInt(), skipAllReservedGroup, null, request, metadataListToNotifyPublication, notifyByEmail);
            this.dataManager.indexMetadata(String.valueOf(metadata.getId()), true, null);
            if (notifyByEmail && !metadataListToNotifyPublication.isEmpty()) {
                this.metadataPublicationMailNotifier.notifyPublication(messages, context.getLanguage(), metadataListToNotifyPublication);
            }
        }
    }

    @ApiOperation(value="Publish one or more records", notes="See record sharing for more details.", nickname="publishRecords")
    @RequestMapping(value={"/publish"}, method={RequestMethod.PUT})
    @ApiResponses(value={@ApiResponse(code=201, message="Report about updated privileges."), @ApiResponse(code=403, message="Operation not allowed. Only Editors can access it.")})
    @PreAuthorize(value="hasRole('Editor')")
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public MetadataProcessingReport publish(@ApiParam(value="Record UUIDs. If null current selection is used.", required=false) @RequestParam(required=false) String[] uuids, @ApiParam(value="Selection bucket name", required=false) @RequestParam(required=false) String bucket, @ApiParam(value="Publication type") @RequestParam(required=false) String publicationType, @ApiIgnore @ApiParam(hidden=true) HttpSession session, HttpServletRequest request) throws Exception {
        SharingParameter sharing = this.buildSharingForPublicationConfig(true, StringUtils.isNotEmpty((CharSequence)publicationType) ? publicationType : DEFAULT_PUBLICATION_TYPE_NAME);
        return this.shareSelection(uuids, bucket, sharing, session, request);
    }

    @ApiOperation(value="Un-publish one or more records", notes="See record sharing for more details.", nickname="publishRecords")
    @RequestMapping(value={"/unpublish"}, method={RequestMethod.PUT})
    @ApiResponses(value={@ApiResponse(code=201, message="Report about updated privileges."), @ApiResponse(code=403, message="Operation not allowed. Only Editors can access it.")})
    @PreAuthorize(value="hasRole('Editor')")
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public MetadataProcessingReport unpublish(@ApiParam(value="Record UUIDs. If null current selection is used.", required=false) @RequestParam(required=false) String[] uuids, @ApiParam(value="Selection bucket name", required=false) @RequestParam(required=false) String bucket, @ApiParam(value="Publication type") @RequestParam(required=false) String publicationType, @ApiIgnore @ApiParam(hidden=true) HttpSession session, HttpServletRequest request) throws Exception {
        SharingParameter sharing = this.buildSharingForPublicationConfig(false, StringUtils.isNotEmpty((CharSequence)publicationType) ? publicationType : DEFAULT_PUBLICATION_TYPE_NAME);
        return this.shareSelection(uuids, bucket, sharing, session, request);
    }

    @ApiOperation(value="Set sharing settings for one or more records", notes="See record sharing for more details.", nickname="shareRecords")
    @RequestMapping(value={"/sharing"}, method={RequestMethod.PUT})
    @ApiResponses(value={@ApiResponse(code=201, message="Report about updated privileges."), @ApiResponse(code=403, message="Operation not allowed. Only Editors can access it.")})
    @PreAuthorize(value="hasRole('Editor')")
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public MetadataProcessingReport share(@ApiParam(value="Record UUIDs. If null current selection is used.", required=false) @RequestParam(required=false) String[] uuids, @ApiParam(value="Selection bucket name", required=false) @RequestParam(required=false) String bucket, @ApiParam(value="Privileges", required=true) @RequestBody(required=true) SharingParameter sharing, @ApiIgnore @ApiParam(hidden=true) HttpSession session, HttpServletRequest request) throws Exception {
        return this.shareSelection(uuids, bucket, sharing, session, request);
    }

    private void setOperations(SharingParameter sharing, DataManager dataMan, ServiceContext context, ApplicationContext appContext, AbstractMetadata metadata, Map<String, Integer> operationMap, List<GroupOperations> privileges, Integer userId, boolean skipAllReservedGroup, MetadataProcessingReport report, HttpServletRequest request, List<MetadataPublicationNotificationInfo> metadataListToNotifyPublication, boolean notifyByMail) throws Exception {
        if (privileges != null) {
            MetadataStatus mdStatus;
            Group groupOwner;
            boolean isGroupWithEnabledWorkflow;
            Locale locale = this.languageUtils.parseAcceptLanguage(request.getLocales());
            ResourceBundle messages = ResourceBundle.getBundle("org.fao.geonet.api.Messages", locale);
            boolean sharingChanges = false;
            boolean allowPublishInvalidMd = this.sm.getValueAsBool("metadata/workflow/allowPublishInvalidMd");
            boolean allowPublishNonApprovedMd = this.sm.getValueAsBool("metadata/workflow/allowPublishNonApprovedMd");
            boolean isMdWorkflowEnable = this.sm.getValueAsBool("metadata/workflow/enable");
            Integer groupOwnerId = metadata.getSourceInfo().getGroupOwner();
            if (isMdWorkflowEnable && groupOwnerId != null && (isGroupWithEnabledWorkflow = WorkflowUtil.isGroupWithEnabledWorkflow((String)(groupOwner = (Group)this.groupRepository.findOne((Serializable)groupOwnerId)).getName())) && (mdStatus = this.metadataStatus.getStatus(metadata.getId())) != null && mdStatus.getStatusValue().getId() == Integer.parseInt("3")) {
                List allGroupOps = privileges.stream().filter(p -> p.getGroup().intValue() == ReservedGroup.all.getId()).collect(Collectors.toList());
                Iterator iterator = allGroupOps.iterator();
                while (iterator.hasNext()) {
                    GroupOperations p2 = (GroupOperations)iterator.next();
                    if (!p2.getOperations().containsValue(true)) continue;
                    throw new IllegalStateException(String.format("Retired metadata %s can't be published.", metadata.getUuid()));
                }
            }
            SharingResponse sharingBefore = this.getRecordSharingSettings(metadata.getUuid(), request.getSession(), request);
            context.setAsThreadLocal();
            if (sharing.isClear()) {
                this.dataManager.deleteMetadataOper(context, String.valueOf(metadata.getId()), skipAllReservedGroup);
            }
            block3: for (GroupOperations p3 : privileges) {
                for (Map.Entry<String, Boolean> o : p3.getOperations().entrySet()) {
                    Integer opId = operationMap.get(o.getKey());
                    if (opId.intValue() == ReservedOperation.editing.getId() && ReservedGroup.isReserved((int)p3.getGroup())) continue;
                    if (o.getValue().booleanValue()) {
                        if (p3.getGroup().intValue() == ReservedGroup.all.getId()) {
                            try {
                                this.checkCanPublishToAllGroup(context, dataMan, messages, metadata, allowPublishInvalidMd, allowPublishNonApprovedMd);
                            }
                            catch (Exception ex) {
                                if (report != null) {
                                    report.addMetadataError(metadata, ex.getMessage());
                                    continue block3;
                                }
                                throw ex;
                            }
                        }
                        dataMan.setOperation(context, metadata.getId(), p3.getGroup().intValue(), opId.intValue());
                        sharingChanges = true;
                        continue;
                    }
                    if (sharing.isClear() || o.getValue().booleanValue()) continue;
                    dataMan.unsetOperation(context, metadata.getId(), p3.getGroup().intValue(), opId.intValue());
                    sharingChanges = true;
                }
            }
            if (notifyByMail) {
                boolean publishedAfter;
                Optional<GroupPrivilege> allGroupPrivsBefore = sharingBefore.getPrivileges().stream().filter(p -> p.getGroup().intValue() == ReservedGroup.all.getId()).findFirst();
                boolean publishedBefore = allGroupPrivsBefore.isPresent() && allGroupPrivsBefore.get().getOperations().get(ReservedOperation.view.name()) != false;
                Optional<GroupOperations> allGroupOpsAfter = privileges.stream().filter(p -> p.getGroup().intValue() == ReservedGroup.all.getId()).findFirst();
                boolean bl = publishedAfter = allGroupOpsAfter.isPresent() ? allGroupOpsAfter.get().getOperations().getOrDefault(ReservedOperation.view.name(), publishedBefore) : publishedBefore;
                if (publishedBefore != publishedAfter) {
                    MetadataPublicationNotificationInfo metadataNotificationInfo = new MetadataPublicationNotificationInfo();
                    metadataNotificationInfo.setMetadataUuid(metadata.getUuid());
                    metadataNotificationInfo.setMetadataId(metadata.getId());
                    metadataNotificationInfo.setGroupId(metadata.getSourceInfo().getGroupOwner());
                    metadataNotificationInfo.setPublished(publishedAfter);
                    metadataNotificationInfo.setPublicationDateStamp(new ISODate());
                    User publishUser = (User)this.userRepository.findOne((Serializable)userId);
                    if (publishUser != null) {
                        metadataNotificationInfo.setPublisherUser(publishUser.getUsername());
                    }
                    if (isMdWorkflowEnable) {
                        User submitterUser;
                        Optional<MetadataStatus> submittedStatus;
                        User reviewerUser;
                        Sort sortField = new Sort(Sort.Direction.DESC, new String[]{MetadataStatus_.changeDate.getName()});
                        List statusList = this.metadataStatusRepository.findAllByMetadataIdAndByType(metadata.getId(), StatusValueType.workflow, sortField);
                        Optional<MetadataStatus> approvedStatus = statusList.stream().filter(status -> status.getStatusValue().getId() == Integer.parseInt("2")).findFirst();
                        if (approvedStatus.isPresent() && (reviewerUser = (User)this.userRepository.findOne((Serializable)Integer.valueOf(approvedStatus.get().getUserId()))) != null) {
                            metadataNotificationInfo.setReviewerUser(reviewerUser.getUsername());
                        }
                        if ((submittedStatus = statusList.stream().filter(status -> status.getStatusValue().getId() == Integer.parseInt("4")).findFirst()).isPresent() && (submitterUser = (User)this.userRepository.findOne((Serializable)Integer.valueOf(submittedStatus.get().getUserId()))) != null) {
                            metadataNotificationInfo.setSubmitterUser(submitterUser.getUsername());
                        }
                    }
                    metadataListToNotifyPublication.add(metadataNotificationInfo);
                }
            }
            if (sharingChanges) {
                new RecordPrivilegesChangeEvent(Integer.valueOf(metadata.getId()), userId, ObjectJSONUtils.convertObjectInJsonObject(sharingBefore.getPrivileges(), (String)"sharing"), ObjectJSONUtils.convertObjectInJsonObject(privileges, (String)"sharing")).publish(appContext);
            }
        }
    }

    @ApiOperation(value="Get record sharing settings", notes="Return current sharing options for a record.", nickname="getRecordSharingSettings")
    @RequestMapping(value={"/{metadataUuid}/sharing"}, method={RequestMethod.GET}, produces={"application/json"})
    @ApiResponses(value={@ApiResponse(code=200, message="The record sharing settings."), @ApiResponse(code=403, message="Operation not allowed. User needs to be able to view the resource.")})
    @PreAuthorize(value="hasRole('Editor')")
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public SharingResponse getRecordSharingSettings(@ApiParam(value="Record UUID.", required=true) @PathVariable String metadataUuid, @ApiIgnore @ApiParam(hidden=true) HttpSession session, HttpServletRequest request) throws Exception {
        try (ServiceContext context = ApiUtils.createServiceContext(request);){
            AbstractMetadata metadata = ApiUtils.canViewRecord(metadataUuid, context);
            ConfigurableApplicationContext appContext = ApplicationContextHolder.get();
            UserSession userSession = ApiUtils.getUserSession(session);
            SharingResponse sharingResponse = new SharingResponse();
            sharingResponse.setOwner(userSession.getUserId());
            Integer groupOwner = metadata.getSourceInfo().getGroupOwner();
            if (groupOwner != null) {
                sharingResponse.setGroupOwner(String.valueOf(groupOwner));
            }
            Set userGroups = this.accessManager.getUserGroups(userSession, context.getIpAddress(), false);
            List elGroup = this.groupRepository.findAll();
            List allOperations = this.operationRepository.findAll();
            ArrayList<GroupPrivilege> groupPrivileges = new ArrayList<GroupPrivilege>(elGroup.size());
            if (elGroup != null) {
                for (Group g : elGroup) {
                    GroupPrivilege groupPrivilege = new GroupPrivilege();
                    groupPrivilege.setGroup(g.getId());
                    groupPrivilege.setReserved(g.isReserved());
                    groupPrivilege.setUserGroup(userGroups.contains(g.getId()));
                    Specification hasGroupId = UserGroupSpecs.hasGroupId((Integer)g.getId());
                    Specification hasUserId = UserGroupSpecs.hasUserId((int)userSession.getUserIdAsInt());
                    Specifications hasUserIdAndGroupId = Specifications.where((Specification)hasGroupId).and(hasUserId);
                    List userGroupEntities = this.userGroupRepository.findAll((Specification)hasUserIdAndGroupId);
                    ArrayList<Profile> userGroupProfile = new ArrayList<Profile>();
                    for (UserGroup ug : userGroupEntities) {
                        userGroupProfile.add(ug.getProfile());
                    }
                    groupPrivilege.setUserProfile(userGroupProfile);
                    Specifications hasGroupIdAndMetadataId = Specifications.where((Specification)OperationAllowedSpecs.hasGroupId((int)g.getId())).and(OperationAllowedSpecs.hasMetadataId((int)metadata.getId()));
                    List operationAllowedForGroup = this.operationAllowedRepository.findAll((Specification)hasGroupIdAndMetadataId);
                    HashMap<String, Boolean> operations = new HashMap<String, Boolean>(allOperations.size());
                    for (Operation o : allOperations) {
                        boolean operationSetForGroup = false;
                        for (OperationAllowed operationAllowed : operationAllowedForGroup) {
                            if (o.getId() != operationAllowed.getId().getOperationId()) continue;
                            operationSetForGroup = true;
                            break;
                        }
                        operations.put(o.getName(), operationSetForGroup);
                    }
                    groupPrivilege.setOperations(operations);
                    groupPrivileges.add(groupPrivilege);
                }
            }
            sharingResponse.setPrivileges(groupPrivileges);
            SharingResponse sharingResponse2 = sharingResponse;
            return sharingResponse2;
        }
    }

    @ApiOperation(value="Set record group", notes="A record is related to one group.", nickname="setRecordGroup")
    @RequestMapping(value={"/{metadataUuid}/group"}, method={RequestMethod.PUT})
    @ApiResponses(value={@ApiResponse(code=204, message="Record group updated."), @ApiResponse(code=403, message="Operation not allowed. User needs to be able to edit the resource.")})
    @PreAuthorize(value="hasRole('Editor')")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ResponseBody
    public void setRecordGroup(@ApiParam(value="Record UUID.", required=true) @PathVariable String metadataUuid, @ApiParam(value="Group identifier", required=true) @RequestBody(required=true) Integer groupIdentifier, HttpServletRequest request) throws Exception {
        try (ServiceContext context = ApiUtils.createServiceContext(request);){
            AbstractMetadata metadata = ApiUtils.canEditRecord(metadataUuid, context);
            ConfigurableApplicationContext appContext = ApplicationContextHolder.get();
            Group group = (Group)this.groupRepository.findOne((Serializable)groupIdentifier);
            if (group == null) {
                throw new ResourceNotFoundException(String.format("Group with identifier '%s' not found.", groupIdentifier));
            }
            Integer previousGroup = metadata.getSourceInfo().getGroupOwner();
            Group oldGroup = null;
            if (previousGroup != null) {
                oldGroup = (Group)this.groupRepository.findOne((Serializable)previousGroup);
            }
            metadata.getSourceInfo().setGroupOwner(groupIdentifier);
            this.metadataManager.save(metadata);
            this.dataManager.indexMetadata(String.valueOf(metadata.getId()), true, null);
            new RecordGroupOwnerChangeEvent(Integer.valueOf(metadata.getId()), Integer.valueOf(ApiUtils.getUserSession(request.getSession()).getUserIdAsInt()), ObjectJSONUtils.convertObjectInJsonObject((Object)oldGroup, (String)"owner"), ObjectJSONUtils.convertObjectInJsonObject((Object)group, (String)"owner")).publish((ApplicationContext)appContext);
        }
    }

    @ApiOperation(value="Get record sharing settings", notes="", nickname="getSharingSettings")
    @RequestMapping(value={"/sharing"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(code=200, message="Return a default array of group and operations that can be used to set record sharing properties."), @ApiResponse(code=403, message="Operation not allowed. User needs to be able to edit the resource.")})
    @PreAuthorize(value="hasRole('Editor')")
    @ResponseBody
    public SharingResponse getSharingSettings(@ApiIgnore @ApiParam(hidden=true) HttpSession session, HttpServletRequest request) throws Exception {
        try (ServiceContext context = ApiUtils.createServiceContext(request);){
            ConfigurableApplicationContext appContext = ApplicationContextHolder.get();
            UserSession userSession = ApiUtils.getUserSession(session);
            SharingResponse sharingResponse = new SharingResponse();
            sharingResponse.setOwner(userSession.getUserId());
            List allOperations = this.operationRepository.findAll();
            Set userGroups = this.accessManager.getUserGroups(context.getUserSession(), context.getIpAddress(), false);
            List elGroup = this.groupRepository.findAll();
            ArrayList<GroupPrivilege> groupPrivileges = new ArrayList<GroupPrivilege>(elGroup.size());
            for (Group g : elGroup) {
                GroupPrivilege groupPrivilege = new GroupPrivilege();
                groupPrivilege.setGroup(g.getId());
                groupPrivilege.setReserved(g.isReserved());
                groupPrivilege.setUserGroup(userGroups.contains(g.getId()));
                HashMap<String, Boolean> operations = new HashMap<String, Boolean>(allOperations.size());
                for (Operation o : allOperations) {
                    operations.put(o.getName(), false);
                }
                groupPrivilege.setOperations(operations);
                groupPrivileges.add(groupPrivilege);
            }
            sharingResponse.setPrivileges(groupPrivileges);
            SharingResponse sharingResponse2 = sharingResponse;
            return sharingResponse2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="Set group and owner for one or more records", notes="", nickname="setGroupAndOwner")
    @RequestMapping(value={"/ownership"}, method={RequestMethod.PUT})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiResponses(value={@ApiResponse(code=201, message="Records group and owner updated"), @ApiResponse(code=403, message="Operation not allowed. User needs to be able to edit the resource.")})
    @PreAuthorize(value="hasRole('Editor')")
    @ResponseBody
    public MetadataProcessingReport setGroupAndOwner(@ApiParam(value="Record UUIDs. If null current selection is used.", required=false) @RequestParam(required=false) String[] uuids, @ApiParam(value="Group identifier", required=true) @RequestParam(required=true) Integer groupIdentifier, @ApiParam(value="Selection bucket name", required=false) @RequestParam(required=false) String bucket, @ApiParam(value="User identifier", required=true) @RequestParam(required=true) Integer userIdentifier, @ApiParam(value="Use approved version or not", example="true") @RequestParam(required=false, defaultValue="false") Boolean approved, @ApiIgnore @ApiParam(hidden=true) HttpSession session, HttpServletRequest request) throws Exception {
        try (SimpleMetadataProcessingReport report = new SimpleMetadataProcessingReport();
             ServiceContext serviceContext = ApiUtils.createServiceContext(request);){
            Set<String> records = ApiUtils.getUuidsParameterOrSelection(uuids, bucket, ApiUtils.getUserSession(session));
            report.setTotalRecords(records.size());
            ConfigurableApplicationContext context = ApplicationContextHolder.get();
            ArrayList<String> listOfUpdatedRecords = new ArrayList<String>();
            for (String uuid : records) {
                this.updateOwnership(groupIdentifier, userIdentifier, report, this.dataManager, this.accessManager, serviceContext, listOfUpdatedRecords, uuid, session);
            }
            this.dataManager.flush();
            this.dataManager.indexMetadata(listOfUpdatedRecords);
        }
        return report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="Set record group and owner", notes="", nickname="setRecordOwnership")
    @RequestMapping(value={"/{metadataUuid}/ownership"}, method={RequestMethod.PUT})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiResponses(value={@ApiResponse(code=201, message="Record group and owner updated"), @ApiResponse(code=403, message="Operation not allowed. User needs to be able to edit the resource.")})
    @PreAuthorize(value="hasRole('Editor')")
    @ResponseBody
    public MetadataProcessingReport setRecordOwnership(@ApiParam(value="Record UUID.", required=true) @PathVariable String metadataUuid, @ApiParam(value="Group identifier", required=true) @RequestParam(required=true) Integer groupIdentifier, @ApiParam(value="User identifier", required=true) @RequestParam(required=true) Integer userIdentifier, @ApiParam(value="Use approved version or not", example="true") @RequestParam(required=false, defaultValue="true") Boolean approved, @ApiIgnore @ApiParam(hidden=true) HttpSession session, HttpServletRequest request) throws Exception {
        try (SimpleMetadataProcessingReport report = new SimpleMetadataProcessingReport();
             ServiceContext serviceContext = ApiUtils.createServiceContext(request);){
            AbstractMetadata metadata = ApiUtils.canEditRecord(metadataUuid, serviceContext);
            report.setTotalRecords(1);
            ConfigurableApplicationContext context = ApplicationContextHolder.get();
            ArrayList<String> listOfUpdatedRecords = new ArrayList<String>();
            this.updateOwnership(groupIdentifier, userIdentifier, report, this.dataManager, this.accessManager, serviceContext, listOfUpdatedRecords, metadataUuid, session);
            this.dataManager.flush();
            this.dataManager.indexMetadata(listOfUpdatedRecords);
        }
        return report;
    }

    private void updateOwnership(Integer groupIdentifier, Integer userIdentifier, MetadataProcessingReport report, DataManager dataManager, AccessManager accessMan, ServiceContext serviceContext, List<String> listOfUpdatedRecords, String uuid, HttpSession session) throws Exception {
        AbstractMetadata metadata = this.metadataUtils.findOneByUuid(uuid);
        if (metadata == null) {
            report.incrementNullRecords();
        } else if (!accessMan.canEdit(serviceContext, String.valueOf(metadata.getId()))) {
            report.addNotEditableMetadataId(metadata.getId());
        } else {
            List idList = this.metadataUtils.findAllIdsBy(MetadataSpecs.hasMetadataUuid((String)uuid));
            if (idList.size() > 1) {
                report.setTotalRecords(report.getNumberOfRecords() + 1);
            }
            for (Integer mdId : idList) {
                if (mdId.intValue() != metadata.getId()) {
                    metadata = this.metadataUtils.findOne(mdId.intValue());
                }
                Integer sourceUsr = metadata.getSourceInfo().getOwner();
                Integer sourceGrp = metadata.getSourceInfo().getGroupOwner();
                Vector<OperationAllowedId> sourcePriv = MetadataSharingApi.retrievePrivileges(serviceContext, String.valueOf(metadata.getId()), sourceUsr, sourceGrp);
                Integer groupIdentifierUsed = groupIdentifier;
                if (ReservedGroup.isReserved((int)groupIdentifier)) {
                    groupIdentifierUsed = sourceGrp;
                    report.addMetadataInfos(metadata, String.format("Reserved group '%s' on metadata '%s' is not allowed. Group owner will not be changed.", groupIdentifier, metadata.getUuid()));
                }
                if (sourcePriv.size() == 0) {
                    dataManager.copyDefaultPrivForGroup(serviceContext, String.valueOf(metadata.getId()), String.valueOf(groupIdentifierUsed), false);
                    report.addMetadataInfos(metadata, String.format("No privileges for user '%s' on metadata '%s', so setting default privileges", sourceUsr, metadata.getUuid()));
                } else {
                    for (OperationAllowedId priv : sourcePriv) {
                        if (sourceGrp != null) {
                            dataManager.unsetOperation(serviceContext, metadata.getId(), sourceGrp.intValue(), priv.getOperationId());
                        }
                        dataManager.setOperation(serviceContext, metadata.getId(), groupIdentifierUsed.intValue(), priv.getOperationId());
                    }
                }
                Long metadataId = metadata.getId();
                ConfigurableApplicationContext context = ApplicationContextHolder.get();
                if (!Objects.equals(groupIdentifierUsed, sourceGrp)) {
                    Group newGroup = (Group)this.groupRepository.findOne((Serializable)groupIdentifierUsed);
                    Group oldGroup = sourceGrp == null ? null : (Group)this.groupRepository.findOne((Serializable)sourceGrp);
                    new RecordGroupOwnerChangeEvent(metadataId, Integer.valueOf(ApiUtils.getUserSession(session).getUserIdAsInt()), sourceGrp == null ? null : ObjectJSONUtils.convertObjectInJsonObject((Object)oldGroup, (String)"owner"), ObjectJSONUtils.convertObjectInJsonObject((Object)newGroup, (String)"owner")).publish((ApplicationContext)context);
                }
                if (!Objects.equals(userIdentifier, sourceUsr)) {
                    User newOwner = (User)this.userRepository.findOne((Serializable)userIdentifier);
                    User oldOwner = (User)this.userRepository.findOne((Serializable)sourceUsr);
                    new RecordOwnerChangeEvent(metadataId, Integer.valueOf(ApiUtils.getUserSession(session).getUserIdAsInt()), ObjectJSONUtils.convertObjectInJsonObject((Object)oldOwner, (String)"owner"), ObjectJSONUtils.convertObjectInJsonObject((Object)newOwner, (String)"owner")).publish((ApplicationContext)context);
                }
                dataManager.updateMetadataOwner(metadata.getId(), String.valueOf(userIdentifier), String.valueOf(groupIdentifierUsed));
                report.addMetadataId(metadata.getId());
                report.incrementProcessedRecords();
                listOfUpdatedRecords.add(metadata.getId() + "");
            }
        }
    }

    public static Vector<OperationAllowedId> retrievePrivileges(ServiceContext context, String id, Integer userId, Integer groupId) throws Exception {
        OperationAllowedRepository opAllowRepo = (OperationAllowedRepository)context.getBean(OperationAllowedRepository.class);
        int iMetadataId = Integer.parseInt(id);
        Specifications spec = Specifications.where((Specification)OperationAllowedSpecs.hasMetadataId((int)iMetadataId));
        if (groupId != null) {
            spec = spec.and(OperationAllowedSpecs.hasGroupId((int)groupId));
        }
        List operationsAllowed = opAllowRepo.findAllWithOwner(userId.intValue(), com.google.common.base.Optional.of((Object)spec));
        Vector<OperationAllowedId> result = new Vector<OperationAllowedId>();
        for (OperationAllowed operationAllowed : operationsAllowed) {
            result.add(operationAllowed.getId());
        }
        return result;
    }

    private void checkCanPublishToAllGroup(ServiceContext context, DataManager dm, ResourceBundle messages, AbstractMetadata metadata, boolean allowPublishInvalidMd, boolean allowPublishNonApprovedMd) throws Exception {
        String statusId;
        boolean isApproved;
        MetadataStatus mdStatus;
        if (!allowPublishInvalidMd) {
            boolean isInvalid;
            boolean hasValidation;
            boolean bl = hasValidation = this.metadataValidationRepository.count(MetadataValidationSpecs.hasMetadataId((int)metadata.getId())) > 0L;
            if (!hasValidation) {
                this.validator.doValidate(metadata, context.getLanguage());
                dm.indexMetadata(metadata.getId() + "", true, null);
            }
            boolean bl2 = isInvalid = this.metadataValidationRepository.count(MetadataValidationSpecs.isInvalidAndRequiredForMetadata((int)metadata.getId())) > 0L;
            if (isInvalid) {
                throw new Exception(String.format(messages.getString("api.metadata.share.errorMetadataNotValid"), metadata.getUuid()));
            }
        }
        if (!allowPublishNonApprovedMd && (mdStatus = this.metadataStatus.getStatus(metadata.getId())) != null && !(isApproved = (statusId = mdStatus.getStatusValue().getId() + "").equals("2"))) {
            throw new Exception(String.format(messages.getString("api.metadata.share.errorMetadataNotApproved"), metadata.getUuid()));
        }
    }

    private void shareMetadataWithReservedGroup(String metadataUuid, boolean publish, String publicationType, HttpSession session, HttpServletRequest request) throws Exception {
        try (ServiceContext context = ApiUtils.createServiceContext(request);){
            boolean isPublishForbiden;
            AbstractMetadata metadata = ApiUtils.canEditRecord(metadataUuid, context);
            ConfigurableApplicationContext appContext = ApplicationContextHolder.get();
            ResourceBundle messages = ApiUtils.getMessagesResourceBundle(request.getLocales());
            UserSession us = ApiUtils.getUserSession(session);
            boolean isAdmin = Profile.Administrator == us.getProfile();
            boolean isMdGroupReviewer = this.accessManager.getReviewerGroups(us).contains(metadata.getSourceInfo().getGroupOwner());
            boolean isReviewOperationAllowedOnMdForUser = this.accessManager.hasReviewPermission(context, Integer.toString(metadata.getId()));
            boolean bl = isPublishForbiden = !isMdGroupReviewer && !isAdmin && !isReviewOperationAllowedOnMdForUser;
            if (isPublishForbiden) {
                throw new Exception(String.format(messages.getString("api.metadata.share.ErrorUserNotAllowedToPublish"), metadataUuid));
            }
            OperationRepository operationRepository = (OperationRepository)appContext.getBean(OperationRepository.class);
            List operationList = operationRepository.findAll();
            HashMap<String, Integer> operationMap = new HashMap<String, Integer>(operationList.size());
            for (Operation o : operationList) {
                operationMap.put(o.getName(), o.getId());
            }
            SharingParameter sharing = this.buildSharingForPublicationConfig(publish, publicationType);
            List<GroupOperations> privileges = sharing.getPrivileges();
            ArrayList<MetadataPublicationNotificationInfo> metadataListToNotifyPublication = new ArrayList<MetadataPublicationNotificationInfo>();
            boolean notifyByEmail = StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{this.sm.getValue("system/metadataprivs/publication/notificationLevel")});
            this.setOperations(sharing, this.dataManager, context, (ApplicationContext)appContext, metadata, operationMap, privileges, ApiUtils.getUserSession(session).getUserIdAsInt(), true, null, request, metadataListToNotifyPublication, notifyByEmail);
            this.metadataIndexer.indexMetadata(String.valueOf(metadata.getId()), true, null);
            Optional<PublicationOption> publicationOption = this.publicationConfig.getPublicationOptionConfiguration(publicationType);
            if (publicationOption.isPresent() && publicationOption.get().hasPublicationTo(ReservedGroup.all) && notifyByEmail && !metadataListToNotifyPublication.isEmpty()) {
                this.metadataPublicationMailNotifier.notifyPublication(messages, context.getLanguage(), metadataListToNotifyPublication);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MetadataProcessingReport shareSelection(String[] uuids, String bucket, SharingParameter sharing, HttpSession session, HttpServletRequest request) throws Exception {
        try (SimpleMetadataProcessingReport report = new SimpleMetadataProcessingReport();
             ServiceContext context = ApiUtils.createServiceContext(request);){
            Set<String> records = ApiUtils.getUuidsParameterOrSelection(uuids, bucket, ApiUtils.getUserSession(session));
            report.setTotalRecords(records.size());
            ConfigurableApplicationContext appContext = ApplicationContextHolder.get();
            DataManager dataMan = (DataManager)appContext.getBean(DataManager.class);
            AccessManager accessMan = (AccessManager)appContext.getBean(AccessManager.class);
            IMetadataUtils metadataRepository = (IMetadataUtils)appContext.getBean(IMetadataUtils.class);
            ResourceBundle messages = ApiUtils.getMessagesResourceBundle(request.getLocales());
            UserSession us = ApiUtils.getUserSession(session);
            boolean isAdmin = Profile.Administrator == us.getProfile();
            ArrayList<String> listOfUpdatedRecords = new ArrayList<String>();
            ArrayList<MetadataPublicationNotificationInfo> metadataListToNotifyPublication = new ArrayList<MetadataPublicationNotificationInfo>();
            boolean notifyByEmail = StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{this.sm.getValue("system/metadataprivs/publication/notificationLevel")});
            for (String uuid : records) {
                AbstractMetadata metadata = metadataRepository.findOneByUuid(uuid);
                if (metadata == null) {
                    report.incrementNullRecords();
                    continue;
                }
                if (!accessMan.canEdit(context, String.valueOf(metadata.getId()))) {
                    report.addNotEditableMetadataId(metadata.getId());
                    continue;
                }
                boolean skipAllReservedGroup = false;
                if (!isAdmin && accessMan.hasReviewPermission(context, Integer.toString(metadata.getId()))) {
                    skipAllReservedGroup = true;
                }
                OperationRepository operationRepository = (OperationRepository)appContext.getBean(OperationRepository.class);
                List operationList = operationRepository.findAll();
                HashMap<String, Integer> operationMap = new HashMap<String, Integer>(operationList.size());
                for (Operation o : operationList) {
                    operationMap.put(o.getName(), o.getId());
                }
                List<GroupOperations> privileges = sharing.getPrivileges();
                if (metadata instanceof MetadataDraft) {
                    Metadata md = this.metadataRepository.findOneByUuid(metadata.getUuid());
                    if (md != null) {
                        this.setOperations(sharing, dataMan, context, (ApplicationContext)appContext, (AbstractMetadata)md, operationMap, privileges, ApiUtils.getUserSession(session).getUserIdAsInt(), skipAllReservedGroup, report, request, metadataListToNotifyPublication, notifyByEmail);
                        report.incrementProcessedRecords();
                        listOfUpdatedRecords.add(String.valueOf(md.getId()));
                        continue;
                    }
                    this.setOperations(sharing, dataMan, context, (ApplicationContext)appContext, metadata, operationMap, privileges, ApiUtils.getUserSession(session).getUserIdAsInt(), skipAllReservedGroup, report, request, metadataListToNotifyPublication, notifyByEmail);
                    report.incrementProcessedRecords();
                    listOfUpdatedRecords.add(String.valueOf(metadata.getId()));
                    continue;
                }
                this.setOperations(sharing, dataMan, context, (ApplicationContext)appContext, metadata, operationMap, privileges, ApiUtils.getUserSession(session).getUserIdAsInt(), skipAllReservedGroup, report, request, metadataListToNotifyPublication, notifyByEmail);
                report.incrementProcessedRecords();
                listOfUpdatedRecords.add(String.valueOf(metadata.getId()));
            }
            if (!metadataListToNotifyPublication.isEmpty()) {
                this.metadataPublicationMailNotifier.notifyPublication(messages, context.getLanguage(), metadataListToNotifyPublication);
            }
            dataMan.flush();
            dataMan.indexMetadata(listOfUpdatedRecords);
        }
        return report;
    }

    private SharingParameter buildSharingForPublicationConfig(boolean publish, String configName) {
        SharingParameter sharing = new SharingParameter();
        sharing.setClear(false);
        ArrayList<GroupOperations> privilegesList = new ArrayList<GroupOperations>();
        Optional<PublicationOption> publicationOptionOptional = this.publicationConfig.getPublicationOptionConfiguration(configName);
        if (publicationOptionOptional.isPresent()) {
            PublicationOption publicationOption = publicationOptionOptional.get();
            Iterator<ReservedOperation> it = publicationOption.getPublicationOperations().iterator();
            GroupOperations privReservedGroup = new GroupOperations();
            privReservedGroup.setGroup(publicationOption.getPublicationGroup().getId());
            HashMap<String, Boolean> operations = new HashMap<String, Boolean>();
            while (it.hasNext()) {
                ReservedOperation operation = it.next();
                operations.put(operation.toString(), publish);
            }
            privReservedGroup.setOperations(operations);
            privilegesList.add(privReservedGroup);
            for (Map.Entry<ReservedGroup, List<ReservedOperation>> info : publicationOption.getAdditionalPublications().entrySet()) {
                privReservedGroup = new GroupOperations();
                privReservedGroup.setGroup(info.getKey().getId());
                operations = new HashMap();
                for (ReservedOperation operation : info.getValue()) {
                    operations.put(operation.toString(), publish);
                }
                privReservedGroup.setOperations(operations);
                privilegesList.add(privReservedGroup);
            }
        }
        sharing.setPrivileges(privilegesList);
        return sharing;
    }
}

