/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.processing;

import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.api.processing.report.XsltMetadataProcessingReport;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.kernel.AccessManager;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.datamanager.IMetadataManager;
import org.fao.geonet.kernel.datamanager.IMetadataSchemaUtils;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.repository.MetadataValidationRepository;
import org.fao.geonet.repository.Updater;
import org.fao.geonet.repository.specification.MetadataValidationSpecs;
import org.fao.geonet.utils.FilePathChecker;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Content;
import org.jdom.Element;

public class XslProcessUtils {
    private static final String SCHEMA_UPGRADE_PROCESS_SUFFIX = "-schemaupgrade";

    public static Element process(ServiceContext context, String id, String process, boolean save, boolean index, boolean updateDateStamp, XsltMetadataProcessingReport report, String siteUrl, Map<String, String[]> params) throws Exception {
        SchemaManager schemaMan = (SchemaManager)context.getBean(SchemaManager.class);
        AccessManager accessMan = (AccessManager)context.getBean(AccessManager.class);
        DataManager dataMan = (DataManager)context.getBean(DataManager.class);
        SettingManager settingsMan = (SettingManager)context.getBean(SettingManager.class);
        IMetadataUtils metadataRepository = (IMetadataUtils)context.getBean(IMetadataUtils.class);
        IMetadataManager metadataManager = (IMetadataManager)context.getBean(IMetadataManager.class);
        IMetadataSchemaUtils metadataSchemaUtils = (IMetadataSchemaUtils)context.getBean(IMetadataSchemaUtils.class);
        MetadataValidationRepository metadataValidationRepository = (MetadataValidationRepository)context.getBean(MetadataValidationRepository.class);
        report.incrementProcessedRecords();
        if (id == null) {
            report.incrementNullRecords();
            return null;
        }
        int iId = Integer.valueOf(id);
        AbstractMetadata info = metadataRepository.findOne(id);
        if (info == null) {
            report.addNotFoundMetadataId(iId);
        } else if (!accessMan.canEdit(context, id)) {
            report.addNotEditableMetadataId(iId);
        } else {
            String schema = info.getDataInfo().getSchemaId();
            FilePathChecker.verify((String)process);
            Path xslProcessing = schemaMan.getSchemaDir(schema).resolve("process").resolve(process + ".xsl");
            if (!Files.exists(xslProcessing, new LinkOption[0])) {
                Log.info((String)"org.fao.geonet.services.metadata", (Object)("  Processing instruction not found for " + schema + " schema. Looking for " + xslProcessing));
                report.addNoProcessFoundMetadataId(iId);
                return null;
            }
            boolean schemaUpgradeProcess = process.endsWith(SCHEMA_UPGRADE_PROCESS_SUFFIX);
            Element processedMetadata = null;
            try {
                boolean forEditing = false;
                boolean withValidationErrors = false;
                boolean keepXlinkAttributes = true;
                Element md = metadataManager.getMetadata(context, id, forEditing, false, withValidationErrors, keepXlinkAttributes);
                Map<String, Object> xslParameter = XslProcessUtils.getDefaultXslParameters(context, settingsMan);
                for (Map.Entry<String, String[]> parameter : params.entrySet()) {
                    String value = parameter.getValue()[0].trim();
                    String key = parameter.getKey();
                    if (key.equals("extra_metadata_uuid") && !value.equals("")) {
                        String extraMetadataId = dataMan.getMetadataId(value);
                        if (extraMetadataId == null) continue;
                        Element extraMetadata = dataMan.getMetadata(context, extraMetadataId, forEditing, withValidationErrors, keepXlinkAttributes);
                        md.addContent((Content)new Element("extra").addContent((Content)extraMetadata));
                        xslParameter.put(key, value);
                        continue;
                    }
                    xslParameter.put(key, value);
                }
                xslParameter.put("siteUrl", siteUrl);
                processedMetadata = Xml.transform((Element)md, (Path)xslProcessing, xslParameter);
                if (save) {
                    String newSchema;
                    Lib.resource.checkEditPrivilege(context, id);
                    boolean validate = false;
                    boolean ufo = true;
                    String language = context.getLanguage();
                    if (schemaUpgradeProcess && !(newSchema = metadataSchemaUtils.autodetectSchema(processedMetadata)).equalsIgnoreCase(info.getDataInfo().getSchemaId())) {
                        metadataManager.update(info.getId(), (Updater)new Updater<AbstractMetadata>(){

                            public void apply(@Nonnull AbstractMetadata entity) {
                                entity.getDataInfo().setSchemaId(newSchema);
                            }
                        });
                        metadataValidationRepository.deleteAll(MetadataValidationSpecs.hasMetadataId((int)info.getId()));
                    }
                    dataMan.updateMetadata(context, id, processedMetadata, validate, ufo, index, language, new ISODate().toString(), updateDateStamp);
                    if (index) {
                        dataMan.indexMetadata(id, true, null);
                    }
                }
                report.addMetadataId(iId);
            }
            catch (Exception e) {
                report.addMetadataError(info, e);
                context.error("  Processing failed with error " + e.getMessage());
                context.error((Throwable)e);
            }
            return processedMetadata;
        }
        return null;
    }

    private static Map<String, Object> getDefaultXslParameters(ServiceContext context, SettingManager settingsMan) {
        HashMap<String, Object> xslParameter = new HashMap<String, Object>();
        xslParameter.put("guiLang", context.getLanguage());
        xslParameter.put("baseUrl", context.getBaseUrl());
        xslParameter.put("nodeUrl", settingsMan.getNodeURL());
        xslParameter.put("catalogUrl", settingsMan.getSiteURL(context));
        xslParameter.put("nodeId", context.getNodeId());
        xslParameter.put("thesauriDir", ((GeonetworkDataDirectory)context.getApplicationContext().getBean(GeonetworkDataDirectory.class)).getThesauriDir().toAbsolutePath().toString());
        return xslParameter;
    }

    public static String processAsText(ServiceContext context, String id, String process, boolean save, XsltMetadataProcessingReport report, String siteUrl, Map<String, String[]> params) throws Exception {
        SchemaManager schemaMan = (SchemaManager)context.getBean(SchemaManager.class);
        AccessManager accessMan = (AccessManager)context.getBean(AccessManager.class);
        DataManager dataMan = (DataManager)context.getBean(DataManager.class);
        SettingManager settingsMan = (SettingManager)context.getBean(SettingManager.class);
        IMetadataUtils metadataRepository = (IMetadataUtils)context.getBean(IMetadataUtils.class);
        report.incrementProcessedRecords();
        if (id == null) {
            report.incrementNullRecords();
            return null;
        }
        int iId = Integer.valueOf(id);
        AbstractMetadata info = metadataRepository.findOne(id);
        if (info == null) {
            report.addNotFoundMetadataId(iId);
        } else if (!accessMan.canEdit(context, id)) {
            report.addNotEditableMetadataId(iId);
        } else {
            String schema = info.getDataInfo().getSchemaId();
            Path xslProcessing = schemaMan.getSchemaDir(schema).resolve("process").resolve(process + ".xsl");
            if (!Files.exists(xslProcessing, new LinkOption[0])) {
                Log.info((String)"org.fao.geonet.services.metadata", (Object)("  Processing instruction not found for " + schema + " schema. Looking for " + xslProcessing));
                report.addNoProcessFoundMetadataId(iId);
                return null;
            }
            StringWriter sw = new StringWriter();
            try {
                boolean forEditing = false;
                boolean withValidationErrors = false;
                boolean keepXlinkAttributes = true;
                Element md = dataMan.getMetadata(context, id, forEditing, withValidationErrors, keepXlinkAttributes);
                Map<String, Object> xslParameter = XslProcessUtils.getDefaultXslParameters(context, settingsMan);
                for (Map.Entry<String, String[]> parameter : params.entrySet()) {
                    String value = parameter.getValue()[0].trim();
                    String key = parameter.getKey();
                    if (key.equals("extra_metadata_uuid") && !value.equals("")) {
                        String extraMetadataId = dataMan.getMetadataId(value);
                        if (extraMetadataId == null) continue;
                        Element extraMetadata = dataMan.getMetadata(context, extraMetadataId, forEditing, withValidationErrors, keepXlinkAttributes);
                        md.addContent((Content)new Element("extra").addContent((Content)extraMetadata));
                        xslParameter.put(key, value);
                        continue;
                    }
                    xslParameter.put(key, value);
                }
                xslParameter.put("siteUrl", siteUrl);
                Xml.transform((Element)md, (Path)xslProcessing, (Result)new StreamResult(sw), xslParameter);
                report.addMetadataId(iId);
            }
            catch (Exception e) {
                report.addMetadataError(info, e);
                context.error("  Processing failed with error " + e.getMessage());
                context.error((Throwable)e);
            }
            return sw.toString();
        }
        return null;
    }
}

