/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.expressions;

import com.github.sommeri.less4j.core.ast.CssString;
import com.github.sommeri.less4j.core.ast.EscapedValue;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.FaultyExpression;
import com.github.sommeri.less4j.core.ast.FunctionExpression;
import com.github.sommeri.less4j.core.ast.IdentifierExpression;
import com.github.sommeri.less4j.core.compiler.expressions.AbstractMultiParameterFunction;
import com.github.sommeri.less4j.core.compiler.expressions.TypesConversionUtils;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;
import com.github.sommeri.less4j.js.JsRegExp;
import java.util.List;

class Replace
extends AbstractMultiParameterFunction {
    private TypesConversionUtils conversions = new TypesConversionUtils();

    Replace() {
    }

    @Override
    public Expression evaluate(List<Expression> parameters, ProblemsHandler problemsHandler, FunctionExpression call, Expression evaluatedParameter) {
        Expression targetExpression = parameters.get(0);
        String string = this.conversions.contentToString(targetExpression);
        String pattern = this.conversions.contentToString(parameters.get(1));
        String replacement = this.conversions.contentToString(parameters.get(2));
        String flags = parameters.size() > 3 ? this.conversions.contentToString(parameters.get(3)) : "";
        Expression replaced = this.regexp(targetExpression, string, pattern, replacement, flags, problemsHandler, call);
        return replaced;
    }

    private Expression regexp(Expression targetExpression, String string, String pattern, String replacement, String flags, ProblemsHandler problemsHandler, FunctionExpression call) {
        try {
            JsRegExp exp = JsRegExp.compile(pattern, flags);
            String replaced = exp.replace(string, replacement);
            return this.buildResult(targetExpression, replaced);
        }
        catch (IllegalArgumentException ex) {
            problemsHandler.regexpFunctionError(call, ex.getMessage());
            return new FaultyExpression(call.getUnderlyingStructure());
        }
    }

    private Expression buildResult(Expression targetExpression, String replaced) {
        HiddenTokenAwareTree token = targetExpression.getUnderlyingStructure();
        switch (targetExpression.getType()) {
            case IDENTIFIER_EXPRESSION: {
                return new IdentifierExpression(token, replaced);
            }
            case STRING_EXPRESSION: {
                CssString string = (CssString)targetExpression;
                return new CssString(token, replaced, string.getQuoteType());
            }
            case ESCAPED_VALUE: {
                return new EscapedValue(token, replaced);
            }
        }
        return new CssString(token, replaced, "'");
    }

    @Override
    protected int getMinParameters() {
        return 3;
    }

    @Override
    protected int getMaxParameters() {
        return 4;
    }

    @Override
    protected String getName() {
        return "replace";
    }

    @Override
    protected boolean validateParameter(Expression parameter, int position, ProblemsHandler problemsHandler) {
        return this.conversions.canConvertToString(parameter);
    }
}

