/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.support.naming;

import java.io.InputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import ro.isdc.wro.model.resource.support.naming.NamingStrategy;

public class TimestampNamingStrategy
implements NamingStrategy {
    public static final String ALIAS = "timestamp";

    public String rename(String originalName, InputStream inputStream) {
        String baseName = FilenameUtils.getBaseName((String)originalName);
        String extension = FilenameUtils.getExtension((String)originalName);
        long timestamp = this.getTimestamp();
        StringBuilder sb = new StringBuilder(baseName).append("-").append(timestamp);
        if (!StringUtils.isEmpty((CharSequence)extension)) {
            sb.append(".").append(extension);
        }
        return sb.toString();
    }

    protected long getTimestamp() {
        return System.currentTimeMillis();
    }
}

