/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.sqs.features;

import com.google.common.collect.FluentIterable;
import java.net.URI;
import java.util.Map;
import javax.inject.Named;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import org.jclouds.Fallbacks;
import org.jclouds.aws.filters.FormSigner;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.EndpointParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.FormParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.Transform;
import org.jclouds.rest.annotations.VirtualHost;
import org.jclouds.rest.annotations.XMLResponseParser;
import org.jclouds.sqs.binders.BindAttributeNamesToIndexedFormParams;
import org.jclouds.sqs.domain.QueueAttributes;
import org.jclouds.sqs.functions.MapToQueueAttributes;
import org.jclouds.sqs.options.CreateQueueOptions;
import org.jclouds.sqs.options.ListQueuesOptions;
import org.jclouds.sqs.xml.AttributesHandler;
import org.jclouds.sqs.xml.RegexListQueuesResponseHandler;
import org.jclouds.sqs.xml.RegexQueueHandler;
import org.jclouds.sqs.xml.ValueHandler;

@RequestFilters(value={FormSigner.class})
@FormParams(keys={"Version"}, values={"{jclouds.api-version}"})
@VirtualHost
public interface QueueApi {
    @Named(value="ListQueues")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"ListQueues"})
    @ResponseParser(value=RegexListQueuesResponseHandler.class)
    public FluentIterable<URI> list();

    @Named(value="ListQueues")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"ListQueues"})
    @ResponseParser(value=RegexListQueuesResponseHandler.class)
    public FluentIterable<URI> list(ListQueuesOptions var1);

    @Named(value="GetQueueUrl")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"GetQueueUrl"})
    @ResponseParser(value=RegexQueueHandler.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public URI get(@FormParam(value="QueueName") String var1);

    @Named(value="GetQueueUrl")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"GetQueueUrl"})
    @ResponseParser(value=RegexQueueHandler.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public URI getInAccount(@FormParam(value="QueueName") String var1, @FormParam(value="QueueOwnerAWSAccountId") String var2);

    @Named(value="CreateQueue")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"CreateQueue"})
    @ResponseParser(value=RegexQueueHandler.class)
    public URI create(@FormParam(value="QueueName") String var1);

    @Named(value="CreateQueue")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"CreateQueue"})
    @ResponseParser(value=RegexQueueHandler.class)
    public URI create(@FormParam(value="QueueName") String var1, CreateQueueOptions var2);

    @Named(value="DeleteQueue")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"DeleteQueue"})
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    public void delete(@EndpointParam URI var1);

    @Named(value="GetQueueAttributes")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action", "AttributeName.1"}, values={"GetQueueAttributes", "All"})
    @Transform(value=MapToQueueAttributes.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @XMLResponseParser(value=AttributesHandler.class)
    public QueueAttributes getAttributes(@EndpointParam URI var1);

    @Named(value="GetQueueAttributes")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"GetQueueAttributes"})
    @XMLResponseParser(value=AttributesHandler.class)
    public Map<String, String> getAttributes(@EndpointParam URI var1, @BinderParam(value=BindAttributeNamesToIndexedFormParams.class) Iterable<String> var2);

    @Named(value="GetQueueAttributes")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"GetQueueAttributes"})
    @XMLResponseParser(value=ValueHandler.class)
    public String getAttribute(@EndpointParam URI var1, @FormParam(value="AttributeName.1") String var2);

    @Named(value="SetQueueAttributes")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"SetQueueAttributes"})
    public void setAttribute(@EndpointParam URI var1, @FormParam(value="Attribute.Name") String var2, @FormParam(value="Attribute.Value") String var3);
}

