/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

class NamePatternEscaping {
    private final String escape;
    private final Pattern replacementPattern;
    private final String replacement;

    public NamePatternEscaping(String escape) {
        this.escape = escape == null ? "" : escape;
        String quotedEscape = Pattern.quote(this.escape);
        this.replacementPattern = Pattern.compile("(" + quotedEscape + "|[_%])");
        this.replacement = Matcher.quoteReplacement(this.escape) + "$1";
    }

    public String escape(String name) {
        if (this.needsEscaping(name)) {
            return this.replacementPattern.matcher(name).replaceAll(this.replacement);
        }
        return name;
    }

    private boolean needsEscaping(String name) {
        if (name == null) {
            return false;
        }
        if (this.escape.isEmpty()) {
            return false;
        }
        return name.indexOf(95) != -1 || name.indexOf(37) != -1 || name.contains(this.escape);
    }
}

