/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.converter;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.persistence.AttributeConverter;
import javax.persistence.PersistenceException;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.sql.BasicBinder;
import org.hibernate.type.descriptor.sql.BasicExtractor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;

public class AttributeConverterSqlTypeDescriptorAdapter
implements SqlTypeDescriptor {
    private final AttributeConverter converter;
    private final SqlTypeDescriptor delegate;
    private final JavaTypeDescriptor intermediateJavaTypeDescriptor;

    public AttributeConverterSqlTypeDescriptorAdapter(AttributeConverter converter, SqlTypeDescriptor delegate, JavaTypeDescriptor intermediateJavaTypeDescriptor) {
        this.converter = converter;
        this.delegate = delegate;
        this.intermediateJavaTypeDescriptor = intermediateJavaTypeDescriptor;
    }

    @Override
    public int getSqlType() {
        return this.delegate.getSqlType();
    }

    @Override
    public boolean canBeRemapped() {
        return this.delegate.canBeRemapped();
    }

    @Override
    public <X> ValueBinder<X> getBinder(JavaTypeDescriptor<X> javaTypeDescriptor) {
        final ValueBinder realBinder = this.delegate.getBinder(this.intermediateJavaTypeDescriptor);
        return new BasicBinder<X>(javaTypeDescriptor, this){

            @Override
            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                Object convertedValue;
                try {
                    convertedValue = AttributeConverterSqlTypeDescriptorAdapter.this.converter.convertToDatabaseColumn(value);
                }
                catch (PersistenceException pe) {
                    throw pe;
                }
                catch (RuntimeException re) {
                    throw new PersistenceException("Error attempting to apply AttributeConverter", (Throwable)re);
                }
                realBinder.bind(st, convertedValue, index, options);
            }
        };
    }

    @Override
    public <X> ValueExtractor<X> getExtractor(JavaTypeDescriptor<X> javaTypeDescriptor) {
        final ValueExtractor realExtractor = this.delegate.getExtractor(this.intermediateJavaTypeDescriptor);
        return new BasicExtractor<X>(javaTypeDescriptor, this){

            @Override
            protected X doExtract(ResultSet rs, String name, WrapperOptions options) throws SQLException {
                return this.doConversion(realExtractor.extract(rs, name, options));
            }

            @Override
            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return this.doConversion(realExtractor.extract(statement, index, options));
            }

            @Override
            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return this.doConversion(realExtractor.extract(statement, new String[]{name}, options));
            }

            private X doConversion(Object extractedValue) {
                try {
                    return AttributeConverterSqlTypeDescriptorAdapter.this.converter.convertToEntityAttribute(extractedValue);
                }
                catch (PersistenceException pe) {
                    throw pe;
                }
                catch (RuntimeException re) {
                    throw new PersistenceException("Error attempting to apply AttributeConverter", (Throwable)re);
                }
            }
        };
    }
}

