/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.schema;

import java.nio.file.Path;
import java.util.List;
import jeeves.interfaces.Service;
import jeeves.server.ServiceConfig;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.Util;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.search.MetaSearcher;
import org.fao.geonet.kernel.search.SearchManager;
import org.fao.geonet.kernel.search.SearcherType;
import org.fao.geonet.utils.Log;
import org.jdom.Content;
import org.jdom.Element;

@Deprecated
public class Delete
implements Service {
    public void init(Path appPath, ServiceConfig params) throws Exception {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Element exec(Element params, ServiceContext context) throws Exception {
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        SchemaManager scm = (SchemaManager)gc.getBean(SchemaManager.class);
        String schema = Util.getParam((Element)params, (String)"schema");
        Element response = new Element("response");
        if (!scm.existsSchema(schema)) {
            response.setAttribute("status", "error");
            response.setAttribute("message", "Schema does not exist");
            return response;
        }
        ServiceConfig config = new ServiceConfig();
        SearchManager searchMan = (SearchManager)gc.getBean(SearchManager.class);
        Element searchParams = new Element("parameters");
        searchParams.addContent((Content)new Element("_schema").setText(schema));
        try (MetaSearcher searcher = searchMan.newSearcher(SearcherType.LUCENE, "lucene.xsl");){
            searcher.search(context, searchParams, config);
            int results = searcher.getSize();
            if (results == 0) {
                searchParams.addContent((Content)new Element("_isTemplate").setText("y"));
                searcher.search(context, searchParams, config);
                results = searcher.getSize();
            }
            if (results > 0) {
                String errStr2 = "Cannot remove schema " + schema + " because there are records that belong to this schema in the catalog";
                context.error(errStr2);
                response.setAttribute("status", "error");
                response.setAttribute("message", errStr2);
                Element element = response;
                return element;
            }
        }
        catch (Exception e) {
            String errStr = "Cannot remove schema " + schema + " because the search for records that belong to this schema FAILED (" + e.getMessage() + ")";
            Log.error((String)"geonetwork.schemamanager", (Object)errStr, (Throwable)e);
            response.setAttribute("status", "error");
            response.setAttribute("message", errStr);
            return response;
        }
        List dependsOnMe = scm.getSchemasThatDependOnMe(schema);
        if (dependsOnMe.size() > 0) {
            String errStr = "Cannot remove schema " + schema + " because the following schemas list it as a dependency: " + dependsOnMe;
            context.error(errStr);
            response.setAttribute("status", "error");
            response.setAttribute("message", errStr);
            return response;
        }
        try {
            scm.deletePluginSchema(schema);
            response.setAttribute("status", "ok");
            response.setAttribute("message", "Schema " + schema + " deleted");
            return response;
        }
        catch (Exception e) {
            Log.error((String)"geonetwork.schemamanager", (Object)("Could not delete schema, error if any was " + e.getMessage()), (Throwable)e);
            response.setAttribute("status", "error");
            response.setAttribute("message", "Could not delete schema, error if any was " + e.getMessage());
        }
        return response;
    }
}

