/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.metadata;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.ObjectName;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.MetadataIndexerProcessor;
import org.fao.geonet.util.ThreadUtils;
import org.springframework.jmx.export.MBeanExporter;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedResource;

@ManagedResource
public class BatchOpsMetadataReindexer
extends MetadataIndexerProcessor
implements Runnable {
    private static JmxRemovalListener removalListener = new JmxRemovalListener();
    private static Cache<ObjectName, ObjectName> PROBE_CACHE = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).removalListener((RemovalListener)removalListener).build();
    private Set<Integer> metadata;
    private ExecutorService executor = null;
    private ObjectName probeName;
    private int toProcessCount;
    private AtomicInteger processed = new AtomicInteger();
    private AtomicInteger inError = new AtomicInteger();
    private CompletableFuture<Void> allCompleted;
    private MBeanExporter exporter;

    public BatchOpsMetadataReindexer(DataManager dm, Set<Integer> metadata) {
        super(dm);
        this.metadata = metadata;
        this.toProcessCount = metadata.size();
        this.exporter = (MBeanExporter)ApplicationContextHolder.get().getBean(MBeanExporter.class);
        removalListener.setExporter(this.exporter);
    }

    @ManagedAttribute
    public int getToProcessCount() {
        return this.toProcessCount;
    }

    @ManagedAttribute
    public int getProcessed() {
        return this.processed.intValue();
    }

    @ManagedAttribute
    public int getInError() {
        return this.inError.intValue();
    }

    public void process(boolean runInCurrentThread) throws Exception {
        this.wrapAsyncProcess(runInCurrentThread);
        this.allCompleted.get();
    }

    public void process() throws Exception {
        this.process(false);
    }

    public String wrapAsyncProcess(boolean runInCurrentThread) throws Exception {
        this.probeName = new ObjectName(String.format("geonetwork:name=indexing-task,idx=%s", this.hashCode()));
        this.exporter.registerManagedResource((Object)this, this.probeName);
        return this.processAsync(runInCurrentThread);
    }

    private String processAsync(boolean runInCurrentThread) throws Exception {
        int count;
        int threadCount = ThreadUtils.getNumberOfThreads();
        this.executor = runInCurrentThread ? MoreExecutors.newDirectExecutorService() : Executors.newFixedThreadPool(threadCount);
        int[] ids = this.metadata.stream().mapToInt(i -> i).toArray();
        int perThread = ids.length < threadCount ? ids.length : ids.length / threadCount;
        ArrayList jobs = Lists.newArrayList();
        for (int index = 0; index < ids.length; index += count) {
            int start = index;
            count = Math.min(perThread, ids.length - start);
            BatchOpsCallable task = new BatchOpsCallable(ids, start, count);
            jobs.add(task);
        }
        ArrayList submitList = Lists.newArrayList();
        for (BatchOpsCallable job : jobs) {
            CompletableFuture<Void> completed = CompletableFuture.runAsync(job, this.executor);
            submitList.add(completed);
        }
        this.allCompleted = CompletableFuture.allOf(submitList.toArray(new CompletableFuture[submitList.size()]));
        this.allCompleted.thenRun(this);
        return this.probeName.toString();
    }

    @Override
    public void run() {
        this.executor.shutdown();
        PROBE_CACHE.cleanUp();
        PROBE_CACHE.put((Object)this.probeName, (Object)this.probeName);
    }

    private static class JmxRemovalListener
    implements RemovalListener<ObjectName, ObjectName> {
        private MBeanExporter exporter;

        private JmxRemovalListener() {
        }

        public void onRemoval(RemovalNotification<ObjectName, ObjectName> removalNotification) {
            this.exporter.unregisterManagedResource((ObjectName)removalNotification.getValue());
        }

        public void setExporter(MBeanExporter exporter) {
            this.exporter = exporter;
        }
    }

    private final class BatchOpsCallable
    implements Runnable {
        private final int[] ids;
        private final int beginIndex;
        private final int count;

        BatchOpsCallable(int[] ids, int beginIndex, int count) {
            this.ids = ids;
            this.beginIndex = beginIndex;
            this.count = count;
        }

        @Override
        public void run() {
            for (int i = this.beginIndex; i < this.beginIndex + this.count; ++i) {
                boolean doIndex = this.beginIndex + this.count - 1 == i;
                try {
                    BatchOpsMetadataReindexer.this.dm.indexMetadata(this.ids[i] + "", doIndex, null);
                    BatchOpsMetadataReindexer.this.processed.incrementAndGet();
                    continue;
                }
                catch (Exception e) {
                    BatchOpsMetadataReindexer.this.inError.incrementAndGet();
                }
            }
        }
    }
}

