/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.mef;

import java.nio.file.Path;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jeeves.interfaces.Service;
import jeeves.server.ServiceConfig;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.Util;
import org.fao.geonet.constants.Edit;
import org.fao.geonet.kernel.SelectionManager;
import org.fao.geonet.kernel.mef.MEFLib;
import org.fao.geonet.kernel.search.MetaSearcher;
import org.fao.geonet.kernel.search.SearchManager;
import org.fao.geonet.kernel.search.SearcherType;
import org.fao.geonet.utils.BinaryFile;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Content;
import org.jdom.Element;

@Deprecated
public class Export
implements Service {
    private Path stylePath;
    private ServiceConfig _config;

    public void init(Path appPath, ServiceConfig params) throws Exception {
        this.stylePath = appPath.resolve("xml/schemas/");
        this._config = params;
    }

    public Element exec(Element params, ServiceContext context) throws Exception {
        Path file = null;
        String uuid = Util.getParam((Element)params, (String)"uuid", null);
        String format = Util.getParam((Element)params, (String)"format", (String)"full");
        String version = Util.getParam((Element)params, (String)"version", null);
        String bucket = Util.getParam((Element)params, (String)"bucket", (String)"metadata");
        boolean skipUUID = Boolean.parseBoolean(Util.getParam((Element)params, (String)"skipUuid", (String)"false"));
        boolean resolveXlink = Boolean.parseBoolean(Util.getParam((Element)params, (String)"resolveXlink", (String)"true"));
        boolean removeXlinkAttribute = Boolean.parseBoolean(Util.getParam((Element)params, (String)"removeXlinkAttribute", (String)"true"));
        boolean addSchemaLocation = Boolean.parseBoolean(Util.getParam((Element)params, (String)"addSchemaLocation", (String)"true"));
        boolean approved = Boolean.parseBoolean(Util.getParam((Element)params, (String)"approved", (String)"true"));
        String relatedMetadataRecord = Util.getParam((Element)params, (String)"relation", (String)"true");
        UserSession session = context.getUserSession();
        Log.info((String)"geonetwork.mef", (Object)"Create export task for selected metadata(s).");
        SelectionManager selectionManger = SelectionManager.getManager((UserSession)session);
        Set uuids = selectionManger.getSelection(bucket);
        Log.info((String)"geonetwork.mef", (Object)("Current record(s) in selection: " + uuids.size()));
        selectionManger.close("metadata");
        if (uuid != null) {
            selectionManger.addSelection("metadata", uuid);
        } else {
            selectionManger.addAllSelection("metadata", uuids);
        }
        if (version == null) {
            file = MEFLib.doExport((ServiceContext)context, (String)uuid, (String)format, (boolean)skipUUID, (boolean)resolveXlink, (boolean)removeXlinkAttribute, (boolean)addSchemaLocation, (boolean)approved);
        } else {
            if (relatedMetadataRecord.equals("true")) {
                HashSet<String> tmpUuid = new HashSet<String>();
                for (String _uuid : uuids) {
                    Element childRequest = new Element("request");
                    childRequest.addContent((Content)new Element("parentUuid").setText(_uuid));
                    childRequest.addContent((Content)new Element("to").setText("1000"));
                    Set<String> childs = this.getUuidsToExport(_uuid, context, childRequest);
                    if (childs.size() != 0) {
                        tmpUuid.addAll(childs);
                    }
                    Element servicesRequest = new Element("request");
                    servicesRequest.addContent((Content)new Element("operatesOn").setText(_uuid));
                    servicesRequest.addContent((Content)new Element("type").setText("service"));
                    Set<String> services = this.getUuidsToExport(_uuid, context, servicesRequest);
                    if (services.size() == 0) continue;
                    tmpUuid.addAll(services);
                }
                if (selectionManger.addAllSelection("metadata", tmpUuid)) {
                    Log.info((String)"geonetwork.mef", (Object)"Child and services added into the selection");
                }
            }
            uuids = selectionManger.getSelection("metadata");
            Log.info((String)"geonetwork.mef", (Object)("Building MEF2 file with " + uuids.size() + " records."));
            file = MEFLib.doMEF2Export((ServiceContext)context, (Set)uuids, (String)format, (boolean)false, (Path)this.stylePath, (boolean)resolveXlink, (boolean)removeXlinkAttribute, (boolean)false, (boolean)addSchemaLocation, (boolean)approved);
        }
        selectionManger.close("metadata");
        String fname = String.valueOf(Calendar.getInstance().getTimeInMillis());
        return BinaryFile.encode((int)200, (Path)file, (String)("export-" + format + "-" + fname + ".zip"), (boolean)true).getElement();
    }

    private Set<String> getUuidsToExport(String uuid, ServiceContext context, Element request) throws Exception {
        if (Log.isDebugEnabled((String)"geonetwork.mef")) {
            Log.debug((String)"geonetwork.mef", (Object)("Creating searcher to run request: " + Xml.getString((Element)request)));
        }
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        SearchManager searchMan = (SearchManager)gc.getBean(SearchManager.class);
        try (MetaSearcher searcher = searchMan.newSearcher(SearcherType.LUCENE, "lucene.xsl");){
            HashSet<String> uuids = new HashSet<String>();
            searcher.search(context, request, this._config);
            if (searcher.getSize() != 0) {
                if (Log.isDebugEnabled((String)"geonetwork.mef")) {
                    Log.debug((String)"geonetwork.mef", (Object)("  Exporting record(s) found for metadata: " + uuid));
                }
                Element elt = searcher.present(context, request, this._config);
                List isoElt = elt.getChildren();
                for (Element md : isoElt) {
                    if (md.getName().equals("summary")) continue;
                    String mdUuid = md.getChild("info", Edit.NAMESPACE).getChildText("uuid");
                    if (Log.isDebugEnabled((String)"geonetwork.mef")) {
                        Log.debug((String)"geonetwork.mef", (Object)("    Adding: " + mdUuid));
                    }
                    uuids.add(mdUuid);
                }
            }
            Log.info((String)"geonetwork.mef", (Object)("  Found " + uuids.size() + " record(s)."));
            HashSet<String> hashSet = uuids;
            return hashSet;
        }
    }
}

