/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.guiservices.csw;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import jeeves.interfaces.Service;
import jeeves.server.ServiceConfig;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.Util;
import org.fao.geonet.domain.Language;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.repository.CswCapabilitiesInfo;
import org.fao.geonet.repository.CswCapabilitiesInfoFieldRepository;
import org.fao.geonet.repository.LanguageRepository;
import org.jdom.Element;

public class Set
implements Service {
    public void init(Path appPath, ServiceConfig params) throws Exception {
    }

    public Element exec(Element params, ServiceContext context) throws Exception {
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        this.saveCswServerConfig(params, (SettingManager)gc.getBean(SettingManager.class));
        this.saveCswCapabilitiesInfo(params, context);
        return new Element("response").setText("ok");
    }

    private void saveCswServerConfig(Element params, SettingManager settingManager) throws Exception {
        String cswEnableValue = Util.getParam((Element)params, (String)"csw.enable", (String)"");
        settingManager.setValue("system/csw/enable", cswEnableValue.equals("on"));
        String cswMetadataPublicValue = Util.getParam((Element)params, (String)"csw.metadataPublic", (String)"");
        settingManager.setValue("system/csw/metadataPublic", cswMetadataPublicValue.equals("on"));
        String capabilityRecordId = Util.getParam((Element)params, (String)"csw.capabilityRecordId", (String)"-1");
        settingManager.setValue("system/csw/capabilityRecordUuid", capabilityRecordId);
    }

    @Deprecated
    private void saveCswCapabilitiesInfo(Element params, ServiceContext serviceContext) throws Exception {
        List languages = ((LanguageRepository)serviceContext.getBean(LanguageRepository.class)).findAll();
        ArrayList toSave = new ArrayList();
        CswCapabilitiesInfoFieldRepository capabilitiesInfoFieldRepository = (CswCapabilitiesInfoFieldRepository)serviceContext.getBean(CswCapabilitiesInfoFieldRepository.class);
        for (Language language : languages) {
            CswCapabilitiesInfo cswCapInfo = capabilitiesInfoFieldRepository.findCswCapabilitiesInfo(language.getId());
            String langId = language.getId();
            cswCapInfo.setTitle(this.getValue(params, "csw.title_" + langId));
            cswCapInfo.setAbstract(this.getValue(params, "csw.abstract_" + langId));
            cswCapInfo.setFees(this.getValue(params, "csw.fees_" + langId));
            cswCapInfo.setAccessConstraints(this.getValue(params, "csw.accessConstraints_" + langId));
            toSave.addAll(cswCapInfo.getFields());
        }
        capabilitiesInfoFieldRepository.save(toSave);
    }

    private String getValue(Element params, String paramId) {
        Element child = params.getChild(paramId);
        if (child != null) {
            return child.getValue();
        }
        return "";
    }
}

