/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.config;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.fao.geonet.domain.ReservedGroup;
import org.fao.geonet.domain.ReservedOperation;

public class PublicationOption {
    private String name;
    private ReservedGroup publicationGroup;
    List<ReservedOperation> publicationOperations;
    private EnumMap<ReservedGroup, List<ReservedOperation>> additionalPublications = new EnumMap(ReservedGroup.class);

    PublicationOption(String name, ReservedGroup publicationGroup, List<ReservedOperation> publicationOperations) {
        this.name = name;
        this.publicationGroup = publicationGroup;
        this.publicationOperations = publicationOperations;
    }

    public String getName() {
        return this.name;
    }

    public ReservedGroup getPublicationGroup() {
        return this.publicationGroup;
    }

    public List<ReservedOperation> getPublicationOperations() {
        return this.publicationOperations;
    }

    public Map<ReservedGroup, List<ReservedOperation>> getAdditionalPublications() {
        return this.additionalPublications;
    }

    public void addAdditionalPublicationInfo(ReservedGroup group, List<ReservedOperation> operations) {
        if (!this.publicationGroup.equals((Object)group)) {
            this.additionalPublications.put(group, operations);
        }
    }

    public List<ReservedOperation> getPublicationOperationsForGroup(ReservedGroup group) {
        if (this.publicationGroup.equals((Object)group)) {
            return this.publicationOperations;
        }
        return this.additionalPublications.get(group);
    }

    public boolean hasPublicationTo(ReservedGroup group) {
        return this.publicationGroup.equals((Object)group) || !this.additionalPublications.containsKey(group);
    }
}

