/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.userfeedback;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.apache.jcs.access.exception.ObjectNotFoundException;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.tools.i18n.LanguageUtils;
import org.fao.geonet.api.userfeedback.UserFeedbackDTO;
import org.fao.geonet.api.userfeedback.UserFeedbackUtils;
import org.fao.geonet.api.userfeedback.service.IUserFeedbackService;
import org.fao.geonet.api.users.recaptcha.RecaptchaChecker;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.userfeedback.RatingCriteria;
import org.fao.geonet.domain.userfeedback.UserFeedback;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.repository.MetadataRepository;
import org.fao.geonet.repository.userfeedback.RatingCriteriaRepository;
import org.fao.geonet.util.MailUtil;
import org.fao.geonet.util.XslUtil;
import org.fao.geonet.utils.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import springfox.documentation.annotations.ApiIgnore;

@RequestMapping(value={"/{portal}/api", "/{portal}/api/0.1"})
@Api(value="userfeedback", tags={"userfeedback"}, description="User feedback")
@Controller(value="userfeedback")
public class UserFeedbackAPI {
    @Autowired
    LanguageUtils languageUtils;
    @Autowired
    SettingManager settingManager;
    @Autowired
    RatingCriteriaRepository criteriaRepository;
    @Autowired
    MetadataRepository metadataRepository;

    @ApiOperation(value="Get list of rating criteria", nickname="getRatingCriteria")
    @RequestMapping(value={"/userfeedback/ratingcriteria"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public List<RatingCriteria> getRatingCriteria(@ApiIgnore HttpServletResponse response) {
        String functionEnabled = this.settingManager.getValue("system/localrating/enable");
        if (!functionEnabled.equals("advanced")) {
            response.setStatus(HttpStatus.FORBIDDEN.value());
            return null;
        }
        return this.criteriaRepository.findAll();
    }

    @ApiOperation(value="Removes a user feedback", notes="Removes a user feedback", nickname="deleteUserFeedback")
    @RequestMapping(value={"/userfeedback/{uuid}"}, produces={"application/json"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @PreAuthorize(value="hasRole('Reviewer')")
    @ApiResponses(value={@ApiResponse(code=204, message="User feedback removed."), @ApiResponse(code=403, message="Operation not allowed. Only Reviewvers can access it.")})
    @ResponseBody
    public ResponseEntity deleteUserFeedback(@ApiParam(value="User feedback UUID.", required=true) @PathVariable(value="uuid") String uuid, HttpServletRequest request) throws Exception {
        String functionEnabled = this.settingManager.getValue("system/localrating/enable");
        if (!functionEnabled.equals("advanced")) {
            return new ResponseEntity(HttpStatus.FORBIDDEN);
        }
        Log.debug((String)"org.fao.geonet.api.userfeedback.UserFeedback", (Object)"deleteUserFeedback");
        IUserFeedbackService userFeedbackService = this.getUserFeedbackService();
        userFeedbackService.removeUserFeedback(uuid, request.getRemoteAddr());
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ApiOperation(value="Provides an average rating for a metadata record", nickname="getMetadataUserComments")
    @RequestMapping(value={"/records/{metadataUuid}/userfeedbackrating"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public UserFeedbackUtils.RatingAverage getMetadataRating(@ApiParam(value="Metadata record UUID.", required=true) @PathVariable(value="metadataUuid") String metadataUuid, @ApiIgnore HttpServletRequest request, @ApiIgnore HttpServletResponse response, @ApiIgnore HttpSession httpSession) {
        try (ServiceContext context = ApiUtils.createServiceContext(request);){
            String functionEnabled = this.settingManager.getValue("system/localrating/enable");
            if (!functionEnabled.equals("advanced")) {
                response.setStatus(HttpStatus.FORBIDDEN.value());
                UserFeedbackUtils.RatingAverage ratingAverage = null;
                return ratingAverage;
            }
            Log.debug((String)"org.fao.geonet.api.userfeedback.UserFeedback", (Object)"getMetadataUserComments");
            AbstractMetadata metadata = ApiUtils.canViewRecord(metadataUuid, context);
            if (metadata == null) {
                this.printOutputMessage(response, HttpStatus.FORBIDDEN, "Operation not allowed. User needs to be able to view the resource.");
                UserFeedbackUtils.RatingAverage ratingAverage = null;
                return ratingAverage;
            }
            UserSession session = ApiUtils.getUserSession(httpSession);
            boolean published = true;
            if (session != null && session.isAuthenticated()) {
                published = false;
            }
            IUserFeedbackService userFeedbackService = this.getUserFeedbackService();
            UserFeedbackUtils utils = new UserFeedbackUtils();
            UserFeedbackUtils.RatingAverage ratingAverage = utils.getAverage(userFeedbackService.retrieveUserFeedbackForMetadata(metadataUuid, -1, published));
            return ratingAverage;
        }
        catch (Exception e) {
            Log.error((String)"geonetwork.api", (Object)("UserFeedbackAPI - getMetadataRating: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    @ApiOperation(value="Finds a specific user feedback", nickname="getUserFeedback")
    @RequestMapping(value={"/userfeedback/{uuid}"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public UserFeedbackDTO getUserComment(@ApiParam(value="User feedback UUID.", required=true) @PathVariable(value="uuid") String uuid, @ApiIgnore HttpServletRequest request, @ApiIgnore HttpServletResponse response, @ApiIgnore HttpSession httpSession) throws Exception {
        try (ServiceContext context = ApiUtils.createServiceContext(request);){
            AbstractMetadata metadata;
            String functionEnabled = this.settingManager.getValue("system/localrating/enable");
            if (!functionEnabled.equals("advanced")) {
                response.setStatus(HttpStatus.FORBIDDEN.value());
                UserFeedbackDTO userFeedbackDTO = null;
                return userFeedbackDTO;
            }
            Log.debug((String)"org.fao.geonet.api.userfeedback.UserFeedback", (Object)"getUserComment");
            IUserFeedbackService userFeedbackService = (IUserFeedbackService)ApplicationContextHolder.get().getBean("userFeedbackService");
            UserSession session = ApiUtils.getUserSession(httpSession);
            boolean published = true;
            if (session != null && session.isAuthenticated()) {
                published = false;
            }
            UserFeedback userfeedback = userFeedbackService.retrieveUserFeedback(uuid, published);
            UserFeedbackDTO dto = null;
            if (userfeedback != null) {
                dto = UserFeedbackUtils.convertToDto(userfeedback);
            }
            if ((metadata = ApiUtils.canViewRecord(userfeedback.getMetadata().getUuid(), context)) == null) {
                this.printOutputMessage(response, HttpStatus.FORBIDDEN, "Operation not allowed. User needs to be able to view the resource.");
                UserFeedbackDTO userFeedbackDTO = null;
                return userFeedbackDTO;
            }
            UserFeedbackDTO userFeedbackDTO = dto;
            return userFeedbackDTO;
        }
    }

    @ApiOperation(value="Finds a list of user feedback for a specific records. ", notes=" This list will include also the draft user feedback if the client is logged as reviewer.", nickname="getUserCommentsOnARecord")
    @RequestMapping(value={"/records/{metadataUuid}/userfeedback"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public List<UserFeedbackDTO> getUserCommentsOnARecord(@ApiParam(value="Metadata record UUID.", required=true) @PathVariable String metadataUuid, @ApiParam(value="Maximum number of feedback to return.", required=false) @RequestParam(defaultValue="-1", required=false) int size, @ApiIgnore HttpServletRequest request, @ApiIgnore HttpServletResponse response, @ApiIgnore HttpSession httpSession) throws Exception {
        try (ServiceContext context = ApiUtils.createServiceContext(request);){
            List<UserFeedbackDTO> list = this.getUserFeedback(metadataUuid, size, response, httpSession);
            return list;
        }
    }

    @ApiOperation(value="Finds a list of user feedback records. ", notes=" This list will include also the draft user feedback if the client is logged as reviewer.", nickname="getUserComments")
    @RequestMapping(value={"/userfeedback"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public List<UserFeedbackDTO> getUserComments(@ApiParam(value="Metadata record UUID.", required=false) @RequestParam(defaultValue="", required=false) String metadataUuid, @ApiParam(value="Maximum number of feedback to return.", required=false) @RequestParam(defaultValue="-1", required=false) int size, @ApiIgnore HttpServletRequest request, @ApiIgnore HttpServletResponse response, @ApiIgnore HttpSession httpSession) throws Exception {
        try (ServiceContext context = ApiUtils.createServiceContext(request);){
            List<UserFeedbackDTO> list = this.getUserFeedback(metadataUuid, size, response, httpSession);
            return list;
        }
    }

    private List<UserFeedbackDTO> getUserFeedback(String metadataUuid, int size, HttpServletResponse response, HttpSession httpSession) {
        String functionEnabled = this.settingManager.getValue("system/localrating/enable");
        if (!functionEnabled.equals("advanced")) {
            response.setStatus(HttpStatus.FORBIDDEN.value());
            return null;
        }
        try {
            Log.debug((String)"org.fao.geonet.api.userfeedback.UserFeedback", (Object)"getUserComments");
            IUserFeedbackService userFeedbackService = this.getUserFeedbackService();
            UserSession session = ApiUtils.getUserSession(httpSession);
            boolean published = true;
            if (session != null && session.isAuthenticated()) {
                published = false;
            }
            List<UserFeedback> listUserfeedback = null;
            listUserfeedback = metadataUuid == null || metadataUuid.equals("") ? userFeedbackService.retrieveUserFeedback(size, published) : userFeedbackService.retrieveUserFeedbackForMetadata(metadataUuid, size, published);
            return listUserfeedback.stream().map(feedback -> UserFeedbackUtils.convertToDto(feedback)).collect(Collectors.toList());
        }
        catch (Exception e) {
            Log.error((String)"geonetwork.api", (Object)("UserFeedbackAPI - getUserFeedback: " + e.getMessage()), (Throwable)e);
            response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
            return null;
        }
    }

    private IUserFeedbackService getUserFeedbackService() {
        return (IUserFeedbackService)ApplicationContextHolder.get().getBean("userFeedbackService");
    }

    @ApiOperation(value="Creates a user feedback", notes="Creates a user feedback in draft status if the user is not logged in.", nickname="newUserFeedback")
    @RequestMapping(value={"/userfeedback"}, produces={"application/json"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public ResponseEntity newUserFeedback(@ApiParam(name="uf") @RequestBody UserFeedbackDTO userFeedbackDto, @ApiIgnore HttpSession httpSession, @ApiIgnore HttpServletRequest request) throws Exception {
        String functionEnabled = this.settingManager.getValue("system/localrating/enable");
        if (!functionEnabled.equals("advanced")) {
            return new ResponseEntity(HttpStatus.FORBIDDEN);
        }
        try {
            boolean validRecaptcha;
            UserSession session = ApiUtils.getUserSession(httpSession);
            Locale locale = this.languageUtils.parseAcceptLanguage(request.getLocales());
            ResourceBundle messages = ResourceBundle.getBundle("org.fao.geonet.api.Messages", locale);
            Log.debug((String)"org.fao.geonet.api.userfeedback.UserFeedback", (Object)"newUserFeedback");
            IUserFeedbackService userFeedbackService = this.getUserFeedbackService();
            boolean recaptchaEnabled = this.settingManager.getValueAsBool("system/userSelfRegistration/recaptcha/enable");
            if (recaptchaEnabled && !(validRecaptcha = RecaptchaChecker.verify(userFeedbackDto.getCaptcha(), this.settingManager.getValue("system/userSelfRegistration/recaptcha/secretkey")))) {
                return new ResponseEntity((Object)messages.getString("recaptcha_not_valid"), HttpStatus.PRECONDITION_FAILED);
            }
            userFeedbackService.saveUserFeedback(UserFeedbackUtils.convertFromDto(userFeedbackDto, session != null ? session.getPrincipal() : null), request.getRemoteAddr());
            return new ResponseEntity(HttpStatus.CREATED);
        }
        catch (Exception e) {
            Log.error((String)"geonetwork.api", (Object)("UserFeedbackAPI - newUserFeedback: " + e.getMessage()), (Throwable)e);
            throw e;
        }
    }

    @ApiOperation(value="Send an email to catalogue administrator or record's contact", notes="", nickname="sendEmailToContact")
    @RequestMapping(value={"/records/{metadataUuid}/alert"}, produces={"application/json"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public ResponseEntity<String> sendEmailToContact(@ApiParam(value="Metadata record UUID.", required=true) @PathVariable(value="metadataUuid") String metadataUuid, @ApiParam(value="Recaptcha validation key.", required=false) @RequestParam(required=false, defaultValue="") String recaptcha, @ApiParam(value="User name.", required=true) @RequestParam String name, @ApiParam(value="User organisation.", required=true) @RequestParam String org, @ApiParam(value="User email address.", required=true) @RequestParam String email, @ApiParam(value="A comment or question.", required=true) @RequestParam String comments, @ApiParam(value="User phone number.", required=false) @RequestParam(required=false, defaultValue="") String phone, @ApiParam(value="Email subject.", required=false) @RequestParam(required=false, defaultValue="User feedback") String subject, @ApiParam(value="User function.", required=false) @RequestParam(required=false, defaultValue="-") String function, @ApiParam(value="Comment type.", required=false) @RequestParam(required=false, defaultValue="-") String type, @ApiParam(value="Comment category.", required=false) @RequestParam(required=false, defaultValue="-") String category, @ApiParam(value="List of record's contact to send this email.", required=false) @RequestParam(required=false, defaultValue="") String metadataEmail, @ApiIgnore HttpServletRequest request) throws Exception {
        boolean validRecaptcha;
        AbstractMetadata md = ApiUtils.canViewRecord(metadataUuid, request);
        Locale locale = this.languageUtils.parseAcceptLanguage(request.getLocales());
        ResourceBundle messages = ResourceBundle.getBundle("org.fao.geonet.api.Messages", locale);
        boolean recaptchaEnabled = this.settingManager.getValueAsBool("system/userSelfRegistration/recaptcha/enable");
        if (recaptchaEnabled && !(validRecaptcha = RecaptchaChecker.verify(recaptcha, this.settingManager.getValue("system/userSelfRegistration/recaptcha/secretkey")))) {
            return new ResponseEntity((Object)messages.getString("recaptcha_not_valid"), HttpStatus.PRECONDITION_FAILED);
        }
        String to = this.settingManager.getValue("system/feedback/email");
        String catalogueName = this.settingManager.getValue("system/site/name");
        HashSet<String> toAddress = new HashSet<String>();
        toAddress.add(to);
        if (StringUtils.isNotBlank((String)metadataEmail)) {
            String[] metadataAddresses;
            for (String metadataAddress : metadataAddresses = StringUtils.split((String)metadataEmail, (String)",")) {
                String cleanMetadataAddress = StringUtils.trimToEmpty((String)metadataAddress);
                if (cleanMetadataAddress.length() <= 0 || md.getData().indexOf(cleanMetadataAddress) <= 0) continue;
                toAddress.add(cleanMetadataAddress);
            }
        }
        String title = XslUtil.getIndexField(null, (Object)metadataUuid, (Object)"title", (Object)"");
        MailUtil.sendMail(new ArrayList(toAddress), (String)String.format(messages.getString("user_feedback_title"), catalogueName, title, subject), (String)String.format(messages.getString("user_feedback_text"), name, org, function, email, phone, title, type, category, comments, this.settingManager.getNodeURL(), metadataUuid), (SettingManager)this.settingManager);
        return new ResponseEntity(HttpStatus.CREATED);
    }

    private void printOutputMessage(HttpServletResponse response, HttpStatus code, String message) throws IOException {
        response.setStatus(code.value());
        PrintWriter out = response.getWriter();
        response.setContentType("text/html");
        out.println(message);
        response.flushBuffer();
    }

    @ApiOperation(value="Publishes a feedback", notes="For reviewers", nickname="publishFeedback")
    @RequestMapping(value={"/userfeedback/{uuid}/publish"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @PreAuthorize(value="hasRole('Reviewer')")
    @ApiResponses(value={@ApiResponse(code=204, message="User feedback published."), @ApiResponse(code=403, message="Operation not allowed. Only Reviewvers can access it."), @ApiResponse(code=404, message="Resource not found.")})
    @ResponseBody
    public ResponseEntity publish(@ApiParam(value="User feedback UUID.", required=true) @PathVariable(value="uuid") String uuid, @ApiIgnore HttpSession httpSession) throws Exception {
        String functionEnabled = this.settingManager.getValue("system/localrating/enable");
        if (!functionEnabled.equals("advanced")) {
            return new ResponseEntity(HttpStatus.FORBIDDEN);
        }
        try {
            UserSession session = ApiUtils.getUserSession(httpSession);
            IUserFeedbackService userFeedbackService = this.getUserFeedbackService();
            userFeedbackService.publishUserFeedback(uuid, session.getPrincipal());
        }
        catch (ObjectNotFoundException e) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        catch (Exception e) {
            Log.error((String)"geonetwork.api", (Object)("UserFeedbackAPI - publish: " + e.getMessage()), (Throwable)e);
        }
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }
}

