/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.site;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.persistence.criteria.Root;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jeeves.component.ProfileManager;
import jeeves.config.springutil.ServerBeanPropertyUpdater;
import jeeves.server.JeevesProxyInfo;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import org.apache.commons.fileupload.util.Streams;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.NodeInfo;
import org.fao.geonet.SystemInfo;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.site.LogUtils;
import org.fao.geonet.api.site.SiteInformation;
import org.fao.geonet.api.site.model.SettingSet;
import org.fao.geonet.api.site.model.SettingsListResponse;
import org.fao.geonet.api.tools.i18n.LanguageUtils;
import org.fao.geonet.doi.client.DoiManager;
import org.fao.geonet.domain.Metadata;
import org.fao.geonet.domain.MetadataSourceInfo_;
import org.fao.geonet.domain.Metadata_;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.domain.Setting;
import org.fao.geonet.domain.SettingDataType;
import org.fao.geonet.domain.Source;
import org.fao.geonet.domain.StatusValueNotificationLevel;
import org.fao.geonet.exceptions.OperationAbortedEx;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.kernel.datamanager.IMetadataManager;
import org.fao.geonet.kernel.harvest.HarvestManager;
import org.fao.geonet.kernel.search.EsSearchManager;
import org.fao.geonet.kernel.search.SearchManager;
import org.fao.geonet.kernel.setting.SettingInfo;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.repository.PathSpec;
import org.fao.geonet.repository.SettingRepository;
import org.fao.geonet.repository.SourceRepository;
import org.fao.geonet.repository.specification.MetadataSpecs;
import org.fao.geonet.resources.Resources;
import org.fao.geonet.utils.FilePathChecker;
import org.fao.geonet.utils.ProxyInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import springfox.documentation.annotations.ApiIgnore;

@RequestMapping(value={"/{portal}/api/site", "/{portal}/api/0.1/site"})
@Api(value="site", tags={"site"}, description="Catalog operations")
@Controller(value="site")
public class SiteApi {
    @Autowired
    SettingManager settingManager;
    @Autowired
    NodeInfo node;
    @Autowired
    SourceRepository sourceRepository;
    @Autowired
    LanguageUtils languageUtils;
    @Autowired
    private SystemInfo info;

    public static void reloadServices(ServiceContext context) throws Exception {
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        DataManager dataMan = (DataManager)gc.getBean(DataManager.class);
        SettingManager settingMan = (SettingManager)gc.getBean(SettingManager.class);
        SettingInfo si = (SettingInfo)context.getBean(SettingInfo.class);
        try {
            if (si.getLuceneIndexOptimizerSchedulerEnabled()) {
                dataMan.rescheduleOptimizer(si.getLuceneIndexOptimizerSchedulerAt(), si.getLuceneIndexOptimizerSchedulerInterval());
            } else {
                dataMan.disableOptimizer();
            }
        }
        catch (Exception e) {
            context.error("Reload services. Error: " + e.getMessage());
            context.error((Throwable)e);
            throw new OperationAbortedEx("Parameters saved but cannot restart Lucene Index Optimizer: " + e.getMessage());
        }
        LogUtils.refreshLogConfiguration();
        try {
            ProxyInfo pi = JeevesProxyInfo.getInstance();
            boolean useProxy = settingMan.getValueAsBool("system/proxy/use", false);
            if (useProxy) {
                String proxyHost = settingMan.getValue("system/proxy/host");
                String proxyPort = settingMan.getValue("system/proxy/port");
                String username = settingMan.getValue("system/proxy/username");
                String password = settingMan.getValue("system/proxy/password");
                pi.setProxyInfo(proxyHost, Integer.valueOf(proxyPort).intValue(), username, password);
            } else {
                pi.setProxyInfo(null, -1, null, null);
            }
            Lib.net.setupProxy(settingMan);
        }
        catch (Exception e) {
            context.error("Reload services. Error: " + e.getMessage());
            context.error((Throwable)e);
            throw new OperationAbortedEx("Parameters saved but cannot set proxy information: " + e.getMessage());
        }
        DoiManager doiManager = (DoiManager)gc.getBean(DoiManager.class);
        doiManager.loadConfig();
        HarvestManager harvestManager = (HarvestManager)context.getBean(HarvestManager.class);
        harvestManager.rescheduleActiveHarvesters();
    }

    @ApiOperation(value="Get site (or portal) description", notes="", nickname="getDescription")
    @RequestMapping(produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(code=200, message="Site description.")})
    @ResponseBody
    public SettingsListResponse get(@ApiIgnore HttpServletRequest request) throws Exception {
        String nodeDefault;
        Source source;
        SettingsListResponse response = new SettingsListResponse();
        response.setSettings(this.settingManager.getSettings(new String[]{"system/site/name", "system/site/organization", "system/site/siteId", "system/platform/version", "system/platform/subVersion"}));
        if ("srv".equals(this.node.getId())) {
            source = (Source)this.sourceRepository.findOne((Serializable)((Object)this.settingManager.getSiteId()));
            nodeDefault = "true";
        } else {
            source = (Source)this.sourceRepository.findOne((Serializable)((Object)this.node.getId()));
            nodeDefault = "false";
        }
        if (source != null) {
            List<Setting> settings = response.getSettings();
            String iso3langCode = this.languageUtils.iso3code(request.getLocales());
            settings.add(new Setting().setName("node/default").setValue(nodeDefault));
            settings.add(new Setting().setName("node/id").setValue(source.getUuid()));
            settings.add(new Setting().setName("node/name").setValue(StringUtils.isEmpty((String)source.getLabel(iso3langCode)) ? source.getName() : source.getLabel(iso3langCode)));
        }
        return response;
    }

    @ApiOperation(value="Get settings", notes="Return public settings for anonymous users, internals are allowed for authenticated.", nickname="getSettings")
    @RequestMapping(path={"/settings"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(code=200, message="Settings.")})
    @ResponseBody
    public SettingsListResponse getSettingsSet(@ApiParam(value="Setting set. A common set of settings to retrieve.", required=false) @RequestParam(required=false) SettingSet[] set, @ApiParam(value="Setting key", required=false) @RequestParam(required=false) String[] key, HttpServletRequest request, @ApiIgnore @ApiParam(hidden=true) HttpSession httpSession) throws Exception {
        ConfigurableApplicationContext appContext = ApplicationContextHolder.get();
        SettingManager sm = (SettingManager)appContext.getBean(SettingManager.class);
        UserSession session = ApiUtils.getUserSession(httpSession);
        Profile profile = session == null ? null : session.getProfile();
        ArrayList settingList = new ArrayList();
        if (set == null && key == null) {
            SettingRepository settingRepository = (SettingRepository)appContext.getBean(SettingRepository.class);
            List publicSettings = settingRepository.findAllByInternal(false);
            String mailServer = sm.getValue("system/feedback/mailServer/host");
            publicSettings.add(new Setting().setName("system/feedback/mailServer/hostIsDefined").setDataType(SettingDataType.BOOLEAN).setValue(StringUtils.isNotEmpty((String)mailServer) + ""));
            SettingsListResponse response = new SettingsListResponse();
            response.setSettings(publicSettings);
            return response;
        }
        if (set != null && set.length > 0) {
            for (SettingSet s : set) {
                String[] props = s.getListOfSettings();
                if (props == null) continue;
                Collections.addAll(settingList, props);
            }
        }
        if (key != null && key.length > 0) {
            Collections.addAll(settingList, key);
        }
        List settings = sm.getSettings(settingList.toArray(new String[0]));
        ListIterator iterator = settings.listIterator();
        while (iterator.hasNext()) {
            Setting s = (Setting)iterator.next();
            if (!s.isInternal() || profile != null) continue;
            settings.remove(s);
        }
        SettingsListResponse response = new SettingsListResponse();
        response.setSettings(settings);
        return response;
    }

    @ApiOperation(value="Get settings with details", notes="Provides also setting properties.", nickname="getSettingsDetails")
    @RequestMapping(path={"/settings/details"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(code=200, message="Settings with details.")})
    @ResponseBody
    @PreAuthorize(value="hasRole('Administrator')")
    public List<Setting> getSettingsDetails(@ApiParam(value="Setting set. A common set of settings to retrieve.", required=false) @RequestParam(required=false) SettingSet[] set, @ApiParam(value="Setting key", required=false) @RequestParam(required=false) String[] key, HttpServletRequest request, @ApiIgnore @ApiParam(hidden=true) HttpSession httpSession) throws Exception {
        ConfigurableApplicationContext appContext = ApplicationContextHolder.get();
        SettingManager sm = (SettingManager)appContext.getBean(SettingManager.class);
        UserSession session = ApiUtils.getUserSession(httpSession);
        Profile profile = session == null ? null : session.getProfile();
        ArrayList settingList = new ArrayList();
        if (set == null && key == null) {
            return sm.getAll();
        }
        if (set != null && set.length > 0) {
            for (SettingSet s : set) {
                String[] props = s.getListOfSettings();
                if (props == null) continue;
                Collections.addAll(settingList, props);
            }
        }
        if (key != null && key.length > 0) {
            Collections.addAll(settingList, key);
        }
        List settings = sm.getSettings(settingList.toArray(new String[0]));
        ListIterator iterator = settings.listIterator();
        while (iterator.hasNext()) {
            Setting s = (Setting)iterator.next();
            if (!s.isInternal() || profile != null) continue;
            settings.remove(s);
        }
        return settings;
    }

    @ApiOperation(value="Save settings", notes="", nickname="saveSettingsDetails")
    @RequestMapping(path={"/settings"}, produces={"application/json"}, method={RequestMethod.POST})
    @PreAuthorize(value="hasRole('Administrator')")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ApiResponses(value={@ApiResponse(code=204, message="Settings saved."), @ApiResponse(code=403, message="Operation not allowed. Only Administrators can access it.")})
    public void saveSettings(@ApiIgnore @ApiParam(hidden=false) @RequestParam Map<String, String> allRequestParams, HttpServletRequest request, @ApiIgnore @ApiParam(hidden=true) HttpSession httpSession) throws Exception {
        String newUuid;
        SourceRepository sourceRepository;
        Source siteSource;
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        SettingManager sm = (SettingManager)applicationContext.getBean(SettingManager.class);
        String currentUuid = sm.getSiteId();
        String oldSiteName = sm.getSiteName();
        if (!sm.setValues(allRequestParams)) {
            throw new OperationAbortedEx("Cannot set all values");
        }
        String newSiteName = sm.getSiteName();
        if (!oldSiteName.equals(newSiteName) && (siteSource = (Source)(sourceRepository = (SourceRepository)applicationContext.getBean(SourceRepository.class)).findOne((Serializable)((Object)currentUuid))) != null) {
            siteSource.setName(newSiteName);
            siteSource.getLabelTranslations().forEach((l, t) -> siteSource.getLabelTranslations().put(l, newSiteName));
            sourceRepository.save((Object)siteSource);
        }
        if ((newUuid = allRequestParams.get("system/site/siteId")) != null && !currentUuid.equals(newUuid)) {
            IMetadataManager metadataRepository = (IMetadataManager)applicationContext.getBean(IMetadataManager.class);
            SourceRepository sourceRepository2 = (SourceRepository)applicationContext.getBean(SourceRepository.class);
            Source source = (Source)sourceRepository2.findOne((Serializable)((Object)currentUuid));
            Source newSource = new Source(newUuid, source.getName(), source.getLabelTranslations(), source.getType());
            sourceRepository2.save((Object)newSource);
            PathSpec<Metadata, String> servicesPath = new PathSpec<Metadata, String>(){

                public javax.persistence.criteria.Path<String> getPath(Root<Metadata> root) {
                    return root.get(Metadata_.sourceInfo).get(MetadataSourceInfo_.sourceId);
                }
            };
            metadataRepository.createBatchUpdateQuery((PathSpec)servicesPath, newUuid, MetadataSpecs.isHarvested((boolean)false));
            sourceRepository2.delete((Object)source);
        }
        SettingInfo info = (SettingInfo)applicationContext.getBean(SettingInfo.class);
        try (ServiceContext context = ApiUtils.createServiceContext(request);){
            ServerBeanPropertyUpdater.updateURL((String)(info.getSiteUrl() + context.getBaseUrl()), (ApplicationContext)applicationContext);
            SiteApi.reloadServices(context);
        }
    }

    @ApiOperation(value="Get site informations", notes="", nickname="getInformation")
    @RequestMapping(path={"/info"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(code=200, message="Site information.")})
    @ResponseBody
    public SiteInformation getInformation(HttpServletRequest request) throws Exception {
        try (ServiceContext context = ApiUtils.createServiceContext(request);){
            SiteInformation siteInformation = new SiteInformation(context, (GeonetContext)context.getHandlerContext("contextName"));
            return siteInformation;
        }
    }

    @ApiOperation(value="Is CAS enabled?", notes="", nickname="isCasEnabled")
    @RequestMapping(path={"/info/isCasEnabled"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public boolean isCasEnabled(HttpServletRequest request) throws Exception {
        try (ServiceContext context = ApiUtils.createServiceContext(request);){
            boolean bl = ProfileManager.isCasEnabled();
            return bl;
        }
    }

    @ApiOperation(value="Update staging profile", notes="TODO: Needs doc", nickname="updateStagingProfile")
    @RequestMapping(path={"/info/staging/{profile}"}, produces={"application/json"}, method={RequestMethod.PUT})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ApiResponses(value={@ApiResponse(code=204, message="Staging profile saved."), @ApiResponse(code=403, message="Operation not allowed. Only Administrators can access it.")})
    @PreAuthorize(value="hasRole('Administrator')")
    public void updateStagingProfile(@PathVariable SystemInfo.Staging profile) {
        this.info.setStagingProfile(profile.toString());
    }

    @ApiOperation(value="Is in read-only mode?", notes="", nickname="isReadOnly")
    @RequestMapping(path={"/info/readonly"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public boolean isReadOnly() throws Exception {
        return ((NodeInfo)ApplicationContextHolder.get().getBean(NodeInfo.class)).isReadOnly();
    }

    @ApiOperation(value="Is indexing?", notes="", nickname="isIndexing")
    @RequestMapping(path={"/indexing"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public boolean isIndexing(HttpServletRequest request) throws Exception {
        try (ServiceContext context = ApiUtils.createServiceContext(request);){
            boolean bl = ((DataManager)ApplicationContextHolder.get().getBean(DataManager.class)).isIndexing();
            return bl;
        }
    }

    @ApiOperation(value="Index", notes="", nickname="index")
    @RequestMapping(path={"/index"}, produces={"application/json"}, method={RequestMethod.PUT})
    @PreAuthorize(value="hasRole('Editor')")
    @ResponseBody
    public HttpEntity index(@ApiParam(value="Drop and recreate index", required=false) @RequestParam(required=false, defaultValue="true") boolean reset, @ApiParam(value="Records having only XLinks", required=false) @RequestParam(required=false, defaultValue="false") boolean havingXlinkOnly, @ApiParam(value="Selection bucket name", required=false) @RequestParam(required=false) String bucket, HttpServletRequest request) throws Exception {
        try (ServiceContext context = ApiUtils.createServiceContext(request);){
            SearchManager searchMan = (SearchManager)ApplicationContextHolder.get().getBean(SearchManager.class);
            searchMan.rebuildIndex(context, havingXlinkOnly, reset, bucket);
            HttpEntity httpEntity = new HttpEntity((Object)HttpStatus.CREATED);
            return httpEntity;
        }
    }

    @ApiOperation(value="Index in Elastic", notes="", nickname="indexes")
    @RequestMapping(path={"/index/es"}, produces={"application/json"}, method={RequestMethod.PUT})
    @PreAuthorize(value="hasRole('Editor')")
    @ResponseBody
    public HttpEntity indexEs(@ApiParam(value="Drop and recreate index", required=false) @RequestParam(required=false, defaultValue="true") boolean reset, @ApiParam(value="Records having only XLinks", required=false) @RequestParam(required=false, defaultValue="false") boolean havingXlinkOnly, @ApiParam(value="Selection bucket name", required=false) @RequestParam(required=false) String bucket, HttpServletRequest request) throws Exception {
        try (ServiceContext context = ApiUtils.createServiceContext(request);){
            EsSearchManager searchMan = (EsSearchManager)ApplicationContextHolder.get().getBean(EsSearchManager.class);
            searchMan.rebuildIndex(context, havingXlinkOnly, reset, bucket);
            HttpEntity httpEntity = new HttpEntity((Object)HttpStatus.CREATED);
            return httpEntity;
        }
    }

    @ApiOperation(value="Delete index in Elastic", notes="", nickname="deleteIndexes")
    @RequestMapping(path={"/index/es"}, produces={"application/json"}, method={RequestMethod.DELETE})
    @PreAuthorize(value="hasRole('Editor')")
    @ResponseBody
    public HttpEntity deleteIndexEs() throws Exception {
        EsSearchManager searchMan = (EsSearchManager)ApplicationContextHolder.get().getBean(EsSearchManager.class);
        searchMan.clearIndex();
        return new HttpEntity((Object)HttpStatus.NO_CONTENT);
    }

    @ApiOperation(value="Get build details", notes="To know when and how this version of the application was built.", nickname="getSystemInfo")
    @RequestMapping(path={"/info/build"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(code=200, message="Build info.")})
    @PreAuthorize(value="hasRole('Administrator')")
    @ResponseBody
    public SystemInfo getSystemInfo() throws Exception {
        return (SystemInfo)ApplicationContextHolder.get().getBean(SystemInfo.class);
    }

    @ApiOperation(value="Get notification levels", notes="", nickname="getNotificationLevel")
    @RequestMapping(path={"/info/notificationLevels"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(code=200, message="List of notification levels.")})
    @PreAuthorize(value="hasAuthority('Administrator')")
    @ResponseBody
    public StatusValueNotificationLevel[] getNotificationLevel() {
        return StatusValueNotificationLevel.values();
    }

    @ApiOperation(value="Set catalog logo", notes="Logos are stored in the data directory resources/images/harvesting as PNG or GIF images. When a logo is assigned to the catalog, a new image is created in images/logos/<catalogUuid>.png.", nickname="setLogo")
    @RequestMapping(path={"/logo"}, produces={"application/json"}, method={RequestMethod.PUT})
    @PreAuthorize(value="hasRole('Administrator')")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ApiResponses(value={@ApiResponse(code=204, message="Logo set."), @ApiResponse(code=403, message="Operation not allowed. Only UserAdmins can access it.")})
    public void setLogo(@ApiParam(value="Logo to use for the catalog") @RequestParam(value="file") String file, @ApiParam(value="Create favicon too", required=false) @RequestParam(defaultValue="false", required=false) boolean asFavicon, HttpServletRequest request) throws Exception {
        block92: {
            ConfigurableApplicationContext appContext = ApplicationContextHolder.get();
            Resources resources = (Resources)appContext.getBean(Resources.class);
            Path logoDirectory = resources.locateHarvesterLogosDirSMVC((ApplicationContext)appContext);
            try (ServiceContext serviceContext = ApiUtils.createServiceContext(request);){
                Streams.checkFileName((String)file);
                FilePathChecker.verify((String)file);
                SettingManager settingMan = (SettingManager)appContext.getBean(SettingManager.class);
                String nodeUuid = settingMan.getSiteId();
                Resources.ResourceHolder holder = resources.getImage(serviceContext, file, logoDirectory);
                Path resourcesDir = resources.locateResourcesDir(request.getServletContext(), (ApplicationContext)serviceContext.getApplicationContext());
                if (holder == null || holder.getPath() == null) {
                    holder = resources.getImage(serviceContext, "images/harvesting/" + file, resourcesDir);
                }
                try (InputStream inputStream = Files.newInputStream(holder.getPath(), new OpenOption[0]);){
                    BufferedImage source = ImageIO.read(inputStream);
                    if (asFavicon) {
                        try (Resources.ResourceHolder favicon = resources.getWritableImage(serviceContext, "images/logos/favicon.png", resourcesDir);){
                            ApiUtils.createFavicon(source, favicon.getPath());
                            break block92;
                        }
                    }
                    try (Resources.ResourceHolder logo = resources.getWritableImage(serviceContext, "images/logos/" + nodeUuid + ".png", resourcesDir);
                         Resources.ResourceHolder defaultLogo = resources.getWritableImage(serviceContext, "images/logo.png", resourcesDir);){
                        if (!file.endsWith(".png")) {
                            try (OutputStream logoOut = Files.newOutputStream(logo.getPath(), new OpenOption[0]);
                                 OutputStream defLogoOut = Files.newOutputStream(defaultLogo.getPath(), new OpenOption[0]);){
                                ImageIO.write((RenderedImage)source, "png", logoOut);
                                ImageIO.write((RenderedImage)source, "png", defLogoOut);
                                break block92;
                            }
                        }
                        Files.copy(holder.getPath(), logo.getPath(), StandardCopyOption.REPLACE_EXISTING);
                        Files.copy(holder.getPath(), defaultLogo.getPath(), StandardCopyOption.REPLACE_EXISTING);
                    }
                }
                catch (Exception e) {
                    throw new Exception("Unable to move uploaded thumbnail to destination directory. Error: " + e.getMessage());
                }
                finally {
                    holder.close();
                }
            }
        }
    }

    @ApiOperation(value="Get XSL tranformations available", notes="XSL transformations may be applied while importing or harvesting records.", nickname="getXslTransformations")
    @RequestMapping(path={"/info/transforms"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(code=200, message="XSLT available.")})
    @ResponseBody
    public List<String> getXslTransformations() throws Exception {
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        GeonetworkDataDirectory dataDirectory = (GeonetworkDataDirectory)applicationContext.getBean(GeonetworkDataDirectory.class);
        try (DirectoryStream<Path> sheets = Files.newDirectoryStream(dataDirectory.getWebappDir().resolve("xsl/conversion/import"));){
            ArrayList<String> list = new ArrayList<String>();
            for (Path sheet : sheets) {
                String id = sheet.toString();
                if (id == null || !id.endsWith(".xsl")) continue;
                String name = com.google.common.io.Files.getNameWithoutExtension((String)sheet.getFileName().toString());
                list.add(name);
            }
            ArrayList<String> arrayList = list;
            return arrayList;
        }
    }
}

