/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.formatters;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import com.lowagie.text.DocumentException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jeeves.server.context.ServiceContext;
import jeeves.server.dispatchers.ServiceManager;
import jeeves.xlink.Processor;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.Constants;
import org.fao.geonet.SystemInfo;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.records.extent.MapRenderer;
import org.fao.geonet.api.records.formatters.AbstractFormatService;
import org.fao.geonet.api.records.formatters.ConfigFile;
import org.fao.geonet.api.records.formatters.FormatType;
import org.fao.geonet.api.records.formatters.FormatterImpl;
import org.fao.geonet.api.records.formatters.FormatterParams;
import org.fao.geonet.api.records.formatters.FormatterWidth;
import org.fao.geonet.api.records.formatters.GroovyFormatter;
import org.fao.geonet.api.records.formatters.ImageReplacedElementFactory;
import org.fao.geonet.api.records.formatters.XsltFormatter;
import org.fao.geonet.api.records.formatters.cache.CacheConfig;
import org.fao.geonet.api.records.formatters.cache.ChangeDateValidator;
import org.fao.geonet.api.records.formatters.cache.FormatterCache;
import org.fao.geonet.api.records.formatters.cache.Key;
import org.fao.geonet.api.records.formatters.cache.NoCacheValidator;
import org.fao.geonet.api.records.formatters.cache.StoreInfoAndDataLoadResult;
import org.fao.geonet.api.records.formatters.cache.Validator;
import org.fao.geonet.api.records.formatters.groovy.ParamValue;
import org.fao.geonet.api.tools.i18n.LanguageUtils;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.Metadata;
import org.fao.geonet.domain.MetadataType;
import org.fao.geonet.domain.OperationAllowed;
import org.fao.geonet.domain.Pair;
import org.fao.geonet.domain.ReservedOperation;
import org.fao.geonet.kernel.AccessManager;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.XmlSerializer;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.search.SearchManager;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.languages.IsoLanguagesMapper;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.repository.MetadataRepository;
import org.fao.geonet.repository.OperationAllowedRepository;
import org.fao.geonet.repository.specification.OperationAllowedSpecs;
import org.fao.geonet.util.XslUtil;
import org.fao.geonet.utils.GeonetHttpRequestFactory;
import org.fao.geonet.utils.IO;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.domain.Specifications;
import org.springframework.http.HttpEntity;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.WebRequest;
import org.xhtmlrenderer.extend.ReplacedElementFactory;
import org.xhtmlrenderer.pdf.ITextRenderer;
import springfox.documentation.annotations.ApiIgnore;

@Api(value="records", tags={"records"}, description="Metadata record operations")
@Controller(value="recordFormatter")
@Lazy
public class FormatterApi
extends AbstractFormatService
implements ApplicationListener {
    private static final Set<String> ALLOWED_PARAMETERS = Sets.newHashSet((Object[])new String[]{"id", "uuid", "xsl", "skippopularity", "hide_withheld"});
    private static final String PARAM_LANGUAGE_ALL_VALUES = "all";
    @Autowired
    LanguageUtils languageUtils;
    @Autowired
    IsoLanguagesMapper isoLanguagesMapper;
    private WeakHashMap<String, Element> pluginLocs = new WeakHashMap();
    private Map<Path, Boolean> isFormatterInSchemaPluginMap = Maps.newHashMap();

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof GeonetworkDataDirectory.GeonetworkDataDirectoryInitializedEvent) {
            GeonetworkDataDirectory.GeonetworkDataDirectoryInitializedEvent dataDirEvent = (GeonetworkDataDirectory.GeonetworkDataDirectoryInitializedEvent)event;
            String webappPath = "WEB-INF/data/data/formatter";
            GeonetworkDataDirectory geonetworkDataDirectory = dataDirEvent.getSource();
            Path fromDir = geonetworkDataDirectory.getWebappDir().resolve("WEB-INF/data/data/formatter");
            Path toDir = geonetworkDataDirectory.getFormatterDir();
            try {
                this.copyNewerFilesToDataDir(fromDir, toDir);
                SchemaManager schemaManager = (SchemaManager)dataDirEvent.getApplicationContext().getBean(SchemaManager.class);
                Set schemas = schemaManager.getSchemas();
                for (String schema : schemas) {
                    String webappSchemaPath = "WEB-INF/data/config/schema_plugins/" + schema + "/" + "formatter";
                    Path webappSchemaDir = geonetworkDataDirectory.getWebappDir().resolve(webappSchemaPath);
                    Path dataDirSchemaFormatterDir = schemaManager.getSchemaDir(schema).resolve("formatter");
                    this.copyNewerFilesToDataDir(webappSchemaDir, dataDirSchemaFormatterDir);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void copyNewerFilesToDataDir(final Path fromDir, final Path toDir) throws IOException {
        if (Files.exists(fromDir, new LinkOption[0])) {
            Files.walkFileTree(fromDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Path path = IO.relativeFile((Path)fromDir, (Path)file, (Path)toDir);
                    if (!(file.getFileName().toString().toLowerCase().endsWith(".iml") || Files.exists(path, new LinkOption[0]) && Files.getLastModifiedTime(path, new LinkOption[0]).compareTo(Files.getLastModifiedTime(file, new LinkOption[0])) >= 0)) {
                        Files.deleteIfExists(path);
                        IO.copyDirectoryOrFile((Path)file, (Path)path, (boolean)false);
                    }
                    return super.visitFile(file, attrs);
                }
            });
        }
    }

    @RequestMapping(value={"/{portal}/api/records/{metadataUuid}/formatters/{formatterId}", "/{portal}/api/0.1/records/{metadataUuid}/formatters/{formatterId}"}, method={RequestMethod.GET}, produces={"text/html", "application/xhtml+xml", "application/pdf", "*/*"})
    @ApiOperation(value="Get a formatted metadata record", nickname="getRecordFormattedBy")
    @ResponseBody
    public void getRecordFormattedBy(@ApiParam(value="Formatter type to use.") @RequestHeader(value="Accept", defaultValue="text/html") String acceptHeader, @PathVariable(value="formatterId") String formatterId, @ApiParam(value="Record UUID.", required=true) @PathVariable String metadataUuid, @RequestParam(value="width", defaultValue="_100") FormatterWidth width, @RequestParam(value="mdpath", required=false) String mdPath, @ApiParam(value="Optional language ISO 3 letters code to override HTTP Accept-language header.", required=false) @RequestParam(value="language", required=false) String iso3lang, @RequestParam(value="output", required=false) FormatType formatType, @ApiParam(value="Download the approved version", required=false, defaultValue="true") @RequestParam(required=false, defaultValue="true") boolean approved, @ApiIgnore NativeWebRequest request, HttpServletRequest servletRequest) throws Exception {
        Locale locale = this.languageUtils.parseAcceptLanguage(servletRequest.getLocales());
        if ("*/*".equals(acceptHeader)) {
            acceptHeader = "text/html";
        }
        if (formatType == null) {
            formatType = FormatType.find(acceptHeader);
        }
        if (formatType == null) {
            formatType = FormatType.xml;
        }
        String language = StringUtils.isNotEmpty((String)iso3lang) ? (PARAM_LANGUAGE_ALL_VALUES.equalsIgnoreCase(iso3lang) ? iso3lang : (this.languageUtils.getUiLanguages().contains(iso3lang) ? IsoLanguagesMapper.iso639_2T_to_iso639_2B((String)iso3lang) : this.languageUtils.getDefaultUiLanguage())) : IsoLanguagesMapper.iso639_2T_to_iso639_2B((String)locale.getISO3Language());
        AbstractMetadata metadata = ApiUtils.canViewRecord(metadataUuid, servletRequest);
        if (approved) {
            metadata = ((MetadataRepository)ApplicationContextHolder.get().getBean(MetadataRepository.class)).findOneByUuid(metadataUuid);
        }
        Boolean hideWithheld = true;
        Key key = new Key(metadata.getId(), language, formatType, formatterId, hideWithheld, width);
        boolean skipPopularityBool = false;
        ISODate changeDate = metadata.getDataInfo().getChangeDate();
        try (ServiceContext context = this.createServiceContext(language, formatType, (HttpServletRequest)request.getNativeRequest(HttpServletRequest.class));){
            Validator validator;
            if (changeDate != null) {
                long changeDateAsTime = changeDate.toDate().getTime();
                long roundedChangeDate = changeDateAsTime / 1000L * 1000L;
                if (request.checkNotModified(language, roundedChangeDate) && ((CacheConfig)context.getBean(CacheConfig.class)).allowCaching(key)) {
                    ((DataManager)context.getBean(DataManager.class)).increasePopularity(context, String.valueOf(metadata.getId()));
                    return;
                }
                validator = new ChangeDateValidator(changeDateAsTime);
            } else {
                validator = new NoCacheValidator();
            }
            FormatMetadata formatMetadata = new FormatMetadata(context, key, request);
            byte[] bytes = this.hasNonStandardParameters(request) ? formatMetadata.call().data : ((FormatterCache)context.getBean(FormatterCache.class)).get(key, validator, formatMetadata, false);
            if (bytes != null) {
                ((DataManager)context.getBean(DataManager.class)).increasePopularity(context, String.valueOf(metadata.getId()));
                this.writeOutResponse(context, metadataUuid, IsoLanguagesMapper.iso639_2T_to_iso639_2B((String)locale.getISO3Language()), (HttpServletResponse)request.getNativeResponse(HttpServletResponse.class), formatType, bytes);
            }
        }
    }

    @RequestMapping(value={"/{portal}/{lang}/xml.format.{type}"})
    @ResponseBody
    @Deprecated
    public void execXml(@PathVariable String lang, @PathVariable String type, @RequestParam(value="xsl", required=false) String xslid, @RequestParam(value="metadata", required=false) String metadata, @RequestParam(value="url", required=false) String url, @RequestParam(value="schema") String schema, @RequestParam(value="width", defaultValue="_100") FormatterWidth width, @RequestParam(value="mdpath", required=false) String mdPath, NativeWebRequest request) throws Exception {
        if (url == null && metadata == null) {
            throw new IllegalArgumentException("Either the metadata or url parameter must be declared.");
        }
        if (url != null && metadata != null) {
            throw new IllegalArgumentException("Only one of metadata or url parameter must be declared.");
        }
        FormatType formatType = FormatType.valueOf(type.toLowerCase());
        try (ServiceContext context = this.createServiceContext(lang, formatType, (HttpServletRequest)request.getNativeRequest(HttpServletRequest.class));){
            if (metadata == null) {
                metadata = this.getXmlFromUrl(context, lang, url, (WebRequest)request);
            }
            Element metadataEl = Xml.loadString((String)metadata, (boolean)false);
            if (mdPath != null) {
                List namespaces = ((SchemaManager)context.getBean(SchemaManager.class)).getSchema(schema).getNamespaces();
                metadataEl = Xml.selectElement((Element)metadataEl, (String)mdPath, (List)namespaces);
                metadataEl.detach();
            }
            Metadata metadataInfo = new Metadata();
            metadataInfo.setData(metadata).setId(1).setUuid("uuid");
            metadataInfo.getDataInfo().setType(MetadataType.METADATA).setRoot(metadataEl.getQualifiedName()).setSchemaId(schema);
            Pair<FormatterImpl, FormatterParams> result = this.createFormatterAndParams(lang, formatType, xslid, width, request, context, metadataEl, (AbstractMetadata)metadataInfo);
            String formattedMetadata = ((FormatterImpl)result.one()).format((FormatterParams)result.two());
            byte[] bytes = formattedMetadata.getBytes(Constants.CHARSET);
            this.writeOutResponse(context, "", lang, (HttpServletResponse)request.getNativeResponse(HttpServletResponse.class), formatType, bytes);
        }
    }

    @RequestMapping(value={"/{portal}/{lang}/md.format.public.{type}"})
    public HttpEntity<byte[]> getCachedPublicMetadata(@PathVariable String lang, @PathVariable String type, @RequestParam(required=false) String id, @RequestParam(value="uuid", required=false) String uuid, @RequestParam(value="xsl", required=false) String xslid) throws Exception {
        String resolvedId;
        Key key;
        FormatType formatType = FormatType.valueOf(type.toLowerCase());
        FormatterCache formatterCache = (FormatterCache)ApplicationContextHolder.get().getBean(FormatterCache.class);
        byte[] bytes = formatterCache.getPublished(key = new Key(Integer.parseInt(resolvedId = this.resolveId(id, uuid)), lang, formatType, xslid, true, FormatterWidth._100));
        if (bytes != null) {
            return new HttpEntity((Object)bytes);
        }
        return null;
    }

    @RequestMapping(value={"/{portal}/{lang}/md.format.{type}"})
    @ResponseBody
    public void exec(@PathVariable String lang, @PathVariable String type, @RequestParam(value="id", required=false) String id, @RequestParam(value="uuid", required=false) String uuid, @RequestParam(value="xsl", required=false) String xslid, @RequestParam(defaultValue="n") String skipPopularity, @RequestParam(value="hide_withheld", required=false) Boolean hide_withheld, @RequestParam(value="width", defaultValue="_100") FormatterWidth width, NativeWebRequest request) throws Exception {
        FormatType formatType = FormatType.valueOf(type.toLowerCase());
        String resolvedId = this.resolveId(id, uuid);
        try (ServiceContext context = this.createServiceContext(lang, formatType, (HttpServletRequest)request.getNativeRequest(HttpServletRequest.class));){
            Validator validator;
            Lib.resource.checkPrivilege(context, resolvedId, ReservedOperation.view);
            boolean hideWithheld = Boolean.TRUE.equals(hide_withheld) || !((AccessManager)context.getBean(AccessManager.class)).canEdit(context, resolvedId);
            Key key = new Key(Integer.parseInt(resolvedId), lang, formatType, xslid, hideWithheld, width);
            boolean skipPopularityBool = new ParamValue(skipPopularity).toBool();
            ISODate changeDate = ((SearchManager)context.getBean(SearchManager.class)).getDocChangeDate(resolvedId);
            if (changeDate != null) {
                long changeDateAsTime = changeDate.toDate().getTime();
                validator = new ChangeDateValidator(changeDateAsTime);
            } else {
                validator = new NoCacheValidator();
            }
            FormatMetadata formatMetadata = new FormatMetadata(context, key, request);
            byte[] bytes = this.hasNonStandardParameters(request) ? formatMetadata.call().data : ((FormatterCache)context.getBean(FormatterCache.class)).get(key, validator, formatMetadata, false);
            if (bytes != null) {
                if (!skipPopularityBool) {
                    ((DataManager)context.getBean(DataManager.class)).increasePopularity(context, resolvedId);
                }
                this.writeOutResponse(context, resolvedId, lang, (HttpServletResponse)request.getNativeResponse(HttpServletResponse.class), formatType, bytes);
            }
        }
    }

    private void writeOutResponse(ServiceContext context, String metadataUuid, String lang, HttpServletResponse response, FormatType formatType, byte[] formattedMetadata) throws Exception {
        response.setContentType(formatType.contentType);
        String filename = "metadata-" + metadataUuid + "." + (Object)((Object)formatType);
        response.addHeader("Content-Disposition", "inline; filename=\"" + filename + "\"");
        response.setStatus(200);
        if (formatType == FormatType.pdf) {
            this.writerAsPDF(context, response, formattedMetadata, lang);
        } else {
            response.setCharacterEncoding(Constants.ENCODING);
            response.setContentType(formatType.contentType);
            response.setContentLength(formattedMetadata.length);
            response.setHeader("Cache-Control", "no-cache");
            response.getOutputStream().write(formattedMetadata);
        }
    }

    private boolean hasNonStandardParameters(NativeWebRequest request) {
        Iterator iter = request.getParameterNames();
        while (iter.hasNext()) {
            if (ALLOWED_PARAMETERS.contains(iter.next())) continue;
            return true;
        }
        return false;
    }

    private String getXmlFromUrl(ServiceContext context, String lang, String url, WebRequest request) throws IOException, URISyntaxException {
        String adjustedUrl = url;
        if (!url.startsWith("http")) {
            adjustedUrl = ((SettingManager)context.getBean(SettingManager.class)).getSiteURL(lang) + url;
        } else {
            URI uri = new URI(url);
            Set allowedRemoteHosts = (Set)context.getBean("formatterRemoteFormatAllowedHosts", Set.class);
            Assert.isTrue((boolean)allowedRemoteHosts.contains(uri.getHost()), (String)("xml.format is not allowed to make requests to " + uri.getHost()));
        }
        HttpGet getXmlRequest = new HttpGet(adjustedUrl);
        Iterator headerNames = request.getHeaderNames();
        while (headerNames.hasNext()) {
            String[] headers;
            String headerName = (String)headerNames.next();
            for (String header : headers = request.getHeaderValues(headerName)) {
                getXmlRequest.addHeader(headerName, header);
            }
        }
        GeonetHttpRequestFactory requestFactory = (GeonetHttpRequestFactory)context.getBean(GeonetHttpRequestFactory.class);
        ClientHttpResponse execute = requestFactory.execute((HttpUriRequest)getXmlRequest);
        if (execute.getRawStatusCode() != 200) {
            throw new IllegalArgumentException("Request " + adjustedUrl + " did not succeed.  Response Status: " + execute.getStatusCode() + ", status text: " + execute.getStatusText());
        }
        return new String(ByteStreams.toByteArray((InputStream)execute.getBody()), Constants.CHARSET);
    }

    private void writerAsPDF(ServiceContext context, HttpServletResponse response, byte[] bytes, String lang) throws IOException, DocumentException {
        String htmlContent = new String(bytes, Constants.CHARSET);
        try {
            XslUtil.setNoScript();
            ITextRenderer renderer = new ITextRenderer();
            String siteUrl = ((SettingManager)context.getBean(SettingManager.class)).getSiteURL(lang);
            MapRenderer mapRenderer = new MapRenderer(context);
            renderer.getSharedContext().setReplacedElementFactory((ReplacedElementFactory)new ImageReplacedElementFactory(siteUrl.replace("/" + lang + "/", "/eng/"), renderer.getSharedContext().getReplacedElementFactory(), mapRenderer));
            renderer.getSharedContext().setDotsPerPixel(13);
            renderer.setDocumentFromString(htmlContent, siteUrl);
            renderer.layout();
            renderer.createPDF((OutputStream)response.getOutputStream());
        }
        catch (Exception e) {
            Log.error((String)"geonetwork.formatter", (Object)("Error converting formatter output to a file: " + htmlContent), (Throwable)e);
            throw e;
        }
    }

    @VisibleForTesting
    Pair<FormatterImpl, FormatterParams> loadMetadataAndCreateFormatterAndParams(ServiceContext context, Key key, NativeWebRequest request) throws Exception {
        Pair<Element, AbstractMetadata> elementMetadataPair = this.getMetadata(context, key.mdId, key.hideWithheld);
        Element metadata = (Element)elementMetadataPair.one();
        AbstractMetadata metadataInfo = (AbstractMetadata)elementMetadataPair.two();
        return this.createFormatterAndParams(key.lang, key.formatType, key.formatterId, key.width, request, context, metadata, metadataInfo);
    }

    private ServiceContext createServiceContext(String lang, FormatType type, HttpServletRequest request) {
        ServiceManager serviceManager = (ServiceManager)ApplicationContextHolder.get().getBean(ServiceManager.class);
        return serviceManager.createServiceContext("metadata.formatter" + (Object)((Object)type), lang, request);
    }

    private Pair<FormatterImpl, FormatterParams> createFormatterAndParams(String lang, FormatType type, String xslid, FormatterWidth width, NativeWebRequest request, ServiceContext context, Element metadata, AbstractMetadata metadataInfo) throws Exception {
        FormatterImpl formatter;
        GeonetworkDataDirectory geonetworkDataDirectory;
        Path formatDir;
        ConfigFile config;
        String schema = metadataInfo.getDataInfo().getSchemaId();
        Path schemaDir = null;
        if (schema != null) {
            schemaDir = ((SchemaManager)context.getBean(SchemaManager.class)).getSchemaDir(schema);
        }
        if (!this.isCompatibleMetadata(schema, config = new ConfigFile(formatDir = this.getAndVerifyFormatDir(geonetworkDataDirectory = (GeonetworkDataDirectory)context.getBean(GeonetworkDataDirectory.class), "xsl", xslid, schemaDir), true, schemaDir))) {
            throw new IllegalArgumentException("The bundle cannot format metadata with the " + schema + " schema");
        }
        FormatterParams fparams = new FormatterParams();
        fparams.config = config;
        fparams.format = this;
        fparams.webRequest = request;
        fparams.context = context;
        fparams.formatDir = formatDir.toRealPath(new LinkOption[0]);
        fparams.metadata = metadata;
        fparams.schema = schema;
        fparams.schemaDir = schemaDir;
        fparams.formatType = type;
        fparams.url = ((SettingManager)context.getBean(SettingManager.class)).getSiteURL(lang);
        fparams.metadataInfo = metadataInfo;
        fparams.width = width;
        fparams.formatterInSchemaPlugin = this.isFormatterInSchemaPlugin(formatDir, schemaDir);
        Path viewXslFile = formatDir.resolve("view.xsl");
        Path viewGroovyFile = formatDir.resolve("view.groovy");
        if (Files.exists(viewXslFile, new LinkOption[0])) {
            fparams.viewFile = viewXslFile.toRealPath(new LinkOption[0]);
            formatter = (FormatterImpl)context.getBean(XsltFormatter.class);
        } else if (Files.exists(viewGroovyFile, new LinkOption[0])) {
            fparams.viewFile = viewGroovyFile.toRealPath(new LinkOption[0]);
            formatter = (FormatterImpl)context.getBean(GroovyFormatter.class);
        } else {
            throw new IllegalArgumentException("The 'xsl' parameter must be a valid id of a formatter");
        }
        return Pair.read((Object)formatter, (Object)fparams);
    }

    private synchronized boolean isFormatterInSchemaPlugin(Path formatterDir, Path schemaDir) throws IOException {
        Path canonicalPath = formatterDir.toRealPath(new LinkOption[0]);
        Boolean isInSchemaPlugin = this.isFormatterInSchemaPluginMap.get(canonicalPath);
        if (isInSchemaPlugin == null) {
            isInSchemaPlugin = false;
            Path current = formatterDir;
            while (current.getParent() != null && Files.exists(current.getParent(), new LinkOption[0])) {
                if (current.equals(schemaDir)) {
                    isInSchemaPlugin = true;
                    break;
                }
                current = current.getParent();
            }
            this.isFormatterInSchemaPluginMap.put(canonicalPath, isInSchemaPlugin);
        }
        return isInSchemaPlugin;
    }

    public Pair<Element, AbstractMetadata> getMetadata(ServiceContext context, int id, Boolean hide_withheld) throws Exception {
        boolean withholdWithheldElements;
        AbstractMetadata md = this.loadMetadata((IMetadataUtils)context.getBean(IMetadataUtils.class), id);
        XmlSerializer serializer = (XmlSerializer)context.getBean(XmlSerializer.class);
        boolean doXLinks = serializer.resolveXLinks();
        Element metadata = serializer.removeHiddenElements(false, md, true);
        if (doXLinks) {
            Processor.processXLink((Element)metadata, (ServiceContext)context);
        }
        boolean bl = withholdWithheldElements = hide_withheld != null && hide_withheld != false;
        if (XmlSerializer.getThreadLocal((boolean)false) != null || withholdWithheldElements) {
            XmlSerializer.getThreadLocal((boolean)true).setForceFilterEditOperation(withholdWithheldElements);
        }
        return Pair.read((Object)metadata, (Object)md);
    }

    private boolean isCompatibleMetadata(String schemaName, ConfigFile config) throws Exception {
        List<String> applicable = config.listOfApplicableSchemas();
        return applicable.contains(schemaName) || applicable.contains(PARAM_LANGUAGE_ALL_VALUES);
    }

    Element getStrings(Path appPath, String lang) throws IOException, JDOMException {
        Path baseLoc = appPath.resolve("loc");
        Path locDir = this.findLocDir(lang, baseLoc);
        if (Files.exists(locDir, new LinkOption[0])) {
            return Xml.loadFile((Path)locDir.resolve("xml").resolve("strings.xml"));
        }
        return new Element("strings");
    }

    public synchronized Element getPluginLocResources(ServiceContext context, Path formatDir, String lang) throws Exception {
        Element pluginLocResources = this.getPluginLocResources(context, formatDir);
        Element translations = pluginLocResources.getChild(lang);
        if (translations == null) {
            translations = pluginLocResources.getChildren().isEmpty() ? new Element(lang) : (Element)pluginLocResources.getChildren().get(0);
        }
        return translations;
    }

    public synchronized Element getPluginLocResources(final ServiceContext context, Path formatDir) throws Exception {
        String formatDirPath = formatDir.toString();
        Element allLangResources = this.pluginLocs.get(formatDirPath);
        if (this.isDevMode(context) || allLangResources == null) {
            allLangResources = new Element("loc");
            Path baseLoc = formatDir.resolve("loc");
            if (Files.exists(baseLoc, new LinkOption[0])) {
                final Element finalAllLangResources = allLangResources;
                Files.walkFileTree(baseLoc, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    private void addTranslations(String locDirName, Element fileElements) {
                        if (locDirName != null && !locDirName.isEmpty()) {
                            Element resources = finalAllLangResources.getChild(locDirName);
                            if (resources == null) {
                                resources = new Element(locDirName);
                                finalAllLangResources.addContent((Content)resources);
                            }
                            resources.addContent((Content)fileElements);
                        }
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        if (file.getFileName().toString().toLowerCase().endsWith(".xml")) {
                            try {
                                Element fileElements = Xml.loadFile((Path)file);
                                String fileName = com.google.common.io.Files.getNameWithoutExtension((String)file.getFileName().toString());
                                fileElements.setName(fileName);
                                String locDirName = com.google.common.io.Files.getNameWithoutExtension((String)file.getParent().getFileName().toString());
                                this.addTranslations(locDirName, fileElements);
                            }
                            catch (JDOMException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        if (file.getFileName().toString().toLowerCase().endsWith(".json")) {
                            try {
                                String fileName = com.google.common.io.Files.getNameWithoutExtension((String)file.getFileName().toString());
                                String[] nameParts = fileName.split("-", 2);
                                IsoLanguagesMapper isoLanguagesMapper = (IsoLanguagesMapper)context.getBean(IsoLanguagesMapper.class);
                                String lang = isoLanguagesMapper.iso639_1_to_iso639_2(nameParts[0].toLowerCase(), nameParts[0]);
                                JSONObject json = new JSONObject(new String(Files.readAllBytes(file), Constants.CHARSET));
                                Element fileElements = new Element(nameParts[1]);
                                Iterator keys = json.keys();
                                while (keys.hasNext()) {
                                    String key = (String)keys.next();
                                    fileElements.addContent((Content)new Element(key).setText(json.getString(key)));
                                }
                                this.addTranslations(lang, fileElements);
                            }
                            catch (JSONException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        return super.visitFile(file, attrs);
                    }
                });
            }
            this.pluginLocs.put(formatDirPath, allLangResources);
        }
        return allLangResources;
    }

    private Path findLocDir(String lang, Path baseLoc) throws IOException {
        Path locDir = baseLoc.resolve(lang);
        if (!Files.exists(locDir, new LinkOption[0])) {
            locDir = baseLoc.resolve("eng");
        }
        if (!Files.exists(locDir, new LinkOption[0]) && Files.exists(baseLoc, new LinkOption[0])) {
            try (DirectoryStream<Path> paths = Files.newDirectoryStream(baseLoc);){
                Iterator<Path> pathIterator = paths.iterator();
                if (pathIterator.hasNext()) {
                    locDir = pathIterator.next();
                }
            }
        }
        return locDir;
    }

    protected boolean isDevMode(ServiceContext context) {
        return ((SystemInfo)context.getBean(SystemInfo.class)).isDevMode();
    }

    public class FormatMetadata
    implements Callable<StoreInfoAndDataLoadResult> {
        private final Key key;
        private final NativeWebRequest request;
        private final ServiceContext serviceContext;

        public FormatMetadata(ServiceContext context, Key key, NativeWebRequest request) {
            this.key = key;
            this.request = request;
            this.serviceContext = context;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public StoreInfoAndDataLoadResult call() throws Exception {
            this.serviceContext.setAsThreadLocal();
            try {
                Pair<FormatterImpl, FormatterParams> result = FormatterApi.this.loadMetadataAndCreateFormatterAndParams(this.serviceContext, this.key, this.request);
                FormatterImpl formatter = (FormatterImpl)result.one();
                FormatterParams fparams = (FormatterParams)result.two();
                String formattedMetadata = formatter.format(fparams);
                byte[] bytes = formattedMetadata.getBytes(Constants.CHARSET);
                long changeDate = fparams.metadataInfo.getDataInfo().getChangeDate().toDate().getTime();
                Specification isPublished = OperationAllowedSpecs.isPublic((ReservedOperation)ReservedOperation.view);
                Specification hasMdId = OperationAllowedSpecs.hasMetadataId((int)this.key.mdId);
                OperationAllowed one = (OperationAllowed)((OperationAllowedRepository)this.serviceContext.getBean(OperationAllowedRepository.class)).findOne((Specification)Specifications.where((Specification)hasMdId).and(isPublished));
                boolean isPublishedMd = one != null;
                Key withheldKey = null;
                FormatMetadata loadWithheld = null;
                if (!this.key.hideWithheld && isPublishedMd) {
                    withheldKey = new Key(this.key.mdId, this.key.lang, this.key.formatType, this.key.formatterId, true, this.key.width);
                    loadWithheld = new FormatMetadata(this.serviceContext, withheldKey, this.request);
                }
                StoreInfoAndDataLoadResult storeInfoAndDataLoadResult = new StoreInfoAndDataLoadResult(bytes, changeDate, isPublishedMd, withheldKey, loadWithheld);
                return storeInfoAndDataLoadResult;
            }
            finally {
                this.serviceContext.clearAsThreadLocal();
            }
        }
    }
}

