/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.formatters;

import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import jeeves.interfaces.Service;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.Constants;
import org.fao.geonet.Util;
import org.fao.geonet.api.records.formatters.AbstractFormatService;
import org.fao.geonet.exceptions.BadParameterEx;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.utils.FilePathChecker;
import org.jdom.Element;

public class EditFile
extends AbstractFormatService
implements Service {
    public Element exec(Element params, ServiceContext context) throws Exception {
        String xslid = Util.getParam((Element)params, (String)"id");
        String file = URLDecoder.decode(Util.getParam((Element)params, (String)"fname"), Constants.ENCODING);
        String schema = Util.getParam((Element)params, (String)"schema", null);
        Path schemaDir = null;
        if (schema != null) {
            schemaDir = ((SchemaManager)context.getBean(SchemaManager.class)).getSchemaDir(schema);
        }
        FilePathChecker.verify((String)file);
        Path formatDir = this.getAndVerifyFormatDir((GeonetworkDataDirectory)context.getBean(GeonetworkDataDirectory.class), "id", xslid, schemaDir);
        String absformatDir = formatDir.toAbsolutePath().toString();
        String absFile = formatDir.resolve(file).toAbsolutePath().toString();
        if (!absFile.startsWith(absformatDir)) {
            throw new BadParameterEx("fname", (Object)file);
        }
        Element result = new Element("data");
        Path filePath = formatDir.resolve(file);
        if (!Files.exists(filePath, new LinkOption[0])) {
            throw new BadParameterEx("fname", (Object)file);
        }
        String data = new String(Files.readAllBytes(formatDir.resolve(file)), Constants.ENCODING);
        result.setText(data);
        return result;
    }
}

