/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import javax.persistence.metamodel.SingularAttribute;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import jeeves.services.ReadWriteController;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.exception.FeatureNotEnabledException;
import org.fao.geonet.api.exception.NotAllowedException;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.api.processing.report.MetadataProcessingReport;
import org.fao.geonet.api.processing.report.SimpleMetadataProcessingReport;
import org.fao.geonet.api.records.MetadataUtils;
import org.fao.geonet.api.records.model.MetadataBatchApproveParameter;
import org.fao.geonet.api.records.model.MetadataBatchSubmitParameter;
import org.fao.geonet.api.records.model.MetadataPublicationNotificationInfo;
import org.fao.geonet.api.records.model.MetadataStatusParameter;
import org.fao.geonet.api.records.model.MetadataStatusResponse;
import org.fao.geonet.api.records.model.MetadataWorkflowStatusResponse;
import org.fao.geonet.api.tools.i18n.LanguageUtils;
import org.fao.geonet.constants.Edit;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.Group;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.Metadata;
import org.fao.geonet.domain.MetadataCategory;
import org.fao.geonet.domain.MetadataDraft;
import org.fao.geonet.domain.MetadataStatus;
import org.fao.geonet.domain.MetadataStatus_;
import org.fao.geonet.domain.MetadataType;
import org.fao.geonet.domain.Pair;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.domain.StatusValue;
import org.fao.geonet.domain.StatusValueType;
import org.fao.geonet.domain.User;
import org.fao.geonet.domain.utils.ObjectJSONUtils;
import org.fao.geonet.events.history.RecordRestoredEvent;
import org.fao.geonet.kernel.AccessManager;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.datamanager.IMetadataIndexer;
import org.fao.geonet.kernel.datamanager.IMetadataManager;
import org.fao.geonet.kernel.datamanager.IMetadataStatus;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.metadata.StatusActions;
import org.fao.geonet.kernel.metadata.StatusActionsFactory;
import org.fao.geonet.kernel.search.LuceneSearcher;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.repository.GroupRepository;
import org.fao.geonet.repository.MetadataCategoryRepository;
import org.fao.geonet.repository.MetadataDraftRepository;
import org.fao.geonet.repository.MetadataRepository;
import org.fao.geonet.repository.MetadataStatusRepository;
import org.fao.geonet.repository.OperationAllowedRepository;
import org.fao.geonet.repository.SortUtils;
import org.fao.geonet.repository.StatusValueRepository;
import org.fao.geonet.repository.UserGroupRepository;
import org.fao.geonet.repository.UserRepository;
import org.fao.geonet.util.MetadataPublicationMailNotifier;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Element;
import org.jdom.input.JDOMParseException;
import org.jdom.output.XMLOutputter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import springfox.documentation.annotations.ApiIgnore;

@RequestMapping(value={"/{portal}/api/records", "/{portal}/api/0.1/records"})
@Api(value="records", tags={"records"}, description="Metadata record operations")
@Controller(value="recordWorkflow")
@ReadWriteController
public class MetadataWorkflowApi {
    @Autowired
    LanguageUtils languageUtils;
    @Autowired
    MetadataStatusRepository metadataStatusRepository;
    @Autowired
    MetadataDraftRepository metadatadraftRepository;
    @Autowired
    StatusValueRepository statusValueRepository;
    @Autowired
    UserRepository userRepository;
    @Autowired
    GroupRepository groupRepository;
    @Autowired
    IMetadataStatus metadataStatus;
    @Autowired
    AccessManager accessManager;
    @Autowired
    SettingManager settingManager;
    @Autowired
    DataManager dataManager;
    @Autowired
    IMetadataIndexer metadataIndexer;
    @Autowired
    StatusActionsFactory statusActionFactory;
    @Autowired
    IMetadataUtils metadataUtils;
    @Autowired
    IMetadataManager metadataManager;
    @Autowired
    private UserGroupRepository userGroupRepository;
    @Autowired
    private MetadataRepository metadataRepository;
    @Autowired
    private MetadataCategoryRepository metadataCategoryRepository;
    @Autowired
    private OperationAllowedRepository operationAllowedRepository;
    @Autowired
    private MetadataCategoryRepository categoryRepository;
    @Autowired
    MetadataPublicationMailNotifier metadataPublicationMailNotifier;
    static final Integer[] supportedRestoreStatuses = new Integer[]{Integer.parseInt("51"), Integer.parseInt("60"), Integer.parseInt("61"), Integer.parseInt("63")};

    @ApiOperation(value="Get record status history", notes="", nickname="getRecordStatusHistory")
    @RequestMapping(value={"/{metadataUuid}/status"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public List<MetadataStatusResponse> getRecordStatusHistory(@ApiParam(value="Record UUID.", required=true) @PathVariable String metadataUuid, @RequestParam(required=false) boolean details, @ApiParam(value="Sort direction", required=false) @RequestParam(defaultValue="DESC") Sort.Direction sortOrder, HttpServletRequest request) throws Exception {
        try (ServiceContext context = ApiUtils.createServiceContext(request);){
            AbstractMetadata metadata = ApiUtils.canViewRecord(metadataUuid, context);
            String sortField = SortUtils.createPath((SingularAttribute[])new SingularAttribute[]{MetadataStatus_.changeDate});
            List listOfStatus = this.metadataStatusRepository.findAllByMetadataId(metadata.getId(), new Sort(sortOrder, new String[]{sortField}));
            List<MetadataStatusResponse> list = this.buildMetadataStatusResponses(listOfStatus, details, context.getLanguage());
            return list;
        }
    }

    @ApiOperation(value="Get record status history by type", notes="", nickname="getRecordStatusHistoryByType")
    @RequestMapping(value={"/{metadataUuid}/status/{type}"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public List<MetadataStatusResponse> getRecordStatusHistoryByType(@ApiParam(value="Record UUID.", required=true) @PathVariable String metadataUuid, @ApiParam(value="Type", required=true) @PathVariable StatusValueType type, @RequestParam(required=false) boolean details, @ApiParam(value="Sort direction", required=false) @RequestParam(defaultValue="DESC") Sort.Direction sortOrder, HttpServletRequest request) throws Exception {
        try (ServiceContext context = ApiUtils.createServiceContext(request);){
            AbstractMetadata metadata = ApiUtils.canViewRecord(metadataUuid, context);
            String sortField = SortUtils.createPath((SingularAttribute[])new SingularAttribute[]{MetadataStatus_.changeDate});
            List listOfStatus = this.metadataStatusRepository.findAllByMetadataIdAndByType(metadata.getId(), type, new Sort(sortOrder, new String[]{sortField}));
            List<MetadataStatusResponse> list = this.buildMetadataStatusResponses(listOfStatus, details, context.getLanguage());
            return list;
        }
    }

    @ApiOperation(value="Get last workflow status for a record", notes="", nickname="getStatus")
    @RequestMapping(value={"/{metadataUuid}/status/workflow/last"}, method={RequestMethod.GET}, produces={"application/json"})
    @PreAuthorize(value="hasRole('Editor')")
    @ApiResponses(value={@ApiResponse(code=200, message="Record status."), @ApiResponse(code=403, message="Operation not allowed. User needs to be able to edit the resource.")})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public MetadataWorkflowStatusResponse getStatus(@ApiParam(value="Record UUID.", required=true) @PathVariable String metadataUuid, HttpServletRequest request) throws Exception {
        Locale locale = this.languageUtils.parseAcceptLanguage(request.getLocales());
        try (ServiceContext context = ApiUtils.createServiceContext(request, locale.getISO3Language());){
            AbstractMetadata metadata = ApiUtils.canEditRecord(metadataUuid, context);
            if (!this.accessManager.isOwner(context, String.valueOf(metadata.getId()))) {
                throw new SecurityException("Only the owner of the metadata can get the status. User is not the owner of the metadata");
            }
            MetadataStatus recordStatus = this.metadataStatus.getStatus(metadata.getId());
            List elStatus = this.statusValueRepository.findAllByType(StatusValueType.workflow);
            HashSet<Integer> ids = new HashSet<Integer>();
            ids.add(metadata.getId());
            List reviewers = this.userRepository.findAllByGroupOwnerNameAndProfile(ids, Profile.Reviewer);
            reviewers.sort(Comparator.comparing(s -> ((User)s.two()).getName()));
            ArrayList<User> listOfReviewers = new ArrayList<User>();
            for (Pair reviewer : reviewers) {
                listOfReviewers.add((User)reviewer.two());
            }
            MetadataWorkflowStatusResponse metadataWorkflowStatusResponse = new MetadataWorkflowStatusResponse(recordStatus, listOfReviewers, this.accessManager.hasEditPermission(context, String.valueOf(metadata.getId())), elStatus);
            return metadataWorkflowStatusResponse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="Set the records status to approved", notes="", nickname="setRecordsStatus")
    @RequestMapping(value={"/approve"}, method={RequestMethod.PUT})
    @PreAuthorize(value="hasRole('Reviewer')")
    @ApiResponses(value={@ApiResponse(code=200, message="Metadata approved ."), @ApiResponse(code=400, message="Metadata workflow not enabled.")})
    @ResponseBody
    MetadataProcessingReport approve(@RequestBody MetadataBatchApproveParameter approveParameter, @ApiIgnore @ApiParam(hidden=true) HttpSession session, @ApiIgnore @ApiParam(hidden=true) HttpServletRequest request) throws Exception {
        ResourceBundle messages = ApiUtils.getMessagesResourceBundle(request.getLocales());
        this.checkWorkflowEnabled();
        Locale locale = this.languageUtils.parseAcceptLanguage(request.getLocales());
        try (SimpleMetadataProcessingReport report = new SimpleMetadataProcessingReport();
             ServiceContext context = ApiUtils.createServiceContext(request, locale.getISO3Language());){
            ArrayList<MetadataPublicationNotificationInfo> metadataListToNotifyPublication = new ArrayList<MetadataPublicationNotificationInfo>();
            boolean notifyByEmail = StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{this.settingManager.getValue("system/metadataprivs/publication/notificationLevel")});
            Set<String> records = ApiUtils.getUuidsParameterOrSelection(approveParameter.getUuids(), approveParameter.getBucket(), ApiUtils.getUserSession(session));
            report.setTotalRecords(records.size());
            ConfigurableApplicationContext appContext = ApplicationContextHolder.get();
            AccessManager accessMan = (AccessManager)appContext.getBean(AccessManager.class);
            ArrayList<String> listOfUpdatedRecords = new ArrayList<String>();
            for (String uuid : records) {
                Metadata metadataApproved;
                AbstractMetadata metadata = this.metadataUtils.findOneByUuid(uuid);
                if (metadata == null) {
                    report.incrementNullRecords();
                    continue;
                }
                if (!accessMan.isOwner(ApiUtils.createServiceContext(request), String.valueOf(metadata.getId()))) {
                    report.addNotEditableMetadataId(metadata.getId());
                    continue;
                }
                if (!this.isAllowedMetadataStatusChange(context, metadata, report)) continue;
                MetadataStatus currentStatus = this.metadataStatus.getStatus(metadata.getId());
                if (currentStatus == null) {
                    report.addMetadataInfos(metadata.getId(), metadata.getUuid(), true, false, "Metadata workflow is not enabled");
                    continue;
                }
                if (!approveParameter.isDirectApproval() && currentStatus.getStatusValue().getId() != Integer.parseInt("4")) {
                    report.addMetadataInfos(metadata.getId(), metadata.getUuid(), this.metadataUtils.isMetadataDraft(metadata.getId()), this.metadataUtils.isMetadataApproved(metadata.getId()), "Metadata is not in submitted status.");
                    continue;
                }
                this.changeMetadataStatus(context, metadata, currentStatus.getCurrentState(), "2", approveParameter.getMessage());
                report.incrementProcessedRecords();
                listOfUpdatedRecords.add(String.valueOf(metadata.getId()));
                if (!notifyByEmail) continue;
                int metadataIdApproved = metadata.getId();
                if (metadata instanceof MetadataDraft && (metadataApproved = this.metadataRepository.findOneByUuid(metadata.getUuid())) != null) {
                    metadataIdApproved = metadataApproved.getId();
                }
                if (currentStatus.getStatusValue().getId() == Integer.parseInt("2") || !this.metadataUtils.isMetadataPublished(metadataIdApproved)) continue;
                MetadataPublicationNotificationInfo metadataNotificationInfo = new MetadataPublicationNotificationInfo();
                metadataNotificationInfo.setMetadataUuid(metadata.getUuid());
                metadataNotificationInfo.setMetadataId(metadataIdApproved);
                metadataNotificationInfo.setGroupId(metadata.getSourceInfo().getGroupOwner());
                metadataNotificationInfo.setPublished(true);
                metadataNotificationInfo.setPublicationDateStamp(new ISODate());
                metadataNotificationInfo.setReapproval(true);
                metadataListToNotifyPublication.add(metadataNotificationInfo);
            }
            this.dataManager.flush();
            this.metadataIndexer.indexMetadata(listOfUpdatedRecords);
            if (notifyByEmail && !metadataListToNotifyPublication.isEmpty()) {
                this.metadataPublicationMailNotifier.notifyPublication(messages, context.getLanguage(), metadataListToNotifyPublication);
            }
        }
        return report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="Set the records status to submitted", notes="", nickname="submit")
    @RequestMapping(value={"/submit"}, method={RequestMethod.PUT})
    @PreAuthorize(value="hasAuthority('Editor')")
    @ApiResponses(value={@ApiResponse(code=200, message="Metadata submitted ."), @ApiResponse(code=400, message="Metadata workflow not enabled.")})
    @ResponseBody
    MetadataProcessingReport submit(@RequestBody MetadataBatchSubmitParameter submitParameter, @ApiParam(hidden=true) HttpSession session, @ApiParam(hidden=true) HttpServletRequest request) throws Exception {
        ServiceContext context = ApiUtils.createServiceContext(request, this.languageUtils.getIso3langCode(request.getLocales()));
        this.checkWorkflowEnabled();
        try (SimpleMetadataProcessingReport report = new SimpleMetadataProcessingReport();){
            Set<String> records = ApiUtils.getUuidsParameterOrSelection(submitParameter.getUuids(), submitParameter.getBucket(), ApiUtils.getUserSession(session));
            report.setTotalRecords(records.size());
            ArrayList<String> listOfUpdatedRecords = new ArrayList<String>();
            for (String uuid : records) {
                Metadata metadataApproved;
                AbstractMetadata metadata = this.metadataUtils.findOneByUuid(uuid);
                if (metadata == null) {
                    report.incrementNullRecords();
                    continue;
                }
                if (!this.accessManager.isOwner(ApiUtils.createServiceContext(request), String.valueOf(metadata.getId()))) {
                    report.addNotEditableMetadataId(metadata.getId());
                    continue;
                }
                if (!this.isAllowedMetadataStatusChange(context, metadata, report)) continue;
                MetadataStatus currentStatus = this.metadataStatus.getStatus(metadata.getId());
                if (currentStatus == null) {
                    report.addMetadataInfos(metadata.getId(), metadata.getUuid(), true, false, "Metadata workflow is not enabled");
                    continue;
                }
                if (currentStatus.getStatusValue().getId() != Integer.parseInt("1")) {
                    report.addMetadataInfos(metadata.getId(), metadata.getUuid(), this.metadataUtils.isMetadataDraft(metadata.getId()), this.metadataUtils.isMetadataApproved(metadata.getId()), "Metadata is not in draft status.");
                    continue;
                }
                this.changeMetadataStatus(context, metadata, currentStatus.getCurrentState(), "4", submitParameter.getMessage());
                if (metadata instanceof MetadataDraft && (metadataApproved = this.metadataRepository.findOneByUuid(metadata.getUuid())) != null) {
                    listOfUpdatedRecords.add(String.valueOf(metadataApproved.getId()));
                }
                report.incrementProcessedRecords();
                listOfUpdatedRecords.add(String.valueOf(metadata.getId()));
            }
            this.dataManager.flush();
            this.metadataIndexer.indexMetadata(listOfUpdatedRecords);
        }
        return report;
    }

    @ApiOperation(value="Set the record status", notes="", nickname="setStatus")
    @RequestMapping(value={"/{metadataUuid}/status"}, method={RequestMethod.PUT})
    @PreAuthorize(value="hasRole('Editor')")
    @ApiResponses(value={@ApiResponse(code=204, message="Status updated."), @ApiResponse(code=400, message="Metadata workflow not enabled."), @ApiResponse(code=403, message="Operation not allowed. User needs to be able to edit the resource.")})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void setStatus(@ApiParam(value="Record UUID.", required=true) @PathVariable String metadataUuid, @ApiParam(value="Metadata status", required=true) @RequestBody(required=true) MetadataStatusParameter status, HttpServletRequest request) throws Exception {
        try (ServiceContext context = ApiUtils.createServiceContext(request, this.languageUtils.iso3code(request.getLocales()));){
            Metadata metadataApproved;
            boolean isInvalid;
            AbstractMetadata metadata = ApiUtils.canEditRecord(metadataUuid, context);
            boolean isMdWorkflowEnable = this.settingManager.getValueAsBool("metadata/workflow/enable");
            ArrayList<MetadataPublicationNotificationInfo> metadataListToNotifyPublication = new ArrayList<MetadataPublicationNotificationInfo>();
            boolean notifyByEmail = StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{this.settingManager.getValue("system/metadataprivs/publication/notificationLevel")});
            ResourceBundle messages = ApiUtils.getMessagesResourceBundle(request.getLocales());
            int author = context.getUserSession().getUserIdAsInt();
            MetadataStatus metadataStatusValue = this.convertParameter(metadata.getId(), metadata.getUuid(), status, author);
            if (metadataStatusValue.getStatusValue().getType() == StatusValueType.workflow && !isMdWorkflowEnable) {
                throw new FeatureNotEnabledException("Metadata workflow is disabled, can not be set the status of metadata").withMessageKey("exception.resourceNotEnabled.workflow").withDescriptionKey("exception.resourceNotEnabled.workflow.description");
            }
            if (!this.accessManager.isOwner(context, String.valueOf(metadata.getId()))) {
                throw new SecurityException("Only the owner of the metadata can set the status of this record. User is not the owner of the metadata.");
            }
            boolean isAllowedSubmitApproveInvalidMd = this.settingManager.getValueAsBool("metadata/workflow/allowSumitApproveInvalidMd");
            if ((status.getStatus() == Integer.parseInt("4") || status.getStatus() == Integer.parseInt("2")) && !isAllowedSubmitApproveInvalidMd && (isInvalid = MetadataUtils.retrieveMetadataValidationStatus(metadata, context))) {
                throw new NotAllowedException("Metadata is invalid: can't be submitted or approved").withMessageKey("exception.resourceInvalid.metadata").withDescriptionKey("exception.resourceInvalid.metadata.description");
            }
            StatusActions sa = this.statusActionFactory.createStatusActions(context);
            String metadataCurrentStatus = this.dataManager.getCurrentStatus(metadata.getId());
            metadataStatusValue.setPreviousState(metadataCurrentStatus);
            ArrayList<MetadataStatus> listOfStatusChange = new ArrayList<MetadataStatus>(1);
            listOfStatusChange.add(metadataStatusValue);
            sa.onStatusChange(listOfStatusChange, false);
            int metadataIdApproved = metadata.getId();
            this.metadataIndexer.indexMetadata(String.valueOf(metadata.getId()), true, null);
            if (metadata instanceof MetadataDraft && (metadataApproved = this.metadataRepository.findOneByUuid(metadata.getUuid())) != null) {
                metadataIdApproved = metadataApproved.getId();
                this.metadataIndexer.indexMetadata(String.valueOf(metadataApproved.getId()), true, null);
            }
            if (status.getStatus() == Integer.parseInt("2") && notifyByEmail && this.metadataUtils.isMetadataPublished(metadataIdApproved)) {
                MetadataPublicationNotificationInfo metadataNotificationInfo = new MetadataPublicationNotificationInfo();
                metadataNotificationInfo.setMetadataUuid(metadata.getUuid());
                metadataNotificationInfo.setMetadataId(metadataIdApproved);
                metadataNotificationInfo.setGroupId(metadata.getSourceInfo().getGroupOwner());
                metadataNotificationInfo.setPublished(true);
                metadataNotificationInfo.setPublicationDateStamp(new ISODate());
                metadataNotificationInfo.setReapproval(metadataIdApproved != metadata.getId());
                metadataListToNotifyPublication.add(metadataNotificationInfo);
                this.metadataPublicationMailNotifier.notifyPublication(messages, context.getLanguage(), metadataListToNotifyPublication);
            }
        }
    }

    @ApiOperation(value="Close a record task", notes="", nickname="closeTask")
    @RequestMapping(value={"/{metadataUuid}/status/{statusId:[0-9]+}.{userId:[0-9]+}.{changeDate}/close"}, method={RequestMethod.PUT})
    @PreAuthorize(value="hasRole('Editor')")
    @ApiResponses(value={@ApiResponse(code=204, message="Task closed."), @ApiResponse(code=404, message="Status not found."), @ApiResponse(code=403, message="Operation not allowed. User needs to be able to edit the resource.")})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void closeTask(@ApiParam(value="Record UUID.", required=true) @PathVariable String metadataUuid, @ApiParam(value="Status identifier", required=true) @PathVariable int statusId, @ApiParam(value="User identifier", required=true) @PathVariable int userId, @ApiParam(value="Change date", required=true) @PathVariable String changeDate, @ApiParam(value="Close date", required=true) @RequestParam String closeDate, HttpServletRequest request) throws Exception {
        AbstractMetadata metadata = ApiUtils.canEditRecord(metadataUuid, request);
        MetadataStatus metadataStatusValue = this.metadataStatusRepository.findOneByMetadataIdAndStatusValue_IdAndUserIdAndChangeDate(metadata.getId(), statusId, userId, new ISODate(changeDate));
        if (metadataStatusValue == null) {
            throw new ResourceNotFoundException(String.format("Can't find metadata status for record '%s', user '%d' at date '%s'", metadataUuid, userId, changeDate));
        }
        this.metadataStatusRepository.update((Serializable)Integer.valueOf(metadataStatusValue.getId()), entity -> entity.setCloseDate(new ISODate(closeDate)));
    }

    @ApiOperation(value="Delete a record status", notes="", nickname="deleteStatus")
    @RequestMapping(value={"/{metadataUuid}/status/{statusId:[0-9]+}.{userId:[0-9]+}.{changeDate}"}, method={RequestMethod.DELETE})
    @PreAuthorize(value="hasRole('Administrator')")
    @ApiResponses(value={@ApiResponse(code=204, message="Status removed."), @ApiResponse(code=404, message="Status not found."), @ApiResponse(code=403, message="Operation not allowed. Only Administrators can access it.")})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteRecordStatus(@ApiParam(value="Record UUID.", required=true) @PathVariable String metadataUuid, @ApiParam(value="Status identifier", required=true) @PathVariable int statusId, @ApiParam(value="User identifier", required=true) @PathVariable int userId, @ApiParam(value="Change date", required=true) @PathVariable String changeDate, HttpServletRequest request) throws Exception {
        AbstractMetadata metadata = ApiUtils.canEditRecord(metadataUuid, request);
        MetadataStatus metadataStatusValue = this.metadataStatusRepository.findOneByMetadataIdAndStatusValue_IdAndUserIdAndChangeDate(metadata.getId(), statusId, userId, new ISODate(changeDate));
        if (metadataStatusValue == null) {
            throw new ResourceNotFoundException(String.format("Can't find metadata status for record '%s', user '%d' at date '%s'", metadataUuid, userId, changeDate));
        }
        this.metadataStatusRepository.delete((Object)metadataStatusValue);
    }

    @ApiOperation(value="Delete all record status", notes="", nickname="deleteAllRecordStatus")
    @RequestMapping(value={"/{metadataUuid}/status"}, method={RequestMethod.DELETE})
    @PreAuthorize(value="hasRole('Administrator')")
    @ApiResponses(value={@ApiResponse(code=204, message="Status removed."), @ApiResponse(code=404, message="Status not found."), @ApiResponse(code=403, message="Operation not allowed. Only Administrators can access it.")})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteAllRecordStatus(@ApiParam(value="Record UUID.", required=true) @PathVariable String metadataUuid, HttpServletRequest request) throws Exception {
        AbstractMetadata metadata = ApiUtils.canEditRecord(metadataUuid, request);
        this.metadataStatusRepository.deleteAllById_MetadataId(Integer.valueOf(metadata.getId()));
    }

    /*
     * WARNING - void declaration
     */
    @ApiOperation(value="Search status", notes="", nickname="searchStatusByType")
    @RequestMapping(produces={"application/json"}, method={RequestMethod.GET}, path={"/status/search"})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasAuthority('Editor')")
    @ResponseBody
    public List<MetadataStatusResponse> getStatusByType(@ApiParam(value="One or more types to retrieve (ie. worflow, event, task). Default is all.", required=false) @RequestParam(required=false) List<StatusValueType> type, @ApiParam(value="All event details including XML changes. Responses are bigger. Default is false", required=false) @RequestParam(required=false) boolean details, @ApiParam(value="Sort Order (ie. DESC or ASC). Default is none.", required=false) @RequestParam(required=false) Sort.Direction sortOrder, @ApiParam(value="One or more event author. Default is all.", required=false) @RequestParam(required=false) List<Integer> author, @ApiParam(value="One or more event owners. Default is all.", required=false) @RequestParam(required=false) List<Integer> owner, @ApiParam(value="One or more record identifier. Default is all.", required=false) @RequestParam(required=false) List<Integer> id, @ApiParam(value="One or more metadata record identifier. Default is all.", required=false) @RequestParam(required=false) List<Integer> recordIdentifier, @ApiParam(value="One or more metadata uuid. Default is all.", required=false) @RequestParam(required=false) List<String> uuid, @ApiParam(value="One or more status id. Default is all.", required=false) @RequestParam(required=false) List<String> statusIds, @ApiParam(value="Start date", required=false) @RequestParam(required=false) String dateFrom, @ApiParam(value="End date", required=false) @RequestParam(required=false) String dateTo, @ApiParam(value="From page", required=false) @RequestParam(required=false, defaultValue="0") Integer from, @ApiParam(value="Number of records to return", required=false) @RequestParam(required=false, defaultValue="100") Integer size, HttpServletRequest request) throws Exception {
        try (ServiceContext context = ApiUtils.createServiceContext(request);){
            void var19_28;
            PageRequest pageRequest;
            Profile profile = context.getUserSession().getProfile();
            if (profile != Profile.Administrator) {
                if (CollectionUtils.isEmpty(recordIdentifier) && CollectionUtils.isEmpty(uuid)) {
                    throw new NotAllowedException("Non administrator user must use a id or uuid parameter to search for status.");
                }
                if (!CollectionUtils.isEmpty(recordIdentifier)) {
                    for (Integer n : recordIdentifier) {
                        try {
                            ApiUtils.canEditRecord(String.valueOf(n), request);
                        }
                        catch (SecurityException e) {
                            throw new NotAllowedException("Operation not allowed. User needs to be able to edit the resource.");
                        }
                    }
                }
                if (!CollectionUtils.isEmpty(uuid)) {
                    for (String string : uuid) {
                        try {
                            ApiUtils.canEditRecord(string, request);
                        }
                        catch (SecurityException e) {
                            throw new NotAllowedException("Operation not allowed. User needs to be able to edit the resource.");
                        }
                    }
                }
            }
            if (sortOrder != null) {
                Sort sort = SortUtils.createSort((Sort.Direction)sortOrder, (SingularAttribute[])new SingularAttribute[]{MetadataStatus_.changeDate}).and(SortUtils.createSort((Sort.Direction)sortOrder, (SingularAttribute[])new SingularAttribute[]{MetadataStatus_.id}));
                pageRequest = new PageRequest(from.intValue(), size.intValue(), sort);
            } else {
                Sort sort = SortUtils.createSort((Sort.Direction)Sort.Direction.DESC, (SingularAttribute[])new SingularAttribute[]{MetadataStatus_.changeDate}).and(SortUtils.createSort((Sort.Direction)Sort.Direction.DESC, (SingularAttribute[])new SingularAttribute[]{MetadataStatus_.id}));
                pageRequest = new PageRequest(from.intValue(), size.intValue(), sort);
            }
            if (CollectionUtils.isNotEmpty(id) || CollectionUtils.isNotEmpty(uuid) || CollectionUtils.isNotEmpty(type) || CollectionUtils.isNotEmpty(author) || CollectionUtils.isNotEmpty(owner) || CollectionUtils.isNotEmpty(recordIdentifier) || CollectionUtils.isNotEmpty(statusIds)) {
                List list = this.metadataStatusRepository.searchStatus(id, uuid, type, author, owner, recordIdentifier, statusIds, dateFrom, dateTo, (Pageable)pageRequest);
            } else {
                List list = this.metadataStatusRepository.findAll((Pageable)pageRequest).getContent();
            }
            List<MetadataStatusResponse> list = this.buildMetadataStatusResponses((List<MetadataStatus>)var19_28, details, context.getLanguage());
            return list;
        }
    }

    private MetadataStatus convertParameter(int id, String uuid, MetadataStatusParameter parameter, int author) throws Exception {
        StatusValue statusValue = (StatusValue)this.statusValueRepository.findOne((Serializable)Integer.valueOf(parameter.getStatus()));
        MetadataStatus metadataStatusValue = new MetadataStatus();
        metadataStatusValue.setMetadataId(id);
        metadataStatusValue.setUuid(uuid);
        metadataStatusValue.setChangeDate(new ISODate());
        metadataStatusValue.setUserId(author);
        metadataStatusValue.setStatusValue(statusValue);
        if (parameter.getChangeMessage() != null) {
            metadataStatusValue.setChangeMessage(parameter.getChangeMessage());
        }
        if (StringUtils.isNotEmpty((CharSequence)parameter.getDueDate())) {
            metadataStatusValue.setDueDate(new ISODate(parameter.getDueDate()));
        }
        if (StringUtils.isNotEmpty((CharSequence)parameter.getCloseDate())) {
            metadataStatusValue.setCloseDate(new ISODate(parameter.getCloseDate()));
        }
        if (parameter.getOwner() != null) {
            metadataStatusValue.setOwner(parameter.getOwner());
        }
        return metadataStatusValue;
    }

    @ApiOperation(value="Get saved content from the status record before changes", notes="", nickname="showStatusBefore")
    @RequestMapping(value={"/{metadataUuid}/status/{statusId:[0-9]+}.{userId:[0-9]+}.{changeDate}/before"}, method={RequestMethod.GET}, produces={"application/xml"})
    @PreAuthorize(value="hasRole('Editor')")
    @ApiResponses(value={@ApiResponse(code=200, message="Previous version of the record."), @ApiResponse(code=403, message="Operation not allowed. User needs to be able to edit the resource.")})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public String showStatusBefore(@ApiParam(value="Record UUID.", required=true) @PathVariable String metadataUuid, @ApiParam(value="Status identifier", required=true) @PathVariable int statusId, @ApiParam(value="User identifier", required=true) @PathVariable int userId, @ApiParam(value="Change date", required=true) @PathVariable String changeDate, @ApiIgnore @ApiParam(hidden=true) HttpSession httpSession, HttpServletRequest request) throws Exception {
        MetadataStatus metadataStatusValue = this.getMetadataStatus(metadataUuid, statusId, userId, changeDate);
        return this.getValidatedStateText(metadataStatusValue, State.BEFORE, request, httpSession);
    }

    @ApiOperation(value="Get saved content from the status record after changes", notes="", nickname="showStatusAfter")
    @RequestMapping(value={"/{metadataUuid}/status/{statusId:[0-9]+}.{userId:[0-9]+}.{changeDate}/after"}, method={RequestMethod.GET}, produces={"application/xml"})
    @PreAuthorize(value="hasRole('Editor')")
    @ApiResponses(value={@ApiResponse(code=200, message="Version of the record after changes."), @ApiResponse(code=403, message="Operation not allowed. User needs to be able to edit the resource.")})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public String showStatusAfter(@ApiParam(value="Record UUID.", required=true) @PathVariable String metadataUuid, @ApiParam(value="Status identifier", required=true) @PathVariable int statusId, @ApiParam(value="User identifier", required=true) @PathVariable int userId, @ApiParam(value="Change date", required=true) @PathVariable String changeDate, @ApiIgnore @ApiParam(hidden=true) HttpSession httpSession, HttpServletRequest request) throws Exception {
        MetadataStatus metadataStatusValue = this.getMetadataStatus(metadataUuid, statusId, userId, changeDate);
        return this.getValidatedStateText(metadataStatusValue, State.AFTER, request, httpSession);
    }

    @ApiOperation(value="Restore saved content from a status record", notes="", nickname="restoreAtStatusSave")
    @RequestMapping(value={"/{metadataUuid}/status/{statusId:[0-9]+}.{userId:[0-9]+}.{changeDate}/restore"}, method={RequestMethod.POST})
    @PreAuthorize(value="hasRole('Editor')")
    @ApiResponses(value={@ApiResponse(code=200, message="Record restored."), @ApiResponse(code=403, message="Operation not allowed. User needs to be able to edit the resource.")})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public void restoreAtStatusSave(@ApiParam(value="Record UUID.", required=true) @PathVariable String metadataUuid, @ApiParam(value="Status identifier", required=true) @PathVariable int statusId, @ApiParam(value="User identifier", required=true) @PathVariable int userId, @ApiParam(value="Change date", required=true) @PathVariable String changeDate, @ApiIgnore @ApiParam(hidden=true) HttpSession httpSession, HttpServletRequest request) throws Exception {
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        MetadataStatus metadataStatusValue = this.getMetadataStatus(metadataUuid, statusId, userId, changeDate);
        String previousStateText = this.getValidatedStateText(metadataStatusValue, State.BEFORE, request, httpSession);
        Locale locale = this.languageUtils.parseAcceptLanguage(request.getLocales());
        try (ServiceContext context = ApiUtils.createServiceContext(request, locale.getISO3Language());){
            AbstractMetadata metadata;
            try {
                metadata = ApiUtils.canEditRecord(metadataStatusValue.getUuid(), request);
            }
            catch (ResourceNotFoundException e) {
                metadata = null;
            }
            Element beforeMetadata = null;
            String xmlBefore = null;
            if (metadata != null) {
                beforeMetadata = this.dataManager.getMetadata(context, String.valueOf(metadata.getId()), false, false, false);
                XMLOutputter outp = new XMLOutputter();
                if (beforeMetadata != null) {
                    xmlBefore = outp.outputString(beforeMetadata);
                }
                if (xmlBefore.equals(previousStateText)) {
                    throw new NotAllowedException("Error recovering metadata id " + metadataUuid + ". Cannot recover record which are identical. Possibly already recovered.");
                }
            }
            Integer recoveredMetadataId = null;
            if (metadata != null) {
                Element md = Xml.loadString((String)previousStateText, (boolean)false);
                Element mdNoGeonetInfo = this.metadataUtils.removeMetadataInfo(md);
                this.metadataManager.updateMetadata(context, String.valueOf(metadata.getId()), mdNoGeonetInfo, false, true, true, context.getLanguage(), null, false);
                recoveredMetadataId = metadata.getId();
            } else {
                Element element = null;
                try {
                    element = Xml.loadString((String)previousStateText, (boolean)false);
                }
                catch (JDOMParseException ex) {
                    throw new IllegalArgumentException(String.format("XML fragment is invalid. Error is %s", ex.getMessage()));
                }
                recoveredMetadataId = this.reloadRecord(element, httpSession, request);
            }
            this.metadataIndexer.indexMetadata(String.valueOf(recoveredMetadataId), true, null);
            UserSession session = ApiUtils.getUserSession(request.getSession());
            if (session != null) {
                Element afterMetadata = this.dataManager.getMetadata(context, String.valueOf(recoveredMetadataId), false, false, false);
                XMLOutputter outp = new XMLOutputter();
                String xmlAfter = outp.outputString(afterMetadata);
                new RecordRestoredEvent(recoveredMetadataId, metadataStatusValue.getUuid(), Integer.valueOf(session.getUserIdAsInt()), xmlBefore, xmlAfter, metadataStatusValue).publish((ApplicationContext)applicationContext);
            }
        }
    }

    private List<MetadataStatusResponse> buildMetadataStatusResponses(List<MetadataStatus> listOfStatus, boolean details, String language) {
        ArrayList<MetadataStatusResponse> response = new ArrayList<MetadataStatusResponse>();
        HashMap<Integer, Object> listOfUsers = new HashMap<Integer, Object>();
        for (MetadataStatus s : listOfStatus) {
            if (listOfUsers.get(s.getUserId()) == null) {
                listOfUsers.put(s.getUserId(), this.userRepository.findOne((Serializable)Integer.valueOf(s.getUserId())));
            }
            if (s.getOwner() == null || listOfUsers.get(s.getOwner()) != null) continue;
            listOfUsers.put(s.getOwner(), this.userRepository.findOne((Serializable)s.getOwner()));
        }
        HashMap<Integer, String> titles = new HashMap<Integer, String>();
        for (MetadataStatus s : listOfStatus) {
            User owner;
            MetadataStatusResponse status = new MetadataStatusResponse(s, details);
            User author = (User)listOfUsers.get(status.getUserId());
            if (author != null) {
                status.setAuthorName(author.getName() + " " + author.getSurname());
                status.setAuthorEmail(author.getEmail());
            }
            if (s.getOwner() != null && (owner = (User)listOfUsers.get(status.getOwner())) != null) {
                status.setOwnerName(owner.getName() + " " + owner.getSurname());
                status.setOwnerEmail(owner.getEmail());
            }
            status.setDateChange(s.getChangeDate().getDateAndTime());
            if (s.getStatusValue().getType().equals((Object)StatusValueType.event)) {
                status.setCurrentStatus(this.extractCurrentStatus(s));
                status.setPreviousStatus(this.extractPreviousStatus(s));
            } else if (s.getStatusValue().getType().equals((Object)StatusValueType.task)) {
                if (s.getDueDate() != null) {
                    status.setDateDue(s.getDueDate().getDateAndTime());
                }
                if (s.getCloseDate() != null) {
                    status.setDateClose(s.getCloseDate().getDateAndTime());
                }
            }
            if (s.getTitles() != null && s.getTitles().size() > 0) {
                status.setTitle((String)s.getTitles().getOrDefault(language, s.getTitles().getOrDefault(language.substring(0, 2), s.getTitles().entrySet().iterator().next().getValue())));
            }
            if (status.getTitle() == null || status.getTitle().length() == 0) {
                String title = (String)titles.get(s.getMetadataId());
                if (title == null) {
                    try {
                        title = LuceneSearcher.getMetadataFromIndexById((String)language, (String)(s.getMetadataId() + ""), (String)"title");
                        titles.put(s.getMetadataId(), title);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                status.setTitle(title);
            }
            status.setUuid(s.getUuid());
            response.add(status);
        }
        return response;
    }

    private String extractCurrentStatus(MetadataStatus s) {
        switch (Integer.toString(s.getStatusValue().getId())) {
            case "52": {
                return s.getCurrentState();
            }
            case "54": {
                return ObjectJSONUtils.extractFieldFromJSONString((String)s.getCurrentState(), (String)"owner", (String)"name");
            }
            case "55": {
                return ObjectJSONUtils.extractFieldFromJSONString((String)s.getCurrentState(), (String)"owner", (String)"name");
            }
            case "60": {
                return ObjectJSONUtils.extractFieldFromJSONString((String)s.getCurrentState(), (String)"process");
            }
            case "57": {
                List categories = ObjectJSONUtils.extractListOfFieldFromJSONString((String)s.getCurrentState(), (String)"category", (String)"name");
                StringBuffer categoriesAsString = new StringBuffer("[ ");
                for (String categoryName : categories) {
                    categoriesAsString.append(categoryName + " ");
                }
                categoriesAsString.append("]");
                return categoriesAsString.toString();
            }
            case "58": {
                return s.getCurrentState().equals("1") ? "OK" : "KO";
            }
        }
        return "";
    }

    private String extractPreviousStatus(MetadataStatus s) {
        switch (Integer.toString(s.getStatusValue().getId())) {
            case "53": {
                return s.getPreviousState();
            }
            case "54": {
                return ObjectJSONUtils.extractFieldFromJSONString((String)s.getPreviousState(), (String)"owner", (String)"name");
            }
            case "55": {
                return ObjectJSONUtils.extractFieldFromJSONString((String)s.getPreviousState(), (String)"owner", (String)"name");
            }
        }
        return "";
    }

    private void checkCanViewStatus(String metadata, HttpSession httpSession) throws Exception {
        UserSession userSession;
        Group groupEntity;
        Element xmlElement = null;
        try {
            xmlElement = Xml.loadString((String)metadata, (boolean)false);
        }
        catch (JDOMParseException ex) {
            throw new IllegalArgumentException(String.format("XML fragment is invalid. Error is %s", ex.getMessage()));
        }
        Element info = xmlElement.getChild("info", Edit.NAMESPACE);
        if (info == null) {
            throw new IllegalArgumentException("Can't locate required geonet:info which is required for the recovery. May need to manually re-import the data");
        }
        String groupOwnerName = info.getChildText("groupOwnerName");
        String groupId = null;
        if (groupOwnerName != null && (groupEntity = this.groupRepository.findByName(groupOwnerName)) != null) {
            groupId = String.valueOf(groupEntity.getId());
        }
        if ((userSession = ApiUtils.getUserSession(httpSession)).getProfile() != Profile.Administrator) {
            if (groupId != null) {
                List editingGroupList = AccessManager.getGroups((UserSession)userSession, (Profile)Profile.Editor);
                if (!editingGroupList.contains(Integer.valueOf(groupId))) {
                    throw new SecurityException(String.format("You can't view history from this group (%s). User MUST be an Editor in that group", groupOwnerName));
                }
            } else {
                throw new SecurityException(String.format("Error identify group where this metadata belong to. Only administrator can view this record", new Object[0]));
            }
        }
    }

    private int reloadRecord(Element md, HttpSession httpSession, HttpServletRequest request) throws Exception {
        List editingGroupList;
        UserSession userSession;
        Group groupEntity;
        Element info = md.getChild("info", Edit.NAMESPACE);
        if (info == null) {
            throw new IllegalArgumentException("Can't location geonet:info which is required for the recovery. May need to manually re-import the data");
        }
        md = this.metadataUtils.removeMetadataInfo(md);
        String groupOwnerName = info.getChildText("groupOwnerName");
        String groupId = null;
        if (groupOwnerName != null && (groupEntity = this.groupRepository.findByName(groupOwnerName)) != null) {
            groupId = String.valueOf(groupEntity.getId());
        }
        if ((userSession = ApiUtils.getUserSession(httpSession)).getProfile() != Profile.Administrator && groupId != null && !(editingGroupList = AccessManager.getGroups((UserSession)userSession, (Profile)Profile.Editor)).contains(Integer.valueOf(groupId))) {
            throw new SecurityException(String.format("You can't create a record in this group (%s). User MUST be an Editor in that group", groupOwnerName));
        }
        try (ServiceContext context = ApiUtils.createServiceContext(request);){
            String uuid;
            String schema = info.getChildText("schema");
            if (schema == null) {
                try {
                    schema = this.dataManager.autodetectSchema(md);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Can't detect schema for metadata automatically. You could try to force the schema with the schema parameter.");
                }
            }
            if ((uuid = info.getChildText("uuid")) == null && (uuid = this.metadataUtils.extractUUID(schema, md)).length() == 0) {
                throw new IllegalArgumentException("Could not locate the UUID for the document being restored.");
            }
            if (this.metadataRepository.findOneByUuid(uuid) != null) {
                throw new IllegalArgumentException(String.format("A record with UUID '%s' already exist", uuid));
            }
            String date = new ISODate().toString();
            boolean ufo = false;
            boolean indexImmediate = false;
            String metadataId = this.metadataManager.insertMetadata(context, schema, md, uuid, context.getUserSession().getUserIdAsInt(), groupId, this.settingManager.getSiteId(), MetadataType.METADATA.codeString, null, null, date, date, ufo, indexImmediate);
            int id = Integer.parseInt(metadataId);
            List categoryList = info.getChildren("category");
            if (categoryList != null && !categoryList.isEmpty()) {
                for (Element cat : categoryList) {
                    String catName = cat.getText();
                    MetadataCategory metadataCategory = this.categoryRepository.findOneByName(catName);
                    if (metadataCategory == null) continue;
                    this.dataManager.setCategory(context, metadataId, String.valueOf(metadataCategory.getId()));
                }
            }
            int n = id;
            return n;
        }
    }

    private MetadataStatus getMetadataStatus(String uuidOrInternalId, int statusId, int userId, String changeDate) throws ResourceNotFoundException {
        MetadataStatus metadataStatusValue = uuidOrInternalId.matches("\\d+") ? this.metadataStatusRepository.findOneByMetadataIdAndStatusValue_IdAndUserIdAndChangeDate(Integer.valueOf(uuidOrInternalId).intValue(), statusId, userId, new ISODate(changeDate)) : this.metadataStatusRepository.findOneByUuidAndStatusValue_IdAndUserIdAndChangeDate(uuidOrInternalId, statusId, userId, new ISODate(changeDate));
        if (metadataStatusValue == null) {
            throw new ResourceNotFoundException(String.format("Can't find metadata status for record '%s', user '%d', status, '%d' at date '%s'", uuidOrInternalId, userId, statusId, changeDate));
        }
        return metadataStatusValue;
    }

    private String getValidatedStateText(MetadataStatus metadataStatus, State state, HttpServletRequest request, HttpSession httpSession) throws Exception {
        if (!StatusValueType.event.equals((Object)metadataStatus.getStatusValue().getType()) || !ArrayUtils.contains((Object[])supportedRestoreStatuses, (Object)metadataStatus.getStatusValue().getId())) {
            throw new NotAllowedException("Unsupported action on status type '" + metadataStatus.getStatusValue().getType() + "' for metadata '" + metadataStatus.getUuid() + "'. Supports status type '" + StatusValueType.event + "' with the status id '" + Arrays.toString((Object[])supportedRestoreStatuses) + "'.");
        }
        String stateText = state.equals((Object)State.AFTER) ? metadataStatus.getCurrentState() : metadataStatus.getPreviousState();
        if (stateText == null) {
            throw new ResourceNotFoundException(String.format("No data exists for previous state on metadata record '%s', user '%d' at date '%s'", metadataStatus.getUuid(), metadataStatus.getUserId(), metadataStatus.getChangeDate()));
        }
        try {
            ApiUtils.canEditRecord(metadataStatus.getUuid(), request);
        }
        catch (SecurityException e) {
            Log.debug((String)"geonetwork.api", (Object)e.getMessage(), (Exception)e);
            throw new NotAllowedException("Operation not allowed. User needs to be able to view the resource.");
        }
        catch (ResourceNotFoundException e) {
            this.checkCanViewStatus(stateText, httpSession);
        }
        return stateText;
    }

    private void checkWorkflowEnabled() throws FeatureNotEnabledException {
        boolean isMdWorkflowEnable = this.settingManager.getValueAsBool("metadata/workflow/enable");
        if (!isMdWorkflowEnable) {
            throw new FeatureNotEnabledException("Metadata workflow is disabled, can not be set the status of metadata").withMessageKey("exception.resourceNotEnabled.workflow").withDescriptionKey("exception.resourceNotEnabled.workflow.description");
        }
    }

    private boolean isAllowedMetadataStatusChange(ServiceContext context, AbstractMetadata metadata, MetadataProcessingReport report) throws Exception {
        boolean isInvalid;
        boolean isAllowedSubmitApproveInvalidMd = this.settingManager.getValueAsBool("metadata/workflow/allowSumitApproveInvalidMd");
        if (!isAllowedSubmitApproveInvalidMd && (isInvalid = MetadataUtils.retrieveMetadataValidationStatus(metadata, context))) {
            report.addMetadataInfos(metadata.getId(), metadata.getUuid(), true, false, "Metadata is invalid: can't be approved");
            return false;
        }
        return true;
    }

    private void changeMetadataStatus(ServiceContext context, AbstractMetadata metadata, String previousStatus, String newStatus, String changeMessage) throws Exception {
        StatusActions sa = this.statusActionFactory.createStatusActions(context);
        MetadataStatusParameter status = new MetadataStatusParameter();
        status.setStatus(Integer.parseInt(newStatus));
        status.setChangeMessage(changeMessage);
        int author = context.getUserSession().getUserIdAsInt();
        MetadataStatus metadataStatusValue = this.convertParameter(metadata.getId(), metadata.getUuid(), status, author);
        metadataStatusValue.setPreviousState(previousStatus);
        ArrayList<MetadataStatus> listOfStatusChange = new ArrayList<MetadataStatus>(1);
        listOfStatusChange.add(metadataStatusValue);
        sa.onStatusChange(listOfStatusChange, true);
    }

    private static enum State {
        BEFORE,
        AFTER;

    }
}

