/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.pages;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jeeves.server.UserSession;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.exception.ResourceAlreadyExistException;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.api.exception.WebApplicationException;
import org.fao.geonet.api.pages.PageJSONWrapper;
import org.fao.geonet.api.tools.i18n.LanguageUtils;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.domain.page.Page;
import org.fao.geonet.domain.page.PageIdentity;
import org.fao.geonet.repository.page.PageRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.web.util.UrlUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.multipart.MultipartFile;
import springfox.documentation.annotations.ApiIgnore;

@RequestMapping(value={"/{portal}/api/pages", "/{portal}/api/0.1/pages"})
@Api(value="pages", tags={"pages"}, description="Static pages inside GeoNetwork")
@Controller(value="pages")
public class PagesAPI {
    @Autowired
    private PageRepository pageRepository;
    @Autowired
    private LanguageUtils languageUtils;
    private static final String PAGE_OK = "Page found";
    private static final String PAGE_NOT_FOUND = "Page not found";
    private static final String PAGE_DUPLICATE = "Page already in the system: use PUT";
    private static final String PAGE_SAVED = "Page saved";
    private static final String PAGE_UPDATED = "Page changes saved";
    private static final String PAGE_DELETED = "Page removed";
    private static final String ERROR_FILE = "File not valid";
    private static final String ERROR_CREATE = "Wrong parameters are provided";

    @ApiOperation(value="Add a new Page object in DRAFT section in status HIDDEN", notes="<p>Is not possible to load a link and a file at the same time.</p> <a href='http://geonetwork-opensource.org/manuals/trunk/eng/users/user-guide/define-static-pages/define-pages.html'>More info</a>", nickname="addPage")
    @RequestMapping(value={"/"}, method={RequestMethod.POST})
    @ApiResponses(value={@ApiResponse(code=200, message="Page saved"), @ApiResponse(code=404, message="Page not found"), @ApiResponse(code=400, message="Wrong parameters are provided"), @ApiResponse(code=409, message="Page already in the system: use PUT"), @ApiResponse(code=403, message="Operation not allowed. User needs to be able to edit the resource."), @ApiResponse(code=500, message="File not valid")})
    @PreAuthorize(value="hasRole('Administrator')")
    public void addPage(@RequestParam(value="language", required=true) String language, @RequestParam(value="pageId", required=true) String pageId, @RequestParam(value="data", required=false) MultipartFile data, @RequestParam(value="link", required=false) String link, @RequestParam(value="format", required=true) Page.PageFormat format, @ApiIgnore HttpServletResponse response) throws ResourceAlreadyExistException {
        this.checkValidLanguage(language);
        this.checkMandatoryContent(data, link);
        this.checkUniqueContent(data, link);
        this.checkCorrectFormat(data, link, format);
        if (this.pageRepository.findOne((Serializable)new PageIdentity(language, pageId)) != null) {
            throw new ResourceAlreadyExistException();
        }
        Page page = this.getEmptyHiddenDraftPage(language, pageId, format);
        this.fillContent(data, link, page);
        this.pageRepository.save((Object)page);
    }

    @ApiOperation(value="Edit a Page content and format", notes="<a href='http://geonetwork-opensource.org/manuals/trunk/eng/users/user-guide/define-static-pages/define-pages.html'>More info</a>", nickname="editPage")
    @RequestMapping(value={"/{language}/{pageId}"}, method={RequestMethod.POST})
    @ApiResponses(value={@ApiResponse(code=200, message="Page changes saved"), @ApiResponse(code=403, message="Operation not allowed. User needs to be able to edit the resource.")})
    @PreAuthorize(value="hasRole('Administrator')")
    public void editPage(@PathVariable(value="language") String language, @PathVariable(value="pageId") String pageId, @RequestParam(value="data", required=false) MultipartFile data, @RequestParam(value="link", required=false) String link, @RequestParam(value="format", required=true) Page.PageFormat format, @ApiIgnore HttpServletResponse response) throws ResourceNotFoundException {
        this.checkValidLanguage(language);
        this.checkUniqueContent(data, link);
        this.checkCorrectFormat(data, link, format);
        Page page = this.searchPage(language, pageId, this.pageRepository);
        this.fillContent(data, link, page);
        page.setFormat(format);
        this.pageRepository.save((Object)page);
    }

    @ApiOperation(value="Edit a Page name and language", notes="<a href='http://geonetwork-opensource.org/manuals/trunk/eng/users/user-guide/define-static-pages/define-pages.html'>More info</a>", nickname="editPage")
    @RequestMapping(value={"/{language}/{pageId}"}, method={RequestMethod.PUT})
    @ApiResponses(value={@ApiResponse(code=200, message="Page changes saved"), @ApiResponse(code=403, message="Operation not allowed. User needs to be able to edit the resource.")})
    @PreAuthorize(value="hasRole('Administrator')")
    public void editPageName(@PathVariable(value="language") String language, @PathVariable(value="pageId") String pageId, @RequestParam(value="newLanguage", required=false) String newLanguage, @RequestParam(value="newPageId", required=false) String newPageId, @ApiIgnore HttpServletResponse response) throws ResourceNotFoundException, ResourceAlreadyExistException {
        this.checkValidLanguage(language);
        this.checkValidLanguage(newLanguage);
        Page page = (Page)this.pageRepository.findOne((Serializable)new PageIdentity(language, pageId));
        if (page == null) {
            throw new ResourceNotFoundException("Page " + pageId + " not found.");
        }
        if (!language.equals(newLanguage) || !pageId.equals(newPageId)) {
            String updatedPageId;
            String updatedLanguage = StringUtils.isBlank((String)newLanguage) ? language : newLanguage;
            Page newPage = (Page)this.pageRepository.findOne((Serializable)new PageIdentity(updatedLanguage, updatedPageId = StringUtils.isBlank((String)newPageId) ? pageId : newPageId));
            if (newPage != null) {
                throw new ResourceAlreadyExistException();
            }
            PageIdentity newId = new PageIdentity(updatedLanguage, updatedPageId);
            newPage = new Page(newId, page.getData(), page.getLink(), page.getFormat(), page.getSections(), page.getStatus());
            newPage.setSections(new ArrayList());
            for (Page.PageSection p : page.getSections()) {
                newPage.getSections().add(p);
            }
            this.pageRepository.save((Object)newPage);
            this.pageRepository.delete((Object)page);
        }
    }

    @ApiOperation(value="Delete a Page object", notes="<a href='http://geonetwork-opensource.org/manuals/trunk/eng/users/user-guide/define-static-pages/define-pages.html'>More info</a>", nickname="deletePage")
    @RequestMapping(value={"/{language}/{pageId}"}, method={RequestMethod.DELETE})
    @ApiResponses(value={@ApiResponse(code=200, message="Page removed"), @ApiResponse(code=404, message="Page not found"), @ApiResponse(code=403, message="Operation not allowed. User needs to be able to edit the resource.")})
    @PreAuthorize(value="hasRole('Administrator')")
    public void deletePage(@PathVariable(value="language") String language, @PathVariable(value="pageId") String pageId, @RequestParam(value="format", required=true) Page.PageFormat format, @ApiIgnore HttpServletResponse response) throws ResourceNotFoundException {
        this.searchPage(language, pageId, this.pageRepository);
        this.pageRepository.delete((Serializable)new PageIdentity(language, pageId));
    }

    @ApiOperation(value="Return the page object details except the content", notes="<a href='http://geonetwork-opensource.org/manuals/trunk/eng/users/user-guide/define-static-pages/define-pages.html'>More info</a>", nickname="getPage")
    @RequestMapping(value={"/{language}/{pageId}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ApiResponses(value={@ApiResponse(code=200, message="Page found"), @ApiResponse(code=404, message="Page not found"), @ApiResponse(code=403, message="Operation not allowed. User needs to be able to view the resource.")})
    @ResponseBody
    public ResponseEntity<PageJSONWrapper> getPage(@PathVariable(value="language") String language, @PathVariable(value="pageId") String pageId, @ApiIgnore HttpServletResponse response, @ApiIgnore HttpSession session) {
        Page page = (Page)this.pageRepository.findOne((Serializable)new PageIdentity(language, pageId));
        return this.checkPermissionsOnSinglePageAndReturn(session, page);
    }

    @ApiOperation(value="Return the static html content identified by pageId", notes="<a href='http://geonetwork-opensource.org/manuals/trunk/eng/users/user-guide/define-static-pages/define-pages.html'>More info</a>", nickname="getPage")
    @RequestMapping(value={"/{language}/{pageId}/content"}, method={RequestMethod.GET}, produces={"text/plain;charset=UTF-8"})
    @ApiResponses(value={@ApiResponse(code=200, message="Page found"), @ApiResponse(code=404, message="Page not found"), @ApiResponse(code=403, message="Operation not allowed. User needs to be able to view the resource.")})
    @ResponseBody
    public ResponseEntity<String> getPageContent(@PathVariable(value="language") String language, @PathVariable(value="pageId") String pageId, @ApiIgnore HttpServletResponse response, @ApiIgnore HttpSession session) {
        Page page = (Page)this.pageRepository.findOne((Serializable)new PageIdentity(language, pageId));
        if (page == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        UserSession us = ApiUtils.getUserSession(session);
        if (page.getStatus().equals((Object)Page.PageStatus.HIDDEN) && us.getProfile() != Profile.Administrator) {
            return new ResponseEntity(HttpStatus.FORBIDDEN);
        }
        if (page.getStatus().equals((Object)Page.PageStatus.PRIVATE) && (us.getProfile() == null || us.getProfile() == Profile.Guest)) {
            return new ResponseEntity(HttpStatus.FORBIDDEN);
        }
        String content = "";
        if (page.getData() != null && page.getData().length > 0) {
            try {
                content = new String(page.getData(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                content = new String(page.getData());
            }
        } else {
            content = page.getLink();
        }
        return new ResponseEntity((Object)content, HttpStatus.OK);
    }

    @ApiOperation(value="Adds the page to a section. This means that the link to the page will be shown in the list associated to that section.", notes="<a href='http://geonetwork-opensource.org/manuals/trunk/eng/users/user-guide/define-static-pages/define-pages.html'>More info</a>", nickname="addPageToSection")
    @RequestMapping(value={"/{language}/{pageId}/{section}"}, method={RequestMethod.POST})
    @ApiResponses(value={@ApiResponse(code=200, message="Page changes saved"), @ApiResponse(code=404, message="Page not found"), @ApiResponse(code=403, message="Operation not allowed. User needs to be able to edit the resource.")})
    @PreAuthorize(value="hasRole('Administrator')")
    public void addPageToSection(@PathVariable(value="language") String language, @PathVariable(value="pageId") String pageId, @PathVariable(value="section") Page.PageSection section, @ApiIgnore HttpServletResponse response) throws ResourceNotFoundException {
        Page page = (Page)this.pageRepository.findOne((Serializable)new PageIdentity(language, pageId));
        if (page == null) {
            throw new ResourceNotFoundException("Page " + pageId + " not found.");
        }
        Page.PageSection sectionToAdd = section;
        if (sectionToAdd.equals((Object)Page.PageSection.ALL)) {
            page.setSections(new ArrayList());
            page.getSections().add(sectionToAdd);
        } else if (!page.getSections().contains(sectionToAdd)) {
            page.getSections().add(sectionToAdd);
        }
        this.pageRepository.save((Object)page);
    }

    @ApiOperation(value="Removes the page from a section. This means that the link to the page will not be shown in the list associated to that section.", notes="<a href='http://geonetwork-opensource.org/manuals/trunk/eng/users/user-guide/define-static-pages/define-pages.html'>More info</a>", nickname="removePageFromSection")
    @RequestMapping(value={"/{language}/{pageId}/{section}"}, method={RequestMethod.DELETE})
    @ApiResponses(value={@ApiResponse(code=200, message="Page changes saved"), @ApiResponse(code=404, message="Page not found"), @ApiResponse(code=403, message="Operation not allowed. User needs to be able to edit the resource.")})
    @PreAuthorize(value="hasRole('Administrator')")
    public void removePageFromSection(@PathVariable(value="language") String language, @PathVariable(value="pageId") String pageId, @PathVariable(value="section") Page.PageSection section, @ApiIgnore HttpServletResponse response) throws ResourceNotFoundException {
        Page page = (Page)this.pageRepository.findOne((Serializable)new PageIdentity(language, pageId));
        if (page == null) {
            throw new ResourceNotFoundException("Page " + pageId + " not found.");
        }
        if (section.equals((Object)Page.PageSection.ALL)) {
            page.setSections(new ArrayList());
            page.getSections().add(Page.PageSection.DRAFT);
        } else if (!section.equals((Object)Page.PageSection.DRAFT) && page.getSections().contains(section)) {
            page.getSections().remove(section);
        }
        this.pageRepository.save((Object)page);
    }

    @ApiOperation(value="Changes the status of a page.", notes="<a href='http://geonetwork-opensource.org/manuals/trunk/eng/users/user-guide/define-static-pages/define-pages.html'>More info</a>", nickname="removePageFromSection")
    @RequestMapping(value={"/{language}/{pageId}/{status}"}, method={RequestMethod.PUT})
    @ApiResponses(value={@ApiResponse(code=200, message="Page changes saved"), @ApiResponse(code=404, message="Page not found"), @ApiResponse(code=403, message="Operation not allowed. User needs to be able to edit the resource.")})
    @PreAuthorize(value="hasRole('Administrator')")
    public void changePageStatus(@PathVariable(value="language") String language, @PathVariable(value="pageId") String pageId, @PathVariable(value="status") Page.PageStatus status, @ApiIgnore HttpServletResponse response) throws ResourceNotFoundException {
        Page page = (Page)this.pageRepository.findOne((Serializable)new PageIdentity(language, pageId));
        if (page == null) {
            throw new ResourceNotFoundException("Page " + pageId + " not found.");
        }
        page.setStatus(status);
        this.pageRepository.save((Object)page);
    }

    @ApiOperation(value="List all pages according to the filters", notes="<a href='http://geonetwork-opensource.org/manuals/trunk/eng/users/user-guide/define-static-pages/define-pages.html'>More info</a>", nickname="listPages")
    @RequestMapping(value={"/list"}, method={RequestMethod.GET}, produces={"application/json"})
    @ApiResponses(value={@ApiResponse(code=403, message="Operation not allowed. User needs to be able to view the resource.")})
    @ResponseBody
    public ResponseEntity<List<PageJSONWrapper>> listPages(@RequestParam(value="language", required=false) String language, @RequestParam(value="section", required=false) Page.PageSection section, @RequestParam(value="format", required=false) Page.PageFormat format, @ApiIgnore HttpServletResponse response, @ApiIgnore HttpSession session) {
        UserSession us = ApiUtils.getUserSession(session);
        List unfilteredResult = null;
        unfilteredResult = language == null ? this.pageRepository.findAll() : this.pageRepository.findByPageIdentityLanguage(language);
        ArrayList<PageJSONWrapper> filteredResult = new ArrayList<PageJSONWrapper>();
        for (Page page : unfilteredResult) {
            if (!(page.getStatus().equals((Object)Page.PageStatus.HIDDEN) && us.getProfile() == Profile.Administrator || page.getStatus().equals((Object)Page.PageStatus.PRIVATE) && us.getProfile() != null && us.getProfile() != Profile.Guest || page.getStatus().equals((Object)Page.PageStatus.PUBLIC)) && (!page.getStatus().equals((Object)Page.PageStatus.PUBLIC_ONLY) || us.isAuthenticated())) continue;
            if (section == null || Page.PageSection.ALL.equals((Object)section)) {
                filteredResult.add(new PageJSONWrapper(page));
                continue;
            }
            List sections = page.getSections();
            boolean containsALL = sections.contains(Page.PageSection.ALL);
            boolean containsRequestedSection = sections.contains(section);
            if (!containsALL && !containsRequestedSection) continue;
            filteredResult.add(new PageJSONWrapper(page));
        }
        return new ResponseEntity(filteredResult, HttpStatus.OK);
    }

    private void checkCorrectFormat(MultipartFile data, String link, Page.PageFormat format) {
        if (Page.PageFormat.LINK.equals((Object)format) && data != null && !data.isEmpty()) {
            throw new IllegalArgumentException("Wrong format.");
        }
        if (!Page.PageFormat.LINK.equals((Object)format) && !StringUtils.isBlank((String)link)) {
            throw new IllegalArgumentException("Wrong format.");
        }
    }

    private void checkMandatoryContent(MultipartFile data, String link) {
        if (StringUtils.isBlank((String)link) && (data == null || data.isEmpty())) {
            throw new IllegalArgumentException("A content associated to the page, a link or a file, is mandatory.");
        }
    }

    private void checkUniqueContent(MultipartFile data, String link) {
        if (!StringUtils.isBlank((String)link) && data != null && !data.isEmpty()) {
            throw new IllegalArgumentException("A content associated to the page, a link or a file, is mandatory. But is not possible to associate both to the same page.");
        }
    }

    private void checkFileType(MultipartFile data) {
        if (data != null) {
            String extension = FilenameUtils.getExtension((String)data.getOriginalFilename());
            Object[] supportedExtensions = new String[]{"html", "HTML", "txt", "TXT", "md", "MD"};
            if (!ArrayUtils.contains((Object[])supportedExtensions, (Object)extension)) {
                throw new MultipartException("Unsuppoted file type (only html, txt and md are allowed).");
            }
        }
    }

    private void checkValidLanguage(String language) {
        if (!this.languageUtils.getUiLanguages().contains(language)) {
            throw new IllegalArgumentException(String.format("Language value is not valid: %s. A valid application language is mandatory: %s.", language, String.join((CharSequence)",", this.languageUtils.getUiLanguages())));
        }
    }

    private ResponseEntity<PageJSONWrapper> checkPermissionsOnSinglePageAndReturn(HttpSession session, Page page) {
        if (page == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        UserSession us = ApiUtils.getUserSession(session);
        if (page.getStatus().equals((Object)Page.PageStatus.HIDDEN) && us.getProfile() != Profile.Administrator) {
            return new ResponseEntity(HttpStatus.FORBIDDEN);
        }
        if (page.getStatus().equals((Object)Page.PageStatus.PRIVATE) && (us.getProfile() == null || us.getProfile() == Profile.Guest)) {
            return new ResponseEntity(HttpStatus.FORBIDDEN);
        }
        return new ResponseEntity((Object)new PageJSONWrapper(page), HttpStatus.OK);
    }

    private Page searchPage(String language, String pageId, PageRepository pageRepository) throws ResourceNotFoundException {
        Page page = (Page)pageRepository.findOne((Serializable)new PageIdentity(language, pageId));
        if (page == null) {
            throw new ResourceNotFoundException("Page " + pageId + " not found");
        }
        return page;
    }

    private Page getEmptyHiddenDraftPage(String language, String pageId, Page.PageFormat format) {
        ArrayList<Page.PageSection> sections = new ArrayList<Page.PageSection>();
        sections.add(Page.PageSection.DRAFT);
        Page page = new Page(new PageIdentity(language, pageId), null, null, format, sections, Page.PageStatus.HIDDEN);
        return page;
    }

    private void fillContent(MultipartFile data, String link, Page page) {
        byte[] bytesData = null;
        if (data != null && !data.isEmpty()) {
            this.checkFileType(data);
            try {
                bytesData = data.getBytes();
            }
            catch (Exception e) {
                throw new WebApplicationException((Throwable)e);
            }
            page.setData(bytesData);
        }
        if (link != null && !UrlUtils.isValidRedirectUrl((String)link)) {
            throw new IllegalArgumentException("The link provided is not valid");
        }
        page.setLink(link);
    }
}

