/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.internal;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingObject;
import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import java.io.Closeable;
import org.jclouds.Context;
import org.jclouds.View;
import org.jclouds.location.Provider;
import org.jclouds.rest.ApiContext;
import org.jclouds.util.TypeTokenUtils;

public abstract class BaseView
extends ForwardingObject
implements View {
    private final Context backend;
    private final TypeToken<? extends Context> backendType;

    protected BaseView(@Provider Context backend, @Provider TypeToken<? extends Context> backendType) {
        this.backend = (Context)Preconditions.checkNotNull((Object)backend, (Object)"backend");
        this.backendType = (TypeToken)Preconditions.checkNotNull(backendType, (Object)"backendType");
    }

    @Override
    public <C extends Context> C unwrap(TypeToken<C> type) {
        Preconditions.checkArgument((boolean)TypeTokenUtils.isSupertypeOf((TypeToken)Preconditions.checkNotNull(type, (Object)"type"), this.backendType), (String)"%s is not a supertype of backend type %s", (Object[])new Object[]{type, this.backendType});
        return (C)this.backend;
    }

    public TypeToken<? extends Context> getBackendType() {
        return this.backendType;
    }

    @Override
    public <C extends Context> C unwrap() throws ClassCastException {
        return (C)this.unwrap(this.getBackendType());
    }

    @Override
    public <A extends Closeable> A unwrapApi(Class<A> apiClass) {
        Preconditions.checkArgument((boolean)ApiContext.class.isAssignableFrom(this.backendType.getRawType()), (String)"backend type: %s should be an ApiContext", (Object[])new Object[]{this.backendType});
        TypeToken contextToken = new TypeToken<ApiContext<? extends A>>(this.delegate().getClass()){
            private static final long serialVersionUID = 1L;
        }.where(new TypeParameter<A>(){}, TypeToken.of(apiClass));
        return (A)((Closeable)((ApiContext)this.unwrap(contextToken)).getApi());
    }

    protected Context delegate() {
        return this.backend;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseView that = (BaseView)BaseView.class.cast(o);
        return Objects.equal((Object)this.delegate(), (Object)that.delegate()) && Objects.equal(this.getBackendType(), that.getBackendType());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.delegate(), this.getBackendType()});
    }

    public String toString() {
        return this.string().toString();
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper((String)"").add("backend", (Object)this.delegate()).add("backendType", this.getBackendType());
    }
}

