/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import org.geotools.factory.CommonFactoryFinder;
import org.geotools.renderer.style.GraphicStyle2D;
import org.geotools.renderer.style.IconStyle2D;
import org.geotools.renderer.style.MarkStyle2D;
import org.geotools.renderer.style.SLDStyleFactory;
import org.geotools.renderer.style.Style2D;
import org.geotools.styling.Graphic;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.visitor.DpiRescaleStyleVisitor;
import org.geotools.util.Range;
import org.opengis.filter.expression.Expression;

public class GraphicsAwareDpiRescaleStyleVisitor
extends DpiRescaleStyleVisitor {
    static final StyleFactory sf = CommonFactoryFinder.getStyleFactory();
    static final Range<Double> INFINITE_RANGE = new Range(Double.class, (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(Double.POSITIVE_INFINITY));
    SLDStyleFactory ssf = new SLDStyleFactory();

    public GraphicsAwareDpiRescaleStyleVisitor(double scale) {
        super(scale);
    }

    @Override
    protected Expression rescaleGraphicSize(Graphic gr) {
        Expression size = gr.getSize();
        if (size == null || size == Expression.NIL) {
            PointSymbolizer symbolizer = sf.createPointSymbolizer(gr, null);
            Style2D style = this.ssf.createStyle(null, symbolizer, INFINITE_RANGE);
            if (style instanceof IconStyle2D) {
                IconStyle2D is = (IconStyle2D)style;
                size = this.ff.literal(is.getIcon().getIconHeight());
            } else if (style instanceof GraphicStyle2D) {
                GraphicStyle2D gs = (GraphicStyle2D)style;
                size = this.ff.literal(gs.getImage().getHeight());
            } else if (style instanceof MarkStyle2D) {
                MarkStyle2D ms = (MarkStyle2D)style;
                size = this.ff.literal(ms.getSize());
            }
        }
        return this.rescale(size);
    }
}

