/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.taxonomy.writercache;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.Iterator;
import org.apache.lucene.facet.taxonomy.FacetLabel;
import org.apache.lucene.facet.taxonomy.writercache.CategoryPathUtils;
import org.apache.lucene.facet.taxonomy.writercache.CharBlockArray;
import org.apache.lucene.facet.taxonomy.writercache.CollisionMap;
import org.apache.lucene.facet.taxonomy.writercache.LabelToOrdinal;

public class CompactLabelToOrdinal
extends LabelToOrdinal {
    public static final float DefaultLoadFactor = 0.15f;
    static final char TERMINATOR_CHAR = '\uffff';
    private static final int COLLISION = -5;
    private HashArray[] hashArrays;
    private CollisionMap collisionMap;
    private CharBlockArray labelRepository;
    private int capacity;
    private int threshold;
    private float loadFactor;

    public int sizeOfMap() {
        return this.collisionMap.size();
    }

    private CompactLabelToOrdinal() {
    }

    public CompactLabelToOrdinal(int initialCapacity, float loadFactor, int numHashArrays) {
        this.hashArrays = new HashArray[numHashArrays];
        this.capacity = CompactLabelToOrdinal.determineCapacity((int)Math.pow(2.0, numHashArrays), initialCapacity);
        this.init();
        this.collisionMap = new CollisionMap(this.labelRepository);
        this.counter = 0;
        this.loadFactor = loadFactor;
        this.threshold = (int)(this.loadFactor * (float)this.capacity);
    }

    static int determineCapacity(int minCapacity, int initialCapacity) {
        int capacity;
        for (capacity = minCapacity; capacity < initialCapacity; capacity <<= 1) {
        }
        return capacity;
    }

    private void init() {
        this.labelRepository = new CharBlockArray();
        CategoryPathUtils.serialize(new FacetLabel(new String[0]), this.labelRepository);
        int c = this.capacity;
        for (int i = 0; i < this.hashArrays.length; ++i) {
            this.hashArrays[i] = new HashArray(c);
            c /= 2;
        }
    }

    @Override
    public void addLabel(FacetLabel label, int ordinal) {
        if (this.collisionMap.size() > this.threshold) {
            this.grow();
        }
        int hash = CompactLabelToOrdinal.stringHashCode(label);
        for (int i = 0; i < this.hashArrays.length; ++i) {
            if (!this.addLabel(this.hashArrays[i], label, hash, ordinal)) continue;
            return;
        }
        int prevVal = this.collisionMap.addLabel(label, hash, ordinal);
        if (prevVal != ordinal) {
            throw new IllegalArgumentException("Label already exists: " + label + " prev ordinal " + prevVal);
        }
    }

    @Override
    public int getOrdinal(FacetLabel label) {
        if (label == null) {
            return -2;
        }
        int hash = CompactLabelToOrdinal.stringHashCode(label);
        for (int i = 0; i < this.hashArrays.length; ++i) {
            int ord = this.getOrdinal(this.hashArrays[i], label, hash);
            if (ord == -5) continue;
            return ord;
        }
        return this.collisionMap.get(label, hash);
    }

    private void grow() {
        int i;
        HashArray temp = this.hashArrays[this.hashArrays.length - 1];
        for (i = this.hashArrays.length - 1; i > 0; --i) {
            this.hashArrays[i] = this.hashArrays[i - 1];
        }
        this.capacity *= 2;
        this.hashArrays[0] = new HashArray(this.capacity);
        for (i = 1; i < this.hashArrays.length; ++i) {
            int[] sourceOffsetArray = this.hashArrays[i].offsets;
            int[] sourceCidsArray = this.hashArrays[i].cids;
            for (int k = 0; k < sourceOffsetArray.length; ++k) {
                for (int j = 0; j < i && sourceOffsetArray[k] != 0; ++j) {
                    int[] targetOffsetArray = this.hashArrays[j].offsets;
                    int[] targetCidsArray = this.hashArrays[j].cids;
                    int newIndex = CompactLabelToOrdinal.indexFor(CompactLabelToOrdinal.stringHashCode(this.labelRepository, sourceOffsetArray[k]), targetOffsetArray.length);
                    if (targetOffsetArray[newIndex] != 0) continue;
                    targetOffsetArray[newIndex] = sourceOffsetArray[k];
                    targetCidsArray[newIndex] = sourceCidsArray[k];
                    sourceOffsetArray[k] = 0;
                }
            }
        }
        for (i = 0; i < temp.offsets.length; ++i) {
            int offset = temp.offsets[i];
            if (offset <= 0) continue;
            int hash = CompactLabelToOrdinal.stringHashCode(this.labelRepository, offset);
            this.addLabelOffset(hash, temp.cids[i], offset);
        }
        CollisionMap oldCollisionMap = this.collisionMap;
        this.collisionMap = new CollisionMap(oldCollisionMap.capacity(), this.labelRepository);
        this.threshold = (int)((float)this.capacity * this.loadFactor);
        Iterator<CollisionMap.Entry> it = oldCollisionMap.entryIterator();
        while (it.hasNext()) {
            CollisionMap.Entry e = it.next();
            this.addLabelOffset(CompactLabelToOrdinal.stringHashCode(this.labelRepository, e.offset), e.cid, e.offset);
        }
    }

    private boolean addLabel(HashArray a, FacetLabel label, int hash, int ordinal) {
        int index = CompactLabelToOrdinal.indexFor(hash, a.offsets.length);
        int offset = a.offsets[index];
        if (offset == 0) {
            a.offsets[index] = this.labelRepository.length();
            CategoryPathUtils.serialize(label, this.labelRepository);
            a.cids[index] = ordinal;
            return true;
        }
        return false;
    }

    private void addLabelOffset(int hash, int cid, int knownOffset) {
        for (int i = 0; i < this.hashArrays.length; ++i) {
            if (!this.addLabelOffsetToHashArray(this.hashArrays[i], hash, cid, knownOffset)) continue;
            return;
        }
        this.collisionMap.addLabelOffset(hash, knownOffset, cid);
        if (this.collisionMap.size() > this.threshold) {
            this.grow();
        }
    }

    private boolean addLabelOffsetToHashArray(HashArray a, int hash, int ordinal, int knownOffset) {
        int index = CompactLabelToOrdinal.indexFor(hash, a.offsets.length);
        int offset = a.offsets[index];
        if (offset == 0) {
            a.offsets[index] = knownOffset;
            a.cids[index] = ordinal;
            return true;
        }
        return false;
    }

    private int getOrdinal(HashArray a, FacetLabel label, int hash) {
        if (label == null) {
            return -2;
        }
        int index = CompactLabelToOrdinal.indexFor(hash, a.offsets.length);
        int offset = a.offsets[index];
        if (offset == 0) {
            return -2;
        }
        if (CategoryPathUtils.equalsToSerialized(label, this.labelRepository, offset)) {
            return a.cids[index];
        }
        return -5;
    }

    static int indexFor(int h, int length) {
        return h & length - 1;
    }

    static int stringHashCode(FacetLabel label) {
        int hash = label.hashCode();
        hash ^= hash >>> 20 ^ hash >>> 12;
        hash = hash ^ hash >>> 7 ^ hash >>> 4;
        return hash;
    }

    static int stringHashCode(CharBlockArray labelRepository, int offset) {
        int hash = CategoryPathUtils.hashCodeOfSerialized(labelRepository, offset);
        hash ^= hash >>> 20 ^ hash >>> 12;
        hash = hash ^ hash >>> 7 ^ hash >>> 4;
        return hash;
    }

    int getMemoryUsage() {
        int memoryUsage = 0;
        if (this.hashArrays != null) {
            for (HashArray ha : this.hashArrays) {
                memoryUsage += ha.capacity * 2 * 4 + 4;
            }
        }
        if (this.labelRepository != null) {
            int blockSize = this.labelRepository.blockSize;
            int actualBlockSize = blockSize * 2 + 4;
            memoryUsage += this.labelRepository.blocks.size() * actualBlockSize;
            memoryUsage += 8;
        }
        if (this.collisionMap != null) {
            memoryUsage += this.collisionMap.getMemoryUsage();
        }
        return memoryUsage;
    }

    static CompactLabelToOrdinal open(File file, float loadFactor, int numHashArrays) throws IOException {
        CompactLabelToOrdinal l2o = new CompactLabelToOrdinal();
        l2o.loadFactor = loadFactor;
        l2o.hashArrays = new HashArray[numHashArrays];
        try (FilterInputStream dis = null;){
            int offset;
            dis = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
            l2o.counter = ((DataInputStream)dis).readInt();
            l2o.capacity = CompactLabelToOrdinal.determineCapacity((int)Math.pow(2.0, l2o.hashArrays.length), l2o.counter);
            l2o.init();
            l2o.labelRepository = CharBlockArray.open(dis);
            l2o.collisionMap = new CollisionMap(l2o.labelRepository);
            int cid = 0;
            int lastStartOffset = offset = 1;
            while (offset < l2o.labelRepository.length()) {
                int length;
                int hash = length = (int)l2o.labelRepository.charAt(offset++);
                if (length != 0) {
                    for (int i = 0; i < length; ++i) {
                        short len = (short)l2o.labelRepository.charAt(offset++);
                        hash = hash * 31 + l2o.labelRepository.subSequence(offset, offset + len).hashCode();
                        offset += len;
                    }
                }
                hash ^= hash >>> 20 ^ hash >>> 12;
                hash = hash ^ hash >>> 7 ^ hash >>> 4;
                l2o.addLabelOffset(hash, cid, lastStartOffset);
                ++cid;
                lastStartOffset = offset;
            }
        }
        l2o.threshold = (int)(l2o.loadFactor * (float)l2o.capacity);
        return l2o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flush(File file) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(file);){
            BufferedOutputStream os = new BufferedOutputStream(fos);
            DataOutputStream dos = new DataOutputStream(os);
            dos.writeInt(this.counter);
            this.labelRepository.flush(dos);
            dos.close();
        }
    }

    private static final class HashArray {
        int[] offsets;
        int[] cids;
        int capacity;

        HashArray(int c) {
            this.capacity = c;
            this.offsets = new int[this.capacity];
            this.cids = new int[this.capacity];
        }
    }
}

