/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security.openid;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Map;
import org.eclipse.jetty.security.openid.OpenIdConfiguration;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.UrlEncoded;
import org.eclipse.jetty.util.ajax.JSON;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class OpenIdCredentials
implements Serializable {
    private static final Logger LOG = Log.getLogger(OpenIdCredentials.class);
    private static final long serialVersionUID = 4766053233370044796L;
    private final String redirectUri;
    private final OpenIdConfiguration configuration;
    private String authCode;
    private Map<String, Object> response;
    private Map<String, Object> claims;

    public OpenIdCredentials(String authCode, String redirectUri, OpenIdConfiguration configuration) {
        this.authCode = authCode;
        this.redirectUri = redirectUri;
        this.configuration = configuration;
    }

    public String getUserId() {
        return (String)this.claims.get("sub");
    }

    public Map<String, Object> getClaims() {
        return this.claims;
    }

    public Map<String, Object> getResponse() {
        return this.response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redeemAuthCode() throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("redeemAuthCode() {}", new Object[]{this});
        }
        if (this.authCode != null) {
            try {
                String idToken;
                this.response = this.claimAuthCode(this.authCode);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("response: {}", new Object[]{this.response});
                }
                if ((idToken = (String)this.response.get("id_token")) == null) {
                    throw new IllegalArgumentException("no id_token");
                }
                String accessToken = (String)this.response.get("access_token");
                if (accessToken == null) {
                    throw new IllegalArgumentException("no access_token");
                }
                String tokenType = (String)this.response.get("token_type");
                if (!"Bearer".equalsIgnoreCase(tokenType)) {
                    throw new IllegalArgumentException("invalid token_type");
                }
                this.claims = this.decodeJWT(idToken);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("claims {}", new Object[]{this.claims});
                }
                this.validateClaims();
            }
            finally {
                this.authCode = null;
            }
        }
    }

    private void validateClaims() {
        if (!this.configuration.getIssuer().equals(this.claims.get("iss"))) {
            throw new IllegalArgumentException("Issuer Identifier MUST exactly match the iss Claim");
        }
        this.validateAudience();
        Object azp = this.claims.get("azp");
        if (azp != null && !this.configuration.getClientId().equals(azp)) {
            throw new IllegalArgumentException("Authorized party claim value should be the client_id");
        }
    }

    private void validateAudience() {
        boolean isValidType;
        Object aud = this.claims.get("aud");
        String clientId = this.configuration.getClientId();
        boolean isString = aud instanceof String;
        boolean isList = aud instanceof Object[];
        boolean bl = isValidType = isString || isList;
        if (isString && !clientId.equals(aud)) {
            throw new IllegalArgumentException("Audience Claim MUST contain the client_id value");
        }
        if (isList) {
            if (!Arrays.asList((Object[])aud).contains(clientId)) {
                throw new IllegalArgumentException("Audience Claim MUST contain the client_id value");
            }
            if (this.claims.get("azp") == null) {
                throw new IllegalArgumentException("A multi-audience ID token needs to contain an azp claim");
            }
        } else if (!isValidType) {
            throw new IllegalArgumentException("Audience claim was not valid");
        }
    }

    public boolean isExpired() {
        if (this.authCode != null || this.claims == null) {
            return true;
        }
        long expiry = (Long)this.claims.get("exp");
        long currentTimeSeconds = (long)((float)System.currentTimeMillis() / 1000.0f);
        if (currentTimeSeconds > expiry) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("OpenId Credentials expired {}", new Object[]{this});
            }
            return true;
        }
        return false;
    }

    protected Map<String, Object> decodeJWT(String jwt) throws IOException {
        String[] sections;
        if (LOG.isDebugEnabled()) {
            LOG.debug("decodeJWT {}", new Object[]{jwt});
        }
        if ((sections = jwt.split("\\.")).length != 3) {
            throw new IllegalArgumentException("JWT does not contain 3 sections");
        }
        Base64.Decoder decoder = Base64.getUrlDecoder();
        String jwtHeaderString = new String(decoder.decode(OpenIdCredentials.padJWTSection(sections[0])), StandardCharsets.UTF_8);
        String jwtClaimString = new String(decoder.decode(OpenIdCredentials.padJWTSection(sections[1])), StandardCharsets.UTF_8);
        String jwtSignature = sections[2];
        Map jwtHeader = (Map)JSON.parse((String)jwtHeaderString);
        LOG.debug("JWT Header: {}", new Object[]{jwtHeader});
        if (LOG.isDebugEnabled()) {
            LOG.debug("JWT signature not validated {}", new Object[]{jwtSignature});
        }
        return (Map)JSON.parse((String)jwtClaimString);
    }

    private static byte[] padJWTSection(String unpaddedEncodedJwtSection) {
        byte[] paddedEncodedJwtSection;
        int length = unpaddedEncodedJwtSection.length();
        int remainder = length % 4;
        if (remainder == 1) {
            throw new IllegalArgumentException("Not valid Base64-encoded string");
        }
        if (remainder > 0) {
            int paddingNeeded = (4 - remainder) % 4;
            paddedEncodedJwtSection = Arrays.copyOf(unpaddedEncodedJwtSection.getBytes(), length + paddingNeeded);
            Arrays.fill(paddedEncodedJwtSection, length, paddedEncodedJwtSection.length, (byte)61);
        } else {
            paddedEncodedJwtSection = unpaddedEncodedJwtSection.getBytes();
        }
        return paddedEncodedJwtSection;
    }

    private Map<String, Object> claimAuthCode(String authCode) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("claimAuthCode {}", new Object[]{authCode});
        }
        String urlParameters = "code=" + authCode + "&client_id=" + UrlEncoded.encodeString((String)this.configuration.getClientId(), (Charset)StandardCharsets.UTF_8) + "&client_secret=" + UrlEncoded.encodeString((String)this.configuration.getClientSecret(), (Charset)StandardCharsets.UTF_8) + "&redirect_uri=" + UrlEncoded.encodeString((String)this.redirectUri, (Charset)StandardCharsets.UTF_8) + "&grant_type=authorization_code";
        URL url = new URL(this.configuration.getTokenEndpoint());
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        try {
            Map map;
            block16: {
                connection.setDoOutput(true);
                connection.setRequestMethod("POST");
                connection.setRequestProperty("Host", this.configuration.getIssuer());
                connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                try (DataOutputStream wr = new DataOutputStream(connection.getOutputStream());){
                    wr.write(urlParameters.getBytes(StandardCharsets.UTF_8));
                }
                InputStream content = (InputStream)connection.getContent();
                try {
                    map = (Map)JSON.parse((String)IO.toString((InputStream)content));
                    if (content == null) break block16;
                }
                catch (Throwable throwable) {
                    if (content != null) {
                        try {
                            content.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                content.close();
            }
            return map;
        }
        finally {
            connection.disconnect();
        }
    }
}

