/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security.openid;

import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.ajax.JSON;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class OpenIdConfiguration
implements Serializable {
    private static final Logger LOG = Log.getLogger(OpenIdConfiguration.class);
    private static final long serialVersionUID = 2227941990601349102L;
    private static final String CONFIG_PATH = "/.well-known/openid-configuration";
    private final String issuer;
    private final String authEndpoint;
    private final String tokenEndpoint;
    private final String clientId;
    private final String clientSecret;
    private final List<String> scopes = new ArrayList<String>();

    public OpenIdConfiguration(String provider, String clientId, String clientSecret) {
        this(provider, null, null, clientId, clientSecret);
    }

    public OpenIdConfiguration(String issuer, String authorizationEndpoint, String tokenEndpoint, String clientId, String clientSecret) {
        this.issuer = issuer;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        if (issuer == null) {
            throw new IllegalArgumentException("Provider was not configured");
        }
        if (tokenEndpoint == null || authorizationEndpoint == null) {
            Map<String, Object> discoveryDocument = OpenIdConfiguration.fetchOpenIdConnectMetadata(issuer);
            this.authEndpoint = (String)discoveryDocument.get("authorization_endpoint");
            if (this.authEndpoint == null) {
                throw new IllegalArgumentException("authorization_endpoint");
            }
            this.tokenEndpoint = (String)discoveryDocument.get("token_endpoint");
            if (this.tokenEndpoint == null) {
                throw new IllegalArgumentException("token_endpoint");
            }
            if (!Objects.equals(discoveryDocument.get("issuer"), issuer)) {
                LOG.warn("The provider in the metadata is not correct.", new Object[0]);
            }
        } else {
            this.authEndpoint = authorizationEndpoint;
            this.tokenEndpoint = tokenEndpoint;
        }
    }

    private static Map<String, Object> fetchOpenIdConnectMetadata(String provider) {
        try {
            if (provider.endsWith("/")) {
                provider = provider.substring(0, provider.length() - 1);
            }
            URI providerUri = URI.create(provider + CONFIG_PATH);
            InputStream inputStream = providerUri.toURL().openConnection().getInputStream();
            String content = IO.toString((InputStream)inputStream);
            Map discoveryDocument = (Map)JSON.parse((String)content);
            if (LOG.isDebugEnabled()) {
                LOG.debug("discovery document {}", new Object[]{discoveryDocument});
            }
            return discoveryDocument;
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("invalid identity provider", e);
        }
    }

    public String getAuthEndpoint() {
        return this.authEndpoint;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public String getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    public void addScopes(String ... scopes) {
        if (scopes != null) {
            Collections.addAll(this.scopes, scopes);
        }
    }

    public List<String> getScopes() {
        return this.scopes;
    }
}

