/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml;

import org.geotools.gml.GMLHandlerGeometry;
import org.geotools.gml.GMLHandlerJTS;
import org.geotools.gml.SubHandler;
import org.geotools.gml.SubHandlerFactory;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.XMLFilterImpl;

public class GMLFilterGeometry
extends XMLFilterImpl
implements GMLHandlerGeometry {
    private GMLHandlerJTS parent;
    private GeometryFactory geometryFactory = new GeometryFactory();
    private SubHandlerFactory handlerFactory = new SubHandlerFactory();
    private SubHandler currentHandler;

    public GMLFilterGeometry(GMLHandlerJTS parent) {
        this.parent = parent;
    }

    @Override
    public void geometryStart(String localName, Attributes atts) throws SAXException {
        String srs = null;
        for (int i = 0; i < atts.getLength(); ++i) {
            String NAME = atts.getQName(i);
            if (!"srs".equalsIgnoreCase(NAME)) continue;
            srs = atts.getValue(i);
        }
        if (this.currentHandler == null) {
            this.currentHandler = this.handlerFactory.create(localName);
        } else {
            this.currentHandler.subGeometry(localName, 1);
        }
        this.currentHandler.setSRS(srs);
    }

    @Override
    public void geometryEnd(String localName) throws SAXException {
        if (this.currentHandler.isComplete(localName)) {
            this.parent.geometry(this.currentHandler.create(this.geometryFactory));
            this.currentHandler = null;
        } else {
            this.currentHandler.subGeometry(localName, 2);
        }
    }

    @Override
    public void geometrySub(String localName) throws SAXException {
        this.currentHandler.subGeometry(localName, 3);
    }

    @Override
    public void gmlCoordinates(double x, double y) throws SAXException {
        this.currentHandler.addCoordinate(new Coordinate(x, y));
    }

    @Override
    public void gmlCoordinates(double x, double y, double z) throws SAXException {
        this.currentHandler.addCoordinate(new Coordinate(x, y, z));
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.parent.startElement(namespaceURI, localName, qName, atts);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.parent.characters(ch, start, length);
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.parent.endElement(namespaceURI, localName, qName);
    }
}

