/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.Adapter;
import bak.pcj.IntCollection;
import bak.pcj.adapter.CollectionToIntCollectionAdapter;
import bak.pcj.adapter.SetToShortSetAdapter;
import bak.pcj.map.AbstractShortKeyIntMap;
import bak.pcj.map.MapDefaults;
import bak.pcj.map.ShortKeyIntMap;
import bak.pcj.map.ShortKeyIntMapIterator;
import bak.pcj.set.ShortSet;
import bak.pcj.util.Exceptions;
import java.util.Iterator;
import java.util.Map;

public class MapToShortKeyIntMapAdapter
extends AbstractShortKeyIntMap
implements ShortKeyIntMap {
    protected Map map;
    protected Integer lastValue;

    public MapToShortKeyIntMapAdapter(Map map) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
    }

    public MapToShortKeyIntMapAdapter(Map map, boolean validate) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
        if (validate) {
            this.evalidate();
        }
    }

    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(short key) {
        this.lastValue = (Integer)this.map.get(new Short(key));
        return this.lastValue != null;
    }

    public boolean containsValue(int value) {
        return this.map.containsValue(new Integer(value));
    }

    public ShortKeyIntMapIterator entries() {
        return new ShortKeyIntMapIterator(){
            Iterator i;
            Map.Entry lastEntry;
            {
                this.i = MapToShortKeyIntMapAdapter.this.map.entrySet().iterator();
                this.lastEntry = null;
            }

            public boolean hasNext() {
                return this.i.hasNext();
            }

            public void next() {
                this.lastEntry = (Map.Entry)this.i.next();
            }

            public short getKey() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return (Short)this.lastEntry.getKey();
            }

            public int getValue() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return (Integer)this.lastEntry.getValue();
            }

            public void remove() {
                this.i.remove();
                this.lastEntry = null;
            }
        };
    }

    public int get(short key) {
        Integer value = (Integer)this.map.get(new Short(key));
        return value == null ? MapDefaults.defaultInt() : value;
    }

    public ShortSet keySet() {
        return new SetToShortSetAdapter(this.map.keySet());
    }

    public int lget() {
        if (this.lastValue == null) {
            Exceptions.noLastElement();
        }
        return this.lastValue;
    }

    public int put(short key, int value) {
        Integer oldValue = this.map.put(new Short(key), new Integer(value));
        return oldValue == null ? MapDefaults.defaultInt() : oldValue;
    }

    public int remove(short key) {
        Integer value = (Integer)this.map.remove(new Short(key));
        return value == null ? MapDefaults.defaultInt() : value;
    }

    public int size() {
        return this.map.size();
    }

    public IntCollection values() {
        return new CollectionToIntCollectionAdapter(this.map.values());
    }

    public int tget(short key) {
        Integer value = (Integer)this.map.get(new Short(key));
        if (value == null) {
            Exceptions.noSuchMapping(String.valueOf(key));
        }
        return value;
    }

    public boolean validate() {
        return Adapter.isShortKeyIntAdaptable(this.map);
    }

    public void evalidate() {
        if (!this.validate()) {
            Exceptions.cannotAdapt("map");
        }
    }
}

