/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.Adapter;
import bak.pcj.DoubleCollection;
import bak.pcj.adapter.CollectionToDoubleCollectionAdapter;
import bak.pcj.adapter.SetToFloatSetAdapter;
import bak.pcj.map.AbstractFloatKeyDoubleMap;
import bak.pcj.map.FloatKeyDoubleMap;
import bak.pcj.map.FloatKeyDoubleMapIterator;
import bak.pcj.map.MapDefaults;
import bak.pcj.set.FloatSet;
import bak.pcj.util.Exceptions;
import java.util.Iterator;
import java.util.Map;

public class MapToFloatKeyDoubleMapAdapter
extends AbstractFloatKeyDoubleMap
implements FloatKeyDoubleMap {
    protected Map map;
    protected Double lastValue;

    public MapToFloatKeyDoubleMapAdapter(Map map) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
    }

    public MapToFloatKeyDoubleMapAdapter(Map map, boolean validate) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
        if (validate) {
            this.evalidate();
        }
    }

    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(float key) {
        this.lastValue = (Double)this.map.get(new Float(key));
        return this.lastValue != null;
    }

    public boolean containsValue(double value) {
        return this.map.containsValue(new Double(value));
    }

    public FloatKeyDoubleMapIterator entries() {
        return new FloatKeyDoubleMapIterator(){
            Iterator i;
            Map.Entry lastEntry;
            {
                this.i = MapToFloatKeyDoubleMapAdapter.this.map.entrySet().iterator();
                this.lastEntry = null;
            }

            public boolean hasNext() {
                return this.i.hasNext();
            }

            public void next() {
                this.lastEntry = (Map.Entry)this.i.next();
            }

            public float getKey() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return ((Float)this.lastEntry.getKey()).floatValue();
            }

            public double getValue() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return (Double)this.lastEntry.getValue();
            }

            public void remove() {
                this.i.remove();
                this.lastEntry = null;
            }
        };
    }

    public double get(float key) {
        Double value = (Double)this.map.get(new Float(key));
        return value == null ? MapDefaults.defaultDouble() : value;
    }

    public FloatSet keySet() {
        return new SetToFloatSetAdapter(this.map.keySet());
    }

    public double lget() {
        if (this.lastValue == null) {
            Exceptions.noLastElement();
        }
        return this.lastValue;
    }

    public double put(float key, double value) {
        Double oldValue = this.map.put(new Float(key), new Double(value));
        return oldValue == null ? MapDefaults.defaultDouble() : oldValue;
    }

    public double remove(float key) {
        Double value = (Double)this.map.remove(new Float(key));
        return value == null ? MapDefaults.defaultDouble() : value;
    }

    public int size() {
        return this.map.size();
    }

    public DoubleCollection values() {
        return new CollectionToDoubleCollectionAdapter(this.map.values());
    }

    public double tget(float key) {
        Double value = (Double)this.map.get(new Float(key));
        if (value == null) {
            Exceptions.noSuchMapping(String.valueOf(key));
        }
        return value;
    }

    public boolean validate() {
        return Adapter.isFloatKeyDoubleAdaptable(this.map);
    }

    public void evalidate() {
        if (!this.validate()) {
            Exceptions.cannotAdapt("map");
        }
    }
}

